/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.zeromq.Utils;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZFrame {
    private static Charset ENCODING = Charset.forName("UTF-8");
    private byte[] data;
    private boolean more;
    private int capacity;
    private ByteBuffer buffer;

    public ZFrame() {
    }

    public ZFrame(byte[] data) {
        Utils.checkNotNull(data);
        this.init(data);
    }

    public ZFrame(ByteBuffer buffer) {
        Utils.checkNotNull(buffer);
        if (buffer.hasArray()) {
            this.data = buffer.array();
        }
        this.capacity = buffer.capacity();
        this.buffer = buffer;
    }

    public ZFrame(String data) {
        Utils.checkNotNull(data);
        this.init(data.getBytes(ENCODING));
    }

    private void init(byte[] data) {
        this.data = data;
        this.buffer = ByteBuffer.wrap(this.data);
        this.capacity = this.data.length;
    }

    public int capacity() {
        return this.capacity;
    }

    public void destroy() {
        this.data = null;
        this.buffer = null;
        this.capacity = 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean hasMore() {
        return this.more;
    }

    public int size() {
        return this.hasData() ? this.data.length : 0;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean send(ZMQ.Socket socket, int flags) {
        return socket.send(this.hasData() ? this.data : new byte[]{}, flags);
    }

    public ZFrame duplicate() {
        int length = this.size();
        byte[] copy = new byte[length];
        System.arraycopy(this.data, 0, copy, 0, length);
        ZFrame frame = new ZFrame();
        frame.data = copy;
        if (this.buffer != null) {
            frame.buffer = this.buffer.duplicate();
        }
        frame.more = this.more;
        return frame;
    }

    public void reset(byte[] data) {
        this.init(data);
    }

    public void reset(String data) {
        this.reset(data.getBytes(ENCODING));
    }

    public String strhex() {
        String hexChar = "0123456789ABCDEF";
        StringBuilder b = new StringBuilder();
        for (int nbr = 0; nbr < this.data.length; ++nbr) {
            int b1 = this.data[nbr] >>> 4 & 0xF;
            int b2 = this.data[nbr] & 0xF;
            b.append(hexChar.charAt(b1));
            b.append(hexChar.charAt(b2));
        }
        return b.toString();
    }

    public boolean streq(String str) {
        if (!this.hasData()) {
            return false;
        }
        return new String(this.data).compareTo(str) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZFrame zFrame = (ZFrame)o;
        return Arrays.equals(this.data, zFrame.data);
    }

    public int hashCode() {
        int hashcode = Arrays.hashCode(this.data);
        return hashcode += this.more ? 1231 : 1237;
    }

    public String toString() {
        if (!this.hasData()) {
            return "";
        }
        boolean isText = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] >= 32 && this.data[i] <= 127) continue;
            isText = false;
        }
        if (isText) {
            return new String(this.data);
        }
        return this.strhex();
    }

    private byte[] recv(ZMQ.Socket socket, int flags) {
        try {
            this.data = socket.recv(flags);
            this.more = socket.hasReceiveMore();
        }
        catch (ZMQException e) {
            ZMQ.Error error = ZMQ.Error.findByCode(e.getErrorCode());
            if (error == ZMQ.Error.ETERM || error == ZMQ.Error.ENOTSOCK) {
                this.data = null;
                this.more = false;
            }
            throw e;
        }
        return this.data;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket) {
        return ZFrame.recvFrame(socket, 0);
    }

    public static ZFrame recvFrame(ZMQ.Socket socket, int flags) {
        ZFrame f = new ZFrame();
        byte[] data = f.recv(socket, flags);
        if (data == null) {
            f = null;
        }
        return f;
    }
}

