/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.keystore;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;

public abstract class KeyStoreReader {
    private static final String DEFAULT_PASSWORD = "changeit";
    public static final String DEFAULT_KEYSTORE_FILE_NAME = "cacerts.jks";

    public static KeyStore getKeyStore(String fileName, String password, String configDir, boolean allowMissingPasswordToRead) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (fileName == null || fileName.length() == 0) {
            fileName = configDir + File.separator + DEFAULT_KEYSTORE_FILE_NAME;
        }
        KeyStore returnValue = KeyStoreReader.readKeyStoreFile(fileName, password, allowMissingPasswordToRead);
        return returnValue;
    }

    public static KeyStore readKeyStoreFile(String fileName, String password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        return KeyStoreReader.readKeyStoreFile(fileName, password, true);
    }

    public static KeyStore readKeyStoreFile(String fileName, String password, boolean allowMissingPasswordToRead) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        File keystoreFile = new File(fileName);
        FileInputStream fis = new FileInputStream(keystoreFile);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            keystore.load(fis, password != null ? password.toCharArray() : null);
        }
        catch (IOException e) {
            if (password != null && password.length() == 0 && allowMissingPasswordToRead) {
                fis = new FileInputStream(keystoreFile);
                keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(fis, null);
            }
            throw e;
        }
        return keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        String password;
        String outFileName;
        String inFileName;
        String string = inFileName = args.length > 0 ? args[0] : KeyStoreReader.readUserInput("Enter input keystore file name: ").trim();
        if (inFileName == null || inFileName.length() == 0) {
            System.out.println("Input keystore file name missing");
            return;
        }
        String string2 = outFileName = args.length > 1 ? args[1] : KeyStoreReader.readUserInput("Enter output agent truststore file name: ").trim();
        if (outFileName == null || outFileName.length() == 0) {
            System.out.println("Output truststore file name missing");
            return;
        }
        String string3 = password = args.length > 2 ? args[2] : KeyStoreReader.readUserInput("Enter password for keystore files").trim();
        if (password.length() == 0) {
            password = null;
        }
        String outPassword = password != null ? password : DEFAULT_PASSWORD;
        KeyStore fromKeyStore = KeyStoreReader.readKeyStoreFile(inFileName, password);
        KeyStore toKeyStore = KeyStore.getInstance(fromKeyStore.getType(), fromKeyStore.getProvider());
        toKeyStore.load(null, password != null ? password.toCharArray() : null);
        Enumeration<String> aliases = fromKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            String nextAlias = aliases.nextElement();
            Certificate certificate = fromKeyStore.getCertificate(nextAlias);
            toKeyStore.setCertificateEntry(nextAlias, certificate);
        }
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(outFileName));
            toKeyStore.store(bos, outPassword.toCharArray());
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
        System.out.println("Certificates from keystore file " + inFileName + " have been copied to " + outFileName);
    }

    private static String readUserInput(String prompt) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            System.out.print(prompt + " ");
            line = br.readLine();
        }
        catch (IOException ioe) {
            System.exit(1);
        }
        return line;
    }
}

