/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.analysis;

import com.appdynamics.org.apache.commons.math.FunctionEvaluationException;
import com.appdynamics.org.apache.commons.math.analysis.BivariateRealFunction;
import com.appdynamics.org.apache.commons.math.analysis.ComposableFunction;

public abstract class BinaryFunction
implements BivariateRealFunction {
    public static final BinaryFunction ADD = new BinaryFunction(){

        public double value(double x, double y) {
            return x + y;
        }
    };
    public static final BinaryFunction SUBTRACT = new BinaryFunction(){

        public double value(double x, double y) {
            return x - y;
        }
    };
    public static final BinaryFunction MULTIPLY = new BinaryFunction(){

        public double value(double x, double y) {
            return x * y;
        }
    };
    public static final BinaryFunction DIVIDE = new BinaryFunction(){

        public double value(double x, double y) {
            return x / y;
        }
    };
    public static final BinaryFunction POW = new BinaryFunction(){

        public double value(double x, double y) {
            return Math.pow(x, y);
        }
    };
    public static final BinaryFunction ATAN2 = new BinaryFunction(){

        public double value(double x, double y) {
            return Math.atan2(x, y);
        }
    };

    public abstract double value(double var1, double var3) throws FunctionEvaluationException;

    public ComposableFunction fix1stArgument(final double fixedX) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return BinaryFunction.this.value(fixedX, x);
            }
        };
    }

    public ComposableFunction fix2ndArgument(final double fixedY) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return BinaryFunction.this.value(x, fixedY);
            }
        };
    }
}

