/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.analysis.interpolation;

import com.appdynamics.org.apache.commons.math.MathRuntimeException;
import com.appdynamics.org.apache.commons.math.analysis.BivariateRealFunction;

class BicubicSplineFunction
implements BivariateRealFunction {
    private final double a00;
    private final double a01;
    private final double a02;
    private final double a03;
    private final double a10;
    private final double a11;
    private final double a12;
    private final double a13;
    private final double a20;
    private final double a21;
    private final double a22;
    private final double a23;
    private final double a30;
    private final double a31;
    private final double a32;
    private final double a33;

    public BicubicSplineFunction(double[] a) {
        this.a00 = a[0];
        this.a10 = a[1];
        this.a20 = a[2];
        this.a30 = a[3];
        this.a01 = a[4];
        this.a11 = a[5];
        this.a21 = a[6];
        this.a31 = a[7];
        this.a02 = a[8];
        this.a12 = a[9];
        this.a22 = a[10];
        this.a32 = a[11];
        this.a03 = a[12];
        this.a13 = a[13];
        this.a23 = a[14];
        this.a33 = a[15];
    }

    public double value(double x, double y) {
        if (x < 0.0 || x > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", x, 0, 1);
        }
        if (y < 0.0 || y > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", y, 0, 1);
        }
        double x2 = x * x;
        double x3 = x2 * x;
        double y2 = y * y;
        double y3 = y2 * y;
        return this.a00 + this.a01 * y + this.a02 * y2 + this.a03 * y3 + this.a10 * x + this.a11 * x * y + this.a12 * x * y2 + this.a13 * x * y3 + this.a20 * x2 + this.a21 * x2 * y + this.a22 * x2 * y2 + this.a23 * x2 * y3 + this.a30 * x3 + this.a31 * x3 * y + this.a32 * x3 * y2 + this.a33 * x3 * y3;
    }
}

