/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.analysis.interpolation;

import com.appdynamics.org.apache.commons.math.DimensionMismatchException;
import com.appdynamics.org.apache.commons.math.MathException;
import com.appdynamics.org.apache.commons.math.MathRuntimeException;
import com.appdynamics.org.apache.commons.math.analysis.BivariateRealFunction;
import com.appdynamics.org.apache.commons.math.analysis.UnivariateRealFunction;
import com.appdynamics.org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import com.appdynamics.org.apache.commons.math.analysis.interpolation.BivariateRealGridInterpolator;
import com.appdynamics.org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import com.appdynamics.org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import com.appdynamics.org.apache.commons.math.util.MathUtils;

public class SmoothingBicubicSplineInterpolator
implements BivariateRealGridInterpolator {
    public BivariateRealFunction interpolate(double[] xval, double[] yval, double[][] zval) throws MathException, IllegalArgumentException {
        int i;
        if (xval.length == 0 || yval.length == 0 || zval.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException("no data", new Object[0]);
        }
        if (xval.length != zval.length) {
            throw new DimensionMismatchException(xval.length, zval.length);
        }
        MathUtils.checkOrder(xval, 1, true);
        MathUtils.checkOrder(yval, 1, true);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] zX = new double[yLen][xLen];
        for (int i2 = 0; i2 < xLen; ++i2) {
            if (zval[i2].length != yLen) {
                throw new DimensionMismatchException(zval[i2].length, yLen);
            }
            for (int j = 0; j < yLen; ++j) {
                zX[j][i2] = zval[i2][j];
            }
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        for (int j = 0; j < yLen; ++j) {
            ySplineX[j] = spInterpolator.interpolate(xval, zX[j]);
        }
        double[][] zY_1 = new double[xLen][yLen];
        for (int j = 0; j < yLen; ++j) {
            PolynomialSplineFunction f = ySplineX[j];
            for (i = 0; i < xLen; ++i) {
                zY_1[i][j] = f.value(xval[i]);
            }
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        for (int i3 = 0; i3 < xLen; ++i3) {
            xSplineY[i3] = spInterpolator.interpolate(yval, zY_1[i3]);
        }
        double[][] zY_2 = new double[xLen][yLen];
        for (i = 0; i < xLen; ++i) {
            PolynomialSplineFunction f = xSplineY[i];
            for (int j = 0; j < yLen; ++j) {
                zY_2[i][j] = f.value(yval[j]);
            }
        }
        double[][] dZdX = new double[xLen][yLen];
        for (int j = 0; j < yLen; ++j) {
            UnivariateRealFunction f = ySplineX[j].derivative();
            for (int i4 = 0; i4 < xLen; ++i4) {
                dZdX[i4][j] = f.value(xval[i4]);
            }
        }
        double[][] dZdY = new double[xLen][yLen];
        for (int i5 = 0; i5 < xLen; ++i5) {
            UnivariateRealFunction f = xSplineY[i5].derivative();
            for (int j = 0; j < yLen; ++j) {
                dZdY[i5][j] = f.value(yval[j]);
            }
        }
        double[][] dZdXdY = new double[xLen][yLen];
        for (int i6 = 0; i6 < xLen; ++i6) {
            int nI = this.nextIndex(i6, xLen);
            int pI = this.previousIndex(i6);
            for (int j = 0; j < yLen; ++j) {
                int nJ = this.nextIndex(j, yLen);
                int pJ = this.previousIndex(j);
                dZdXdY[i6][j] = (zY_2[nI][nJ] - zY_2[nI][pJ] - zY_2[pI][nJ] + zY_2[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
            }
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, zY_2, dZdX, dZdY, dZdXdY);
    }

    private int nextIndex(int i, int max) {
        int index = i + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i) {
        int index = i - 1;
        return index >= 0 ? index : 0;
    }
}

