/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.ode.jacobians;

import com.appdynamics.org.apache.commons.math.MathRuntimeException;
import com.appdynamics.org.apache.commons.math.MaxEvaluationsExceededException;
import com.appdynamics.org.apache.commons.math.ode.DerivativeException;
import com.appdynamics.org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import com.appdynamics.org.apache.commons.math.ode.FirstOrderIntegrator;
import com.appdynamics.org.apache.commons.math.ode.IntegratorException;
import com.appdynamics.org.apache.commons.math.ode.events.EventException;
import com.appdynamics.org.apache.commons.math.ode.events.EventHandler;
import com.appdynamics.org.apache.commons.math.ode.jacobians.EventHandlerWithJacobians;
import com.appdynamics.org.apache.commons.math.ode.jacobians.ODEWithJacobians;
import com.appdynamics.org.apache.commons.math.ode.jacobians.ParameterizedODE;
import com.appdynamics.org.apache.commons.math.ode.jacobians.StepHandlerWithJacobians;
import com.appdynamics.org.apache.commons.math.ode.jacobians.StepInterpolatorWithJacobians;
import com.appdynamics.org.apache.commons.math.ode.sampling.StepHandler;
import com.appdynamics.org.apache.commons.math.ode.sampling.StepInterpolator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstOrderIntegratorWithJacobians {
    private final FirstOrderIntegrator integrator;
    private final ODEWithJacobians ode;
    private int maxEvaluations;
    private int evaluations;

    public FirstOrderIntegratorWithJacobians(FirstOrderIntegrator integrator, ParameterizedODE ode, double[] p, double[] hY, double[] hP) {
        this.checkDimension(ode.getDimension(), hY);
        this.checkDimension(ode.getParametersDimension(), p);
        this.checkDimension(ode.getParametersDimension(), hP);
        this.integrator = integrator;
        this.ode = new FiniteDifferencesWrapper(ode, p, hY, hP);
        this.setMaxEvaluations(-1);
    }

    public FirstOrderIntegratorWithJacobians(FirstOrderIntegrator integrator, ODEWithJacobians ode) {
        this.integrator = integrator;
        this.ode = ode;
        this.setMaxEvaluations(-1);
    }

    public void addStepHandler(StepHandlerWithJacobians handler) {
        int n = this.ode.getDimension();
        int k = this.ode.getParametersDimension();
        this.integrator.addStepHandler(new StepHandlerWrapper(handler, n, k));
    }

    public Collection<StepHandlerWithJacobians> getStepHandlers() {
        ArrayList<StepHandlerWithJacobians> handlers = new ArrayList<StepHandlerWithJacobians>();
        for (StepHandler handler : this.integrator.getStepHandlers()) {
            if (!(handler instanceof StepHandlerWrapper)) continue;
            handlers.add(((StepHandlerWrapper)handler).getHandler());
        }
        return handlers;
    }

    public void clearStepHandlers() {
        this.integrator.clearStepHandlers();
    }

    public void addEventHandler(EventHandlerWithJacobians handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        int n = this.ode.getDimension();
        int k = this.ode.getParametersDimension();
        this.integrator.addEventHandler(new EventHandlerWrapper(handler, n, k), maxCheckInterval, convergence, maxIterationCount);
    }

    public Collection<EventHandlerWithJacobians> getEventHandlers() {
        ArrayList<EventHandlerWithJacobians> handlers = new ArrayList<EventHandlerWithJacobians>();
        for (EventHandler handler : this.integrator.getEventHandlers()) {
            if (!(handler instanceof EventHandlerWrapper)) continue;
            handlers.add(((EventHandlerWrapper)handler).getHandler());
        }
        return handlers;
    }

    public void clearEventHandlers() {
        this.integrator.clearEventHandlers();
    }

    public double integrate(double t0, double[] y0, double[][] dY0dP, double t, double[] y, double[][] dYdY0, double[][] dYdP) throws DerivativeException, IntegratorException {
        int n = this.ode.getDimension();
        int k = this.ode.getParametersDimension();
        this.checkDimension(n, y0);
        this.checkDimension(n, y);
        this.checkDimension(n, dYdY0);
        this.checkDimension(n, dYdY0[0]);
        if (k != 0) {
            this.checkDimension(n, dY0dP);
            this.checkDimension(k, dY0dP[0]);
            this.checkDimension(n, dYdP);
            this.checkDimension(k, dYdP[0]);
        }
        double[] z = new double[n * (1 + n + k)];
        System.arraycopy(y0, 0, z, 0, n);
        for (int i = 0; i < n; ++i) {
            z[i * (1 + n) + n] = 1.0;
            System.arraycopy(dY0dP[i], 0, z, n * (n + 1) + i * k, k);
        }
        this.evaluations = 0;
        double stopTime = this.integrator.integrate(new MappingWrapper(), t0, z, t, z);
        FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, y, dYdY0, dYdP);
        return stopTime;
    }

    private static void dispatchCompoundState(double[] z, double[] y, double[][] dydy0, double[][] dydp) {
        int i;
        int n = y.length;
        int k = dydp[0].length;
        System.arraycopy(z, 0, y, 0, n);
        for (i = 0; i < n; ++i) {
            System.arraycopy(z, n * (i + 1), dydy0[i], 0, n);
        }
        for (i = 0; i < n; ++i) {
            System.arraycopy(z, n * (n + 1) + i * k, dydp[i], 0, k);
        }
    }

    public double getCurrentStepStart() {
        return this.integrator.getCurrentStepStart();
    }

    public double getCurrentSignedStepsize() {
        return this.integrator.getCurrentSignedStepsize();
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    private void checkDimension(int expected, Object array) throws IllegalArgumentException {
        int arrayDimension;
        int n = arrayDimension = array == null ? 0 : Array.getLength(array);
        if (arrayDimension != expected) {
            throw MathRuntimeException.createIllegalArgumentException("dimension mismatch {0} != {1}", arrayDimension, expected);
        }
    }

    private static class EventHandlerWrapper
    implements EventHandler {
        private final EventHandlerWithJacobians handler;
        private double[] y;
        private double[][] dydy0;
        private double[][] dydp;

        public EventHandlerWrapper(EventHandlerWithJacobians handler, int n, int k) {
            this.handler = handler;
            this.y = new double[n];
            this.dydy0 = new double[n][n];
            this.dydp = new double[n][k];
        }

        public EventHandlerWithJacobians getHandler() {
            return this.handler;
        }

        public int eventOccurred(double t, double[] z, boolean increasing) throws EventException {
            FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, this.y, this.dydy0, this.dydp);
            return this.handler.eventOccurred(t, this.y, this.dydy0, this.dydp, increasing);
        }

        public double g(double t, double[] z) throws EventException {
            FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, this.y, this.dydy0, this.dydp);
            return this.handler.g(t, this.y, this.dydy0, this.dydp);
        }

        public void resetState(double t, double[] z) throws EventException {
            FirstOrderIntegratorWithJacobians.dispatchCompoundState(z, this.y, this.dydy0, this.dydp);
            this.handler.resetState(t, this.y, this.dydy0, this.dydp);
        }
    }

    private static class StepInterpolatorWrapper
    implements StepInterpolatorWithJacobians {
        private StepInterpolator interpolator;
        private double[] y;
        private double[][] dydy0;
        private double[][] dydp;
        private double[] yDot;
        private double[][] dydy0Dot;
        private double[][] dydpDot;

        public StepInterpolatorWrapper() {
        }

        public StepInterpolatorWrapper(StepInterpolator interpolator, int n, int k) {
            this.interpolator = interpolator;
            this.y = new double[n];
            this.dydy0 = new double[n][n];
            this.dydp = new double[n][k];
            this.yDot = new double[n];
            this.dydy0Dot = new double[n][n];
            this.dydpDot = new double[n][k];
        }

        public void setInterpolatedTime(double time) {
            this.interpolator.setInterpolatedTime(time);
        }

        public boolean isForward() {
            return this.interpolator.isForward();
        }

        public double getPreviousTime() {
            return this.interpolator.getPreviousTime();
        }

        public double getInterpolatedTime() {
            return this.interpolator.getInterpolatedTime();
        }

        public double[] getInterpolatedY() throws DerivativeException {
            double[] extendedState = this.interpolator.getInterpolatedState();
            System.arraycopy(extendedState, 0, this.y, 0, this.y.length);
            return this.y;
        }

        public double[][] getInterpolatedDyDy0() throws DerivativeException {
            int n;
            double[] extendedState = this.interpolator.getInterpolatedState();
            int start = n = this.y.length;
            for (int i = 0; i < n; ++i) {
                System.arraycopy(extendedState, start, this.dydy0[i], 0, n);
                start += n;
            }
            return this.dydy0;
        }

        public double[][] getInterpolatedDyDp() throws DerivativeException {
            double[] extendedState = this.interpolator.getInterpolatedState();
            int n = this.y.length;
            int k = this.dydp[0].length;
            int start = n * (n + 1);
            for (int i = 0; i < n; ++i) {
                System.arraycopy(extendedState, start, this.dydp[i], 0, k);
                start += k;
            }
            return this.dydp;
        }

        public double[] getInterpolatedYDot() throws DerivativeException {
            double[] extendedDerivatives = this.interpolator.getInterpolatedDerivatives();
            System.arraycopy(extendedDerivatives, 0, this.yDot, 0, this.yDot.length);
            return this.yDot;
        }

        public double[][] getInterpolatedDyDy0Dot() throws DerivativeException {
            int n;
            double[] extendedDerivatives = this.interpolator.getInterpolatedDerivatives();
            int start = n = this.y.length;
            for (int i = 0; i < n; ++i) {
                System.arraycopy(extendedDerivatives, start, this.dydy0Dot[i], 0, n);
                start += n;
            }
            return this.dydy0Dot;
        }

        public double[][] getInterpolatedDyDpDot() throws DerivativeException {
            double[] extendedDerivatives = this.interpolator.getInterpolatedDerivatives();
            int n = this.y.length;
            int k = this.dydpDot[0].length;
            int start = n * (n + 1);
            for (int i = 0; i < n; ++i) {
                System.arraycopy(extendedDerivatives, start, this.dydpDot[i], 0, k);
                start += k;
            }
            return this.dydpDot;
        }

        public double getCurrentTime() {
            return this.interpolator.getCurrentTime();
        }

        public StepInterpolatorWithJacobians copy() throws DerivativeException {
            int n = this.y.length;
            int k = this.dydp[0].length;
            StepInterpolatorWrapper copied = new StepInterpolatorWrapper(this.interpolator.copy(), n, k);
            StepInterpolatorWrapper.copyArray(this.y, copied.y);
            StepInterpolatorWrapper.copyArray(this.dydy0, copied.dydy0);
            StepInterpolatorWrapper.copyArray(this.dydp, copied.dydp);
            StepInterpolatorWrapper.copyArray(this.yDot, copied.yDot);
            StepInterpolatorWrapper.copyArray(this.dydy0Dot, copied.dydy0Dot);
            StepInterpolatorWrapper.copyArray(this.dydpDot, copied.dydpDot);
            return copied;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.interpolator);
            out.writeInt(this.y.length);
            out.writeInt(this.dydp[0].length);
            StepInterpolatorWrapper.writeArray(out, this.y);
            StepInterpolatorWrapper.writeArray(out, this.dydy0);
            StepInterpolatorWrapper.writeArray(out, this.dydp);
            StepInterpolatorWrapper.writeArray(out, this.yDot);
            StepInterpolatorWrapper.writeArray(out, this.dydy0Dot);
            StepInterpolatorWrapper.writeArray(out, this.dydpDot);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.interpolator = (StepInterpolator)in.readObject();
            int n = in.readInt();
            int k = in.readInt();
            this.y = new double[n];
            this.dydy0 = new double[n][n];
            this.dydp = new double[n][k];
            this.yDot = new double[n];
            this.dydy0Dot = new double[n][n];
            this.dydpDot = new double[n][k];
            StepInterpolatorWrapper.readArray(in, this.y);
            StepInterpolatorWrapper.readArray(in, this.dydy0);
            StepInterpolatorWrapper.readArray(in, this.dydp);
            StepInterpolatorWrapper.readArray(in, this.yDot);
            StepInterpolatorWrapper.readArray(in, this.dydy0Dot);
            StepInterpolatorWrapper.readArray(in, this.dydpDot);
        }

        private static void copyArray(double[] src, double[] dest) {
            System.arraycopy(src, 0, dest, 0, src.length);
        }

        private static void copyArray(double[][] src, double[][] dest) {
            for (int i = 0; i < src.length; ++i) {
                StepInterpolatorWrapper.copyArray(src[i], dest[i]);
            }
        }

        private static void writeArray(ObjectOutput out, double[] array) throws IOException {
            for (int i = 0; i < array.length; ++i) {
                out.writeDouble(array[i]);
            }
        }

        private static void writeArray(ObjectOutput out, double[][] array) throws IOException {
            for (int i = 0; i < array.length; ++i) {
                StepInterpolatorWrapper.writeArray(out, array[i]);
            }
        }

        private static void readArray(ObjectInput in, double[] array) throws IOException {
            for (int i = 0; i < array.length; ++i) {
                array[i] = in.readDouble();
            }
        }

        private static void readArray(ObjectInput in, double[][] array) throws IOException {
            for (int i = 0; i < array.length; ++i) {
                StepInterpolatorWrapper.readArray(in, array[i]);
            }
        }
    }

    private static class StepHandlerWrapper
    implements StepHandler {
        private final StepHandlerWithJacobians handler;
        private final int n;
        private final int k;

        public StepHandlerWrapper(StepHandlerWithJacobians handler, int n, int k) {
            this.handler = handler;
            this.n = n;
            this.k = k;
        }

        public StepHandlerWithJacobians getHandler() {
            return this.handler;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) throws DerivativeException {
            this.handler.handleStep(new StepInterpolatorWrapper(interpolator, this.n, this.k), isLast);
        }

        public boolean requiresDenseOutput() {
            return this.handler.requiresDenseOutput();
        }

        public void reset() {
            this.handler.reset();
        }
    }

    private class FiniteDifferencesWrapper
    implements ODEWithJacobians {
        private final ParameterizedODE ode;
        private final double[] p;
        private final double[] hY;
        private final double[] hP;
        private final double[] tmpDot;

        public FiniteDifferencesWrapper(ParameterizedODE ode, double[] p, double[] hY, double[] hP) {
            this.ode = ode;
            this.p = (double[])p.clone();
            this.hY = (double[])hY.clone();
            this.hP = (double[])hP.clone();
            this.tmpDot = new double[ode.getDimension()];
        }

        public int getDimension() {
            return this.ode.getDimension();
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) throws DerivativeException {
            this.ode.computeDerivatives(t, y, yDot);
        }

        public int getParametersDimension() {
            return this.ode.getParametersDimension();
        }

        public void computeJacobians(double t, double[] y, double[] yDot, double[][] dFdY, double[][] dFdP) throws DerivativeException {
            int j;
            int n = this.hY.length;
            int k = this.hP.length;
            FirstOrderIntegratorWithJacobians.this.evaluations += n + k;
            if (FirstOrderIntegratorWithJacobians.this.evaluations > FirstOrderIntegratorWithJacobians.this.maxEvaluations) {
                throw new DerivativeException(new MaxEvaluationsExceededException(FirstOrderIntegratorWithJacobians.this.maxEvaluations));
            }
            for (j = 0; j < n; ++j) {
                double savedYj = y[j];
                int n2 = j;
                y[n2] = y[n2] + this.hY[j];
                this.ode.computeDerivatives(t, y, this.tmpDot);
                for (int i = 0; i < n; ++i) {
                    dFdY[i][j] = (this.tmpDot[i] - yDot[i]) / this.hY[j];
                }
                y[j] = savedYj;
            }
            for (j = 0; j < k; ++j) {
                this.ode.setParameter(j, this.p[j] + this.hP[j]);
                this.ode.computeDerivatives(t, y, this.tmpDot);
                for (int i = 0; i < n; ++i) {
                    dFdP[i][j] = (this.tmpDot[i] - yDot[i]) / this.hP[j];
                }
                this.ode.setParameter(j, this.p[j]);
            }
        }
    }

    private class MappingWrapper
    implements FirstOrderDifferentialEquations {
        private final double[] y;
        private final double[] yDot;
        private final double[][] dFdY;
        private final double[][] dFdP;

        public MappingWrapper() {
            int n = FirstOrderIntegratorWithJacobians.this.ode.getDimension();
            int k = FirstOrderIntegratorWithJacobians.this.ode.getParametersDimension();
            this.y = new double[n];
            this.yDot = new double[n];
            this.dFdY = new double[n][n];
            this.dFdP = new double[n][k];
        }

        public int getDimension() {
            int n = this.y.length;
            int k = this.dFdP[0].length;
            return n * (1 + n + k);
        }

        public void computeDerivatives(double t, double[] z, double[] zDot) throws DerivativeException {
            double[] dFdYi;
            int i;
            int n = this.y.length;
            int k = this.dFdP[0].length;
            System.arraycopy(z, 0, this.y, 0, n);
            if (++FirstOrderIntegratorWithJacobians.this.evaluations > FirstOrderIntegratorWithJacobians.this.maxEvaluations) {
                throw new DerivativeException(new MaxEvaluationsExceededException(FirstOrderIntegratorWithJacobians.this.maxEvaluations));
            }
            FirstOrderIntegratorWithJacobians.this.ode.computeDerivatives(t, this.y, this.yDot);
            FirstOrderIntegratorWithJacobians.this.ode.computeJacobians(t, this.y, this.yDot, this.dFdY, this.dFdP);
            System.arraycopy(this.yDot, 0, zDot, 0, n);
            for (i = 0; i < n; ++i) {
                dFdYi = this.dFdY[i];
                for (int j = 0; j < n; ++j) {
                    int startIndex;
                    double s = 0.0;
                    int zIndex = startIndex = n + j;
                    for (int l = 0; l < n; ++l) {
                        s += dFdYi[l] * z[zIndex];
                        zIndex += n;
                    }
                    zDot[startIndex + i * n] = s;
                }
            }
            for (i = 0; i < n; ++i) {
                dFdYi = this.dFdY[i];
                double[] dFdPi = this.dFdP[i];
                for (int j = 0; j < k; ++j) {
                    int startIndex;
                    double s = dFdPi[j];
                    int zIndex = startIndex = n * (n + 1) + j;
                    for (int l = 0; l < n; ++l) {
                        s += dFdYi[l] * z[zIndex];
                        zIndex += k;
                    }
                    zDot[startIndex + i * k] = s;
                }
            }
        }
    }
}

