/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.optimization;

import com.appdynamics.org.apache.commons.math.optimization.RealConvergenceChecker;
import com.appdynamics.org.apache.commons.math.optimization.RealPointValuePair;

public class SimpleRealPointChecker
implements RealConvergenceChecker {
    private static final double DEFAULT_RELATIVE_THRESHOLD = (double)1.110223E-14f;
    private static final double DEFAULT_ABSOLUTE_THRESHOLD = 2.2250738585072014E-306;
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public SimpleRealPointChecker() {
        this.relativeThreshold = 1.110223E-14f;
        this.absoluteThreshold = 2.2250738585072014E-306;
    }

    public SimpleRealPointChecker(double relativeThreshold, double absoluteThreshold) {
        this.relativeThreshold = relativeThreshold;
        this.absoluteThreshold = absoluteThreshold;
    }

    public boolean converged(int iteration, RealPointValuePair previous, RealPointValuePair current) {
        double[] p = previous.getPoint();
        double[] c = current.getPoint();
        for (int i = 0; i < p.length; ++i) {
            double size;
            double difference = Math.abs(p[i] - c[i]);
            if (!(difference > (size = Math.max(Math.abs(p[i]), Math.abs(c[i]))) * this.relativeThreshold) || !(difference > this.absoluteThreshold)) continue;
            return false;
        }
        return true;
    }
}

