/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.optimization.linear;

import com.appdynamics.org.apache.commons.math.MaxIterationsExceededException;
import com.appdynamics.org.apache.commons.math.optimization.GoalType;
import com.appdynamics.org.apache.commons.math.optimization.OptimizationException;
import com.appdynamics.org.apache.commons.math.optimization.RealPointValuePair;
import com.appdynamics.org.apache.commons.math.optimization.linear.LinearConstraint;
import com.appdynamics.org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import com.appdynamics.org.apache.commons.math.optimization.linear.LinearOptimizer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinearOptimizer
implements LinearOptimizer {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    protected LinearObjectiveFunction function;
    protected Collection<LinearConstraint> linearConstraints;
    protected GoalType goal;
    protected boolean nonNegative;
    private int maxIterations;
    private int iterations;

    protected AbstractLinearOptimizer() {
        this.setMaxIterations(100);
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public int getIterations() {
        return this.iterations;
    }

    protected void incrementIterationsCounter() throws OptimizationException {
        if (++this.iterations > this.maxIterations) {
            throw new OptimizationException(new MaxIterationsExceededException(this.maxIterations));
        }
    }

    @Override
    public RealPointValuePair optimize(LinearObjectiveFunction f, Collection<LinearConstraint> constraints, GoalType goalType, boolean restrictToNonNegative) throws OptimizationException {
        this.function = f;
        this.linearConstraints = constraints;
        this.goal = goalType;
        this.nonNegative = restrictToNonNegative;
        this.iterations = 0;
        return this.doOptimize();
    }

    protected abstract RealPointValuePair doOptimize() throws OptimizationException;
}

