/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.optimization.univariate;

import com.appdynamics.org.apache.commons.math.ConvergingAlgorithmImpl;
import com.appdynamics.org.apache.commons.math.FunctionEvaluationException;
import com.appdynamics.org.apache.commons.math.MathRuntimeException;
import com.appdynamics.org.apache.commons.math.MaxEvaluationsExceededException;
import com.appdynamics.org.apache.commons.math.analysis.UnivariateRealFunction;
import com.appdynamics.org.apache.commons.math.optimization.UnivariateRealOptimizer;

public abstract class AbstractUnivariateRealOptimizer
extends ConvergingAlgorithmImpl
implements UnivariateRealOptimizer {
    protected boolean resultComputed = false;
    protected double result;
    protected double functionValue;
    private int maxEvaluations;
    private int evaluations;

    protected AbstractUnivariateRealOptimizer(int defaultMaximalIterationCount, double defaultAbsoluteAccuracy) {
        super(defaultMaximalIterationCount, defaultAbsoluteAccuracy);
        this.setMaxEvaluations(Integer.MAX_VALUE);
    }

    protected void checkResultComputed() throws IllegalStateException {
        if (!this.resultComputed) {
            throw MathRuntimeException.createIllegalStateException("no result available", new Object[0]);
        }
    }

    public double getResult() {
        this.checkResultComputed();
        return this.result;
    }

    public double getFunctionValue() {
        this.checkResultComputed();
        return this.functionValue;
    }

    protected final void setResult(double x, double fx, int iterationCount) {
        this.result = x;
        this.functionValue = fx;
        this.iterationCount = iterationCount;
        this.resultComputed = true;
    }

    protected final void clearResult() {
        this.resultComputed = false;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    protected double computeObjectiveValue(UnivariateRealFunction f, double point) throws FunctionEvaluationException {
        if (++this.evaluations > this.maxEvaluations) {
            throw new FunctionEvaluationException((Throwable)new MaxEvaluationsExceededException(this.maxEvaluations), point);
        }
        return f.value(point);
    }
}

