/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.stat.descriptive.moment;

import com.appdynamics.org.apache.commons.math.MathRuntimeException;
import com.appdynamics.org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import com.appdynamics.org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import com.appdynamics.org.apache.commons.math.stat.descriptive.summary.SumOfLogs;
import java.io.Serializable;

public class GeometricMean
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8178734905303459453L;
    private StorelessUnivariateStatistic sumOfLogs;

    public GeometricMean() {
        this.sumOfLogs = new SumOfLogs();
    }

    public GeometricMean(GeometricMean original) {
        GeometricMean.copy(original, this);
    }

    public GeometricMean(SumOfLogs sumOfLogs) {
        this.sumOfLogs = sumOfLogs;
    }

    public GeometricMean copy() {
        GeometricMean result = new GeometricMean();
        GeometricMean.copy(this, result);
        return result;
    }

    public void increment(double d) {
        this.sumOfLogs.increment(d);
    }

    public double getResult() {
        if (this.sumOfLogs.getN() > 0L) {
            return Math.exp(this.sumOfLogs.getResult() / (double)this.sumOfLogs.getN());
        }
        return Double.NaN;
    }

    public void clear() {
        this.sumOfLogs.clear();
    }

    public double evaluate(double[] values, int begin, int length) {
        return Math.exp(this.sumOfLogs.evaluate(values, begin, length) / (double)length);
    }

    public long getN() {
        return this.sumOfLogs.getN();
    }

    public void setSumLogImpl(StorelessUnivariateStatistic sumLogImpl) {
        this.checkEmpty();
        this.sumOfLogs = sumLogImpl;
    }

    public StorelessUnivariateStatistic getSumLogImpl() {
        return this.sumOfLogs;
    }

    public static void copy(GeometricMean source, GeometricMean dest) {
        dest.sumOfLogs = source.sumOfLogs.copy();
    }

    private void checkEmpty() {
        if (this.getN() > 0L) {
            throw MathRuntimeException.createIllegalStateException("{0} values have been added before statistic is configured", this.getN());
        }
    }
}

