/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.org.apache.commons.math.stat.inference;

import com.appdynamics.org.apache.commons.math.MathException;
import com.appdynamics.org.apache.commons.math.MathRuntimeException;
import com.appdynamics.org.apache.commons.math.distribution.FDistributionImpl;
import com.appdynamics.org.apache.commons.math.stat.descriptive.summary.Sum;
import com.appdynamics.org.apache.commons.math.stat.descriptive.summary.SumOfSquares;
import com.appdynamics.org.apache.commons.math.stat.inference.OneWayAnova;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneWayAnovaImpl
implements OneWayAnova {
    @Override
    public double anovaFValue(Collection<double[]> categoryData) throws IllegalArgumentException, MathException {
        AnovaStats a = this.anovaStats(categoryData);
        return a.F;
    }

    @Override
    public double anovaPValue(Collection<double[]> categoryData) throws IllegalArgumentException, MathException {
        AnovaStats a = this.anovaStats(categoryData);
        FDistributionImpl fdist = new FDistributionImpl(a.dfbg, a.dfwg);
        return 1.0 - fdist.cumulativeProbability(a.F);
    }

    @Override
    public boolean anovaTest(Collection<double[]> categoryData, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw MathRuntimeException.createIllegalArgumentException("out of bounds significance level {0}, must be between {1} and {2}", alpha, 0, 0.5);
        }
        return this.anovaPValue(categoryData) < alpha;
    }

    private AnovaStats anovaStats(Collection<double[]> categoryData) throws IllegalArgumentException, MathException {
        if (categoryData.size() < 2) {
            throw MathRuntimeException.createIllegalArgumentException("two or more categories required, got {0}", categoryData.size());
        }
        for (double[] array : categoryData) {
            if (array.length > 1) continue;
            throw MathRuntimeException.createIllegalArgumentException("two or more values required in each category, one has {0}", array.length);
        }
        int dfwg = 0;
        double sswg = 0.0;
        Sum totsum = new Sum();
        SumOfSquares totsumsq = new SumOfSquares();
        int totnum = 0;
        for (double[] data : categoryData) {
            Sum sum = new Sum();
            SumOfSquares sumsq = new SumOfSquares();
            int num = 0;
            for (int i = 0; i < data.length; ++i) {
                double val = data[i];
                ++num;
                sum.increment(val);
                sumsq.increment(val);
                ++totnum;
                totsum.increment(val);
                totsumsq.increment(val);
            }
            dfwg += num - 1;
            double ss = sumsq.getResult() - sum.getResult() * sum.getResult() / (double)num;
            sswg += ss;
        }
        double sst = totsumsq.getResult() - totsum.getResult() * totsum.getResult() / (double)totnum;
        double ssbg = sst - sswg;
        int dfbg = categoryData.size() - 1;
        double msbg = ssbg / (double)dfbg;
        double mswg = sswg / (double)dfwg;
        double F = msbg / mswg;
        return new AnovaStats(dfbg, dfwg, F);
    }

    private static class AnovaStats {
        private int dfbg;
        private int dfwg;
        private double F;

        private AnovaStats(int dfbg, int dfwg, double F) {
            this.dfbg = dfbg;
            this.dfwg = dfwg;
            this.F = F;
        }
    }
}

