/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.java9;

import com.singularity.ee.agent.appagent.AgentEntryPoint;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodeProperty;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodePropertyListener;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.string.StringOperations;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@NodePropertyListener(id="Java9ModuleAccessConfiguration")
public class Java9ModuleAccessConfiguration {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.Java9ModuleAccessConfiguration");
    private static final String APPAGENT_EXPORT_PACKAGES = "appagent-export-packages";
    private final IJava9Util java9Util;
    private String exportedPackages = "";

    @Inject
    public Java9ModuleAccessConfiguration(IConfigManager configManager, IJava9Util java9Util) {
        configManager.registerConfigPropertyChangeListener(this);
        this.java9Util = java9Util;
    }

    @NodeProperty(key="appagent-export-packages", description="export the appagent packages to all other modules", defaultValue="")
    public void exportPackagesToAll(String packagesToExport) {
        logger.info("Exporting these appagent packages(java9+) to all unnamed: " + packagesToExport);
        if (!StringOperations.isEmpty((String)packagesToExport) && !this.exportedPackages.equals(packagesToExport) && JavaVersionUtil.isJava9orHigher()) {
            this.exportedPackages = packagesToExport;
            String[] exportPackages = AgentEntryPoint.parseReadModulesProperty((String)packagesToExport).toArray(new String[0]);
            this.java9Util.addExportsToAll(this.java9Util.getModuleForClass(this.getClass()), exportPackages);
        }
    }
}

