/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.java9;

import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.reflect.IJDKSpecificPermissionObtainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;

@Singleton
public class Java9PermissionObtainer
implements IJDKSpecificPermissionObtainer {
    private final IJava9Util java9Util;
    private final ConcurrentMap<Object, ConcurrentMap<String, String>> mapOfAccessModules = new ConcurrentHashMap<Object, ConcurrentMap<String, String>>();
    private static final AtomicReference<Java9PermissionObtainer> instance = new AtomicReference();

    public static Java9PermissionObtainer getInstance(IJava9Util java9Util) {
        Java9PermissionObtainer java9PermissionObtainer = instance.get();
        while (java9PermissionObtainer == null) {
            java9PermissionObtainer = new Java9PermissionObtainer(java9Util);
            if (instance.compareAndSet(null, java9PermissionObtainer)) continue;
            java9PermissionObtainer = instance.get();
        }
        return java9PermissionObtainer;
    }

    public Java9PermissionObtainer(IJava9Util java9Util) {
        this.java9Util = java9Util;
    }

    public void getAccessToClass(Class<?> clazz) {
        this.getAccessToClass(clazz, false, null);
    }

    public void getAccessToClass(Class<?> clazz, boolean forceIfUnnamed, IADLogger logger) {
        Object module = this.java9Util.getModuleForClass(clazz);
        if (module == null || module.toString().contains("unnamed") && !forceIfUnnamed) {
            return;
        }
        ConcurrentMap<String, String> packageMap = (ConcurrentHashMap)this.mapOfAccessModules.get(module);
        Object thisModule = this.java9Util.getModuleForClass(Java9PermissionObtainer.class);
        if (thisModule == null) {
            return;
        }
        if (packageMap == null) {
            packageMap = new ConcurrentHashMap();
            ConcurrentMap previousPackageMap = this.mapOfAccessModules.putIfAbsent(module, packageMap);
            if (previousPackageMap != null) {
                packageMap = previousPackageMap;
            } else {
                this.java9Util.addReads(thisModule, module);
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(String.format("Module %s has been given read access to module %s", thisModule.toString(), module.toString()));
                }
            }
        }
        if (clazz.getPackage() == null || clazz.getPackage().getName() == null) {
            return;
        }
        String packageName = clazz.getPackage().getName();
        if (packageMap.get(packageName) == null) {
            HashMap<String, Set<Object>> opensMap = new HashMap<String, Set<Object>>();
            HashSet<Object> thisModuleSet = new HashSet<Object>();
            thisModuleSet.add(thisModule);
            opensMap.put(packageName, thisModuleSet);
            this.java9Util.addExportsAndOpens(module, Collections.EMPTY_MAP, opensMap);
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(String.format("Module %s has been given open access to package %s and module %s", thisModule.toString(), packageName, module.toString()));
            }
            packageMap.putIfAbsent(packageName, packageName);
        }
    }
}

