/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.boot;

import com.singularity.ee.agent.appagent.kernel.boot.IJavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.spi.DoNotObfuscate;
import com.singularity.ee.agent.appagent.kernel.spi.IBootServiceProvider;
import com.singularity.ee.agent.appagent.kernel.spi.IJavaAgent;
import com.singularity.ee.agent.appagent.kernel.spi.Service;
import com.singularity.ee.agent.appagent.services.transactionmonitor.spi.ITransactionMonitorBase;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.util.logging.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class JavaAgentBootExtension
implements IJavaAgentBootExtension,
DoNotObfuscate {
    private ILogger logger;
    private static volatile IJavaAgentBootExtension instance;
    private volatile IJavaAgent javaAgent;
    private volatile IBootServiceProvider bootServiceProvider;
    private volatile File loggingDirectory;

    public static IJavaAgentBootExtension getInstance() {
        if (instance == null) {
            JavaAgentBootExtension.getInstanceSync();
        }
        return instance;
    }

    private static synchronized IJavaAgentBootExtension getInstanceSync() {
        if (instance == null) {
            instance = new JavaAgentBootExtension();
        }
        return instance;
    }

    public static synchronized void setInstance(IJavaAgentBootExtension instance) {
        JavaAgentBootExtension.instance = instance;
    }

    @Override
    public IJavaAgent getJavaAgent() {
        return this.javaAgent;
    }

    @Override
    public void setJavaAgent(IJavaAgent javaAgent) {
        this.javaAgent = javaAgent;
    }

    public InputStream getDTDInputStream() {
        File dtdFile = new File(this.loggingDirectory, "log4j.dtd");
        try {
            FileInputStream fis = new FileInputStream(dtdFile);
            return fis;
        }
        catch (Exception e) {
            this.logger.error(String.format("Unable to provide InputStream for DTD file %s %s", dtdFile, e), (Throwable)e);
            return null;
        }
    }

    @Override
    public ITransactionMonitorBase getTransactionMonitor() {
        if (this.bootServiceProvider != null) {
            return this.bootServiceProvider.getTransactionMonitor();
        }
        return null;
    }

    @Override
    public IBootServiceProvider getBootServiceProvider() {
        return this.bootServiceProvider;
    }

    @Override
    public void setBootServiceProvider(IBootServiceProvider bootServiceProvider) {
        this.bootServiceProvider = bootServiceProvider;
    }

    @Override
    public Service getServiceForName(String name) {
        return this.bootServiceProvider != null ? this.bootServiceProvider.getServiceForName(name) : null;
    }

    @Override
    public boolean isJava9orGreater() {
        return JavaVersionUtil.isJava9orHigher();
    }

    @Override
    public boolean isJava8() {
        return JavaVersionUtil.isJava8();
    }

    @Override
    public boolean isJava8orGreater() {
        return JavaVersionUtil.isJava8orHigher();
    }

    public static boolean isInitialized() {
        boolean bReturn = false;
        if (instance instanceof JavaAgentBootExtension) {
            JavaAgentBootExtension javaAgentBootExtension = (JavaAgentBootExtension)instance;
            bReturn = javaAgentBootExtension.javaAgent != null && javaAgentBootExtension.javaAgent.isInitializedInstance();
        }
        return bReturn;
    }

    @Override
    public boolean isInPreMain() {
        if (this.bootServiceProvider != null) {
            return this.bootServiceProvider.isInPreMain();
        }
        return false;
    }

    @Override
    public boolean isRunningAtJVMInit() {
        if (this.bootServiceProvider != null) {
            return this.bootServiceProvider.isRunningAtJVMInit();
        }
        return false;
    }
}

