/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.bootimpl;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.IAgentBootLogger;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IBaseMethodInterceptorDelegator;
import com.singularity.ee.agent.appagent.kernel.bootimpl.IInterceptorMeasurer;
import com.singularity.ee.agent.appagent.utils.StackOperations;
import com.singularity.ee.agent.util.io.Console;

public class BaseMethodInterceptorDelegatorImpl
implements IBaseMethodInterceptorDelegator {
    private IAgentBootLogger logger = new InternalConsoleAgentBootLogger();
    protected volatile boolean agentDisabled;
    protected volatile boolean disabled;
    protected volatile boolean usePrivilegedAction;
    protected static volatile IInterceptorMeasurer interceptorMeasurer;

    public boolean isDisabled() {
        return this.disabled || this.agentDisabled;
    }

    public void disable() {
        this.disabled = true;
    }

    public void enable() {
        this.disabled = false;
    }

    public void setAgentDisabled(boolean value) {
        this.agentDisabled = value;
    }

    public final void safeWarn(String msg, Throwable t) {
        try {
            this.logger.warn(msg, t);
        }
        catch (Throwable err) {
            t.printStackTrace(Console.out());
        }
    }

    public final void setUsePrivilegedAction(boolean usePrivilegedAction) {
        this.usePrivilegedAction = usePrivilegedAction;
    }

    public final void safeError(Throwable t) {
        try {
            this.logger.warn("Exception caught: " + t.toString());
        }
        catch (Throwable err) {
            t.printStackTrace(Console.out());
        }
    }

    public final void setLogger(IAgentBootLogger newLogger) {
        this.logger = newLogger;
    }

    public static final boolean setInterceptorMeasurer(IInterceptorMeasurer interceptorMeasurer) {
        if (BaseMethodInterceptorDelegatorImpl.interceptorMeasurer == null) {
            BaseMethodInterceptorDelegatorImpl.interceptorMeasurer = interceptorMeasurer;
            return true;
        }
        return false;
    }

    private class InternalConsoleAgentBootLogger
    implements IAgentBootLogger {
        private InternalConsoleAgentBootLogger() {
        }

        public void warn(String msg, Throwable t) {
            Console.out().println(msg);
            if (t != null) {
                StackOperations.printStackTrace((Throwable)t);
            }
        }

        public void warn(String msg) {
            Console.out().println(msg);
        }

        public void info(Object o) {
            throw new UnsupportedOperationException();
        }

        public void debugParams(String msg, Object ... objects) {
            throw new UnsupportedOperationException();
        }
    }
}

