/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.bootimpl;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastInterceptorClassRegistry;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastMethodInterceptor;
import com.singularity.ee.agent.appagent.kernel.bootimpl.InterceptorClassRegistry;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AFastMethodInterceptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FastInterceptorClassRegistry
extends InterceptorClassRegistry
implements IFastInterceptorClassRegistry {
    public static volatile boolean disableCollectionCaptureInstrumentation = true;
    public static volatile short activityTracesThatAreRunning = 0;
    static final int onDemandCollectionCaptureInterceptorOrdinal = Id.OnDemandCollectionCaptureInterceptor.ordinal();
    private static final int DEFAULT_NUM_EXTRA_SLOTS = 10;
    private static final String NUM_EXTRA_SLOTS_PROP_NAME = "appdynamics.num.extra.fast.interceptor.slots";
    private static final int numExtraInterceptorSlots = FastInterceptorClassRegistry.getNumExtraInterceptorSlots();
    private static final IFastMethodInterceptor[] instances = new IFastMethodInterceptor[Id.values().length + numExtraInterceptorSlots];
    private static final Map<String, Integer> interceptorClassToIdMap = new ConcurrentHashMap<String, Integer>();
    private final boolean[] extraSlotAllocated = new boolean[numExtraInterceptorSlots];

    public static final int getHttpErrorCodeInterceptorId() {
        return Id.ServletHttpErrorCodeInterceptor.ordinal();
    }

    public static final int getPojoDgInterceptorId() {
        return Id.POJODataGathererInterceptor.ordinal();
    }

    public static final int getInfoPointInterceptorId() {
        return Id.POJOInformationPointInterceptor.ordinal();
    }

    public static final int getCustomExitPointInterceptorId() {
        return Id.CustomExitPointInterceptor.ordinal();
    }

    public static final int getCustomAsyncExitPointInterceptorId() {
        return Id.CustomAsyncExitPointInterceptor.ordinal();
    }

    public static final int getDumpStackInterceptorId() {
        return Id.DumpStackInterceptor.ordinal();
    }

    public static final int getActivityConsumerInProcessTransactionContinuationInterceptorId() {
        return Id.ActivityConsumerInProcessTransactionContinuationInterceptor.ordinal();
    }

    public static final int getActivityConsumerPOJOEntryPointInterceptorId() {
        return Id.ActivityConsumerPOJOEntryPointInterceptor.ordinal();
    }

    public static final int getActivityConsumerReadInitInterceptorId() {
        return Id.ActivityConsumerReadInitInterceptor.ordinal();
    }

    public static final int getActivityConsumerReadStartInterceptorId() {
        return Id.ActivityConsumerReadStartInterceptor.ordinal();
    }

    public static final int getActivityLoopEntryInterceptorId() {
        return Id.ActivityLoopEntryInterceptor.ordinal();
    }

    public final int getActivityMarkerInterceptorId() {
        return Id.ActivityMarkerInterceptor.ordinal();
    }

    public final int getActivityProcessingLoopInterceptorId() {
        return Id.ActivityProcessingLoopInterceptor.ordinal();
    }

    public final int getActivityProducerInProcessCorrelationInterceptorId() {
        return Id.ActivityProducerInProcessCorrelationInterceptor.ordinal();
    }

    public final int getActivityProducerInterceptorId() {
        return Id.ActivityProducerInterceptor.ordinal();
    }

    public final int getActivityProducerMultiExitInterceptorId() {
        return Id.ActivityProducerMultiExitInterceptor.ordinal();
    }

    public final int getActivityProducerOutgoingCorrelationInterceptorId() {
        return Id.ActivityProducerOutgoingCorrelationInterceptor.ordinal();
    }

    public static final int getETELatencyDemarcatorInterceptorId() {
        return Id.ETELatencyDemarcatorInterceptor.ordinal();
    }

    private static final int getNumExtraInterceptorSlots() {
        int iReturn = 10;
        String numExtraSlotsString = "";
        try {
            numExtraSlotsString = System.getProperty(NUM_EXTRA_SLOTS_PROP_NAME);
            if (numExtraSlotsString != null) {
                iReturn = Integer.parseInt(numExtraSlotsString);
            }
        }
        catch (NumberFormatException e) {
            InterceptorClassRegistry.logger.warn("Invalid value " + numExtraSlotsString + " for property " + NUM_EXTRA_SLOTS_PROP_NAME + ".  Default value " + Integer.toString(10) + " is used", e);
        }
        return iReturn;
    }

    public final void bindFastInterceptorInstance(IFastMethodInterceptor instance) {
        this.bindFastInterceptorInstance(instance, false);
    }

    public final void bindFastInterceptorInstance(IFastMethodInterceptor instance, boolean replace) {
        int fastInterceptorId = instance.getInterceptorId();
        try {
            if (instances[fastInterceptorId] != null) {
                if (!instance.getClass().getName().equals(instances[fastInterceptorId].getClass().getName())) {
                    throw new RuntimeException("Interceptor classes using the same id [" + fastInterceptorId + "] [" + instance.getClass().getName() + "] and [" + instances[fastInterceptorId].getClass().getName() + "]");
                }
                if (!replace) {
                    return;
                }
            }
            FastInterceptorClassRegistry.instances[fastInterceptorId] = instance;
            Class<?> interceptorClass = instance.getClass();
            interceptorClassToIdMap.put(interceptorClass.getName(), fastInterceptorId);
            InterceptorClassRegistry.initNameCache((AFastMethodInterceptor)instance);
        }
        catch (IndexOutOfBoundsException e) {
            InterceptorClassRegistry.logger.warn("Error during bindFastInterceptorInstance() for interceptor " + instance.toString() + ": " + e.toString(), e);
        }
    }

    public final IFastMethodInterceptor getFastInterceptorInstance(int fastInterceptorId) {
        return instances[fastInterceptorId];
    }

    public final boolean isRegistered(String interceptorClassName) {
        return interceptorClassToIdMap.containsKey(interceptorClassName);
    }

    public static final int getFastInterceptorId(String interceptorClassName) {
        Integer id = interceptorClassToIdMap.get(interceptorClassName);
        if (id == null) {
            throw new IllegalArgumentException("Fast Interceptor " + interceptorClassName + " not bound.");
        }
        return id;
    }

    public final Class<? extends IFastMethodInterceptor> getFastClass(String className) {
        Integer id = interceptorClassToIdMap.get(className);
        if (id != null) {
            return this.getFastInterceptorInstance(id).getClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNewInterceptorId() {
        int returnInterceptorId = -1;
        boolean[] blArray = this.extraSlotAllocated;
        synchronized (this.extraSlotAllocated) {
            for (int i = 0; i < this.extraSlotAllocated.length; ++i) {
                if (this.extraSlotAllocated[i]) continue;
                this.extraSlotAllocated[i] = true;
                returnInterceptorId = Id.values().length + i;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return returnInterceptorId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void unbindFastInterceptorInstance(IFastMethodInterceptor instance) {
        IFastMethodInterceptor testInterceptor;
        int interceptorId = instance.getInterceptorId();
        if (interceptorId < 0 || interceptorId >= instances.length || (testInterceptor = instances[interceptorId]) == null || testInterceptor.getClass() != instance.getClass()) return;
        FastInterceptorClassRegistry.instances[interceptorId] = null;
        boolean[] blArray = this.extraSlotAllocated;
        synchronized (this.extraSlotAllocated) {
            try {
                this.extraSlotAllocated[interceptorId - Id.values().length] = false;
            }
            catch (IndexOutOfBoundsException e) {
                InterceptorClassRegistry.logger.warn("Error during unbindFastInterceptorInstance(): " + e.toString(), e);
            }
            interceptorClassToIdMap.remove(instance.getClass().getName());
            this.removeFromNameCache(instance.getClass(), (AMethodInterceptor)instance);
            return;
        }
    }

    public final int getFastNoReentrantCheckTestInterceptorOrdinal() {
        return Id.FastNoReentrantCheckTestInterceptor.ordinal();
    }

    public final int getOnDemandCollectionCaptureInterceptorOrdinal() {
        return onDemandCollectionCaptureInterceptorOrdinal;
    }

    public final boolean isDisableCollectionCaptureInstrumentation() {
        return disableCollectionCaptureInstrumentation;
    }

    public final int getActivityTracesThatAreRunning() {
        return activityTracesThatAreRunning;
    }

    public final int getMemoryTrackerInterceptorOrdinal() {
        return Id.MemoryTrackerInterceptor.ordinal();
    }

    public final int incrementActivityTracesThatAreRunning(int incrBy) {
        activityTracesThatAreRunning = (short)(activityTracesThatAreRunning + incrBy);
        return activityTracesThatAreRunning;
    }

    public final void setDisableCollectionCaptureInstrumentation(boolean disable) {
        disableCollectionCaptureInstrumentation = disable;
    }

    public final boolean shouldNotDispatchFMID(int fastInterceptorId) {
        return fastInterceptorId == onDemandCollectionCaptureInterceptorOrdinal && disableCollectionCaptureInstrumentation && activityTracesThatAreRunning == 0;
    }

    public boolean shouldIgnoreReEntrantCheckOnBegin(int fastInterceptorId) {
        return fastInterceptorId > Id.IgnoreReentrantCheckOnBeginMarker.ordinal();
    }

    public static enum Id {
        TurboExitPointInterceptor,
        MongoDBLastDitchCleanupInterceptor,
        IgnoreReentrantCheckOnBeginMarker,
        FastBasicTestInterceptor,
        FastPerformanceTestInterceptor1,
        FastPerformanceTestInterceptor2,
        FastPerformanceTestInterceptor3,
        FastPriorityTestInterceptor1,
        FastPriorityTestInterceptor2,
        FastPriorityTestInterceptor3,
        FastPriorityTestInterceptor4,
        InlineTestInterceptor,
        FastTestInterceptor,
        FastNoReentrantCheckTestInterceptor,
        JBossOnStartInterceptor,
        GlueJavaToSOAPCallInterceptor,
        OnDemandCollectionCaptureInterceptor,
        MemoryTrackerInterceptor,
        JDBCConnectInterceptor,
        JDBCConnectionRollbackInteceptor,
        JDBCUpdateBatchInteceptor,
        JDBCPreparedStatementInterceptor,
        DBCamIntegrationPreparedStatementInterceptor,
        JDBCStatementInterceptor,
        DBCamIntegrationStatementInterceptor,
        JDBCGetConnectionInteceptor,
        JDBCConnectionCommitInteceptor,
        JDBCConnectionCloseInteceptor,
        JDBCAddBatchInterceptor,
        JDBCPreparedStatementBindInterceptor,
        JDBCPreparedStatementNullBindInterceptor,
        JDBCPreparedStatementCloseInterceptor,
        JDBCPreparedStatementMappingInterceptor,
        JDBCResultSetInterceptor,
        JDBCResultSetCloseInterceptor,
        PauseClockInterceptor,
        CustomExitPointInterceptor,
        CustomAsyncExitPointInterceptor,
        NoSnapshotExitPointInterceptor,
        SOAPOutgoingInterceptor,
        MapInitializationInterceptor,
        CollectionInitializationInterceptor,
        MapPutInterceptor,
        CollectionAddInterceptor,
        CustomClassNameMethodInterceptor,
        ClassInstanceCreationInterceptor,
        CustomMemoryStructureSetMethodInterceptor,
        CustomMemoryStructureGetMethodInterceptor,
        ServletHttpErrorCodeInterceptor,
        PlayForScalaHttpErrorCodeInterceptor,
        PlayForJavaHttpErrorCodeInterceptor,
        ReactorNettyHttpErrorCodeInterceptor,
        ReactorNettyHttp404ErrorCodeInterceptor,
        PlayResponseInterceptor,
        PlayNettyResponseInterceptor,
        PlayAsyncEntryMarkerInterceptor,
        PlayAsyncContextCompletionInterceptor,
        PlayPre25AsyncContextCompletionInterceptor,
        JDKLoggerInterceptor,
        SFL4JLoggerInterceptor,
        Log4jLoggerExceptionInterceptor,
        Log4jLoggerMessageInterceptor,
        CustomLoggerInterceptor,
        CommonsLog4jLoggerExceptionInterceptor,
        CommonsLog4jLoggerMessageInterceptor,
        Log4jAppenderInterceptor,
        LogbackAppenderInterceptor,
        Log4j2AppenderInterceptor,
        ThriftMessageWriteBeginInterceptor,
        ThriftBinaryProtocolCorrelationWriterInterceptor,
        ThriftExitPointInterceptor,
        ThriftReadFieldBeginInterceptor,
        ThriftBinaryProtocolCorrelationReaderInterceptor,
        POJOInformationPointInterceptor,
        POJODataGathererInterceptor,
        CassandraGetExitPointInterceptor,
        CassandraRemoveExitPointInterceptor,
        CassandraInsertExitPointInterceptor,
        CassandraGetSliceExitPointInterceptor,
        CassandraGetCountExitPointInterceptor,
        CassandraMultigetSliceExitPointInterceptor,
        CassandraMultigetCountExitPointInterceptor,
        CassandraGetRangeSlicesExitPointInterceptor,
        CassandraGetIndexedSlicesExitPointInterceptor,
        CassandraBatchMutateExitPointInterceptor,
        CassandraGenericExitPointInterceptor,
        CassandraSetKeyspaceInterceptor,
        CQLRemotingExitPointInterceptor,
        CQLRemotingOutgoingCorrelationInterceptor,
        CQLRemotingIncomingCorrelationInterceptor,
        CQLRemotingTransactionContinuationInterceptor,
        CQLRemotingResponseExitInterceptor,
        CQLRemotingMessageMarkerInterceptor,
        CQLRemotingHostAndPortGrabber,
        Log4jLoggerInterceptor2,
        JDBCIdentificationInterceptor,
        FastProxyTransactionEntryPointInterceptor,
        CustomOOTBExitPointInterceptor,
        ForkingThreadInstanceTrackerInterceptor,
        ForkingThreadRunTrackerInterceptor,
        AsyncFlowSubscriptionBeginInterceptor,
        AsyncFlowSubscriptionCancellationInterceptor,
        AsyncFlowSubscriptionEndInterceptor,
        AsyncTaskAnnouncementVersatileInterceptor,
        AsyncTaskArg1AnnouncementInterceptor,
        AsyncTaskCalleeAnnouncementInterceptor,
        AsyncTaskExecutionInterceptor,
        AsyncTaskInconclusiveExecutionInterceptor,
        AsyncTaskArg1CancellationInterceptor,
        AsyncTaskCalleeCancellationInterceptor,
        RxJavaSubscriptionInterceptor,
        ThreadPoolShutdownInterceptor,
        AsyncCaptureSuppressionInterceptor,
        AsyncHandOffIdentificationInterceptor,
        AsyncHandOffExecutionInterceptor,
        MuleESBReceiverInterceptor,
        MuleESBDispatcherInterceptor,
        MuleMessageADGUIDRelayInterceptor,
        MuleMessageADGUIDCorrelationInterceptor,
        MuleV38HTTPServerEntryInterceptor,
        MuleV38HTTPServerEntryCompletionInterceptor,
        MuleV41ConsumerInterceptor,
        MuleV41ConsumePayloadInterceptor,
        MuleV41ErrorIdentificationInterceptor,
        MuleV41HttpErrorCodeInterceptor,
        MuleV41ArtifactClassLoaderInterceptor,
        ReactorNettyAsyncEntryStartInterceptorV07x,
        ReactorNettyAsyncEntryStartInterceptorV08x,
        ReactorNettyAsyncEntryCompletionInterceptor,
        UndertowAsyncEntryStartInterceptor,
        UndertowAsyncEntryCompletionInterceptor,
        UndertowHttpErrorCodeInterceptor,
        WeblogicServletEntryInterceptor,
        OSBServletEntryMarkerInterceptor,
        OSBServletEntryCompletionInterceptor,
        OSBWebServiceEntryInterceptor,
        OSBWebServiceEntryMarkerInterceptor,
        OSBSoapExitPointInterceptor,
        OSBSoapExitStartInterceptor,
        OSBSoapExitEndInterceptor,
        OSBGenericExitInterceptor,
        RabbitMqExitPointInterceptor,
        RabbitMqClientCorrelationInterceptor,
        RabbitMqConsumerInterceptor,
        SpringAmqpConsumerInterceptor,
        SQSExitPointInterceptor,
        S3ExitInterceptor,
        SQSSendMessageBatchExitInterceptor,
        SQSRequestSingularityMessageAttributeInterceptor,
        SQSEntryPoint,
        SNSExitInterceptor,
        KafkaProducerExitInterceptor,
        KafkaConsumerExitInterceptor,
        KafkaIteratorInterceptor,
        KafkaIteratorHasNextInterceptor,
        KafkaMarkerMethodInterceptor,
        KafkaStreamMarkerInterceptor,
        KafkaStreamProcessStartInterceptor,
        KafkaStreamProcessEndInterceptor,
        KafkaMDCInterceptor,
        KafkaConsumerV9LowLevelMethodInterceptor,
        KafkaConsumerV9LowLevelExitInterceptor,
        KafkaStreamsProducerInterceptor,
        KafkaStreamsMDCInterceptor,
        KafkaEntryInterceptor,
        KafkaConsumerSocketEventInterceptor,
        AxonExitInterceptor31x,
        AxonExitInterceptor24x,
        AxonEntryInterceptor31x,
        AxonEntryInterceptor24x,
        JdbcStatementIdInterceptor,
        JdbcPreparedStatementIdInterceptor,
        EUMGenericResponseDecoratorInterceptor,
        EUMPageContextGetOutInterceptor,
        EUMContentTypeWatchInterceptor,
        EUMHeaderReadInterceptor,
        EUMJspServiceMarker,
        ServletEUMContextInitInterceptor,
        JBossEUMContextInitInterceptor,
        JettyEUMContextInitInterceptor,
        NoArgsEUMContextInitInterceptor,
        EUMManualHeaderOnBeginInterceptor,
        EUMManualHeaderOnEndInterceptor,
        EUMManualFooterOnBeginInterceptor,
        EUMManualFooterOnEndInterceptor,
        GrailsMarkerInterceptor,
        AkkaExitPointInterceptor,
        Akka210RemoteProtocolTransactionDecorator,
        Akka210RemoteActorIncomingCorrelationInterceptor,
        Akka220RemoteProtocolTransactionDecorator,
        Akka220HeaderPropagationInterceptor,
        Akka220RemoteActorIncomingCorrelationInterceptor,
        AkkaMessageDeserializerInterceptor,
        AkkaMarkerInterceptor,
        PlayFrameworkEntryPointInterceptor,
        PlayEntryPointInterceptor,
        ScalaInstrumentationDisablingInterceptor,
        AkkaProducerInterceptor,
        AkkaLocalActorProducerInterceptor,
        AkkaLocalActorProducerDataCollectorInterceptor,
        AkkaLocalActorConsumerInterceptor,
        AkkaConsumerInterceptor,
        Play211ForkJoinTaskProducer,
        Play211ForkJoinTaskConsumer,
        AkkaInternalsHandoffInterceptor,
        AkkaInternalsPickupInterceptor,
        EUMGrailsAttributeBindInterceptor,
        EUMVelocityAttributeBindInterceptor,
        CustomCorrelationOutgoingInterceptor,
        CustomCorrelationIncomingInterceptor,
        CustomXMLExitInterceptor,
        BaseServletInterceptor,
        MuleHTTPServerCorrelationInterceptor,
        Mule34HTTPServerCorrelationInterceptor,
        Struts2ResultInterceptor,
        JMSEntryMarkerInterceptor,
        WMQEntryMarkerInterceptor,
        DumpStackInterceptor,
        ClassLoaderInterceptor,
        InitialContextInterceptor,
        ThrowableInterceptor,
        NamingManagerInterceptor,
        LoopReportInterceptor,
        UninstrumentedClassInterceptor,
        ExitMarkerInterceptor,
        LiveModeIntrospectionInterceptor,
        MemoryTrackerMethodInterceptor,
        MemoryTrackerClassInterceptor,
        MemoryMonitorConstructorInterceptor,
        ObjectMonitorMethodInterceptor,
        SocketReadInterceptor,
        DiskReadInterceptor,
        DiskWriteInterceptor,
        SocketWriteInterceptor,
        DiskNIOWriteInterceptor,
        DiskNIOReadInterceptor,
        SocketNIOWriteInterceptor,
        SocketNIOReadInterceptor,
        WLSIIOPServerCorrelationInterceptor,
        JBossJRMPServerCorrelationInterceptor,
        JBossRemotingServerCorrelationInterceptor,
        JBossRemoting3ServerCorrelationInterceptor,
        JBossRemoting5ServerCorrelationInterceptor,
        WASIIOPServerCorrelationInterceptor,
        WebMethodsServerCorrelationInterceptor,
        WLSRMIClientCorrelationInterceptor,
        SpringRMIClientCorrelationInterceptor,
        ServletInterceptor,
        JettyHandlerInterceptor,
        WebObjectsEntryInterceptor,
        SpringControllerInterceptor,
        MessageListenerInterceptor,
        SpringBeanInterceptor,
        ActionInvocationInterceptor,
        SpringRMIEntryPointInterceptor,
        FilterInterceptor,
        JRubyFilterInterceptor,
        ColdFusionBootstrapServletInterceptor,
        StrutsActionInterceptor,
        AnnotatedControllerInterceptor,
        StrutsActionProxyInterceptor,
        CustomReceiverInterceptor,
        CustomCorrelationMarkerInterceptor,
        MuleEntryPointInterceptor,
        SOAPIncomingInterceptor,
        EJBInterceptor,
        WLSEJBInterceptor,
        WASJAXRPCServiceInterceptor,
        WLSJAXRPCServiceInterceptor,
        Axis2ServiceInterceptor,
        CXFServiceInterceptor,
        JAXWSRIServiceInterceptor,
        AxisServiceInterceptor,
        JBossWSEntryInterceptor,
        JBossWSServiceInterceptor,
        JAXWSServiceInterceptor,
        WASJAXWSServiceInterceptor,
        XFireServiceInterceptor,
        ThriftEntryPointInterceptor,
        DispatcherServletInterceptor,
        POJOEntryPointInterceptor,
        SepDiscoveryEntryPointInterceptor,
        BeanResolveInterceptor,
        ActivityConsumerPOJOEntryPointInterceptor,
        LocalPOJOEntryPointInterceptor,
        AsyncJerseyClientExitPointInterceptor,
        AsyncJerseyClientExitStartInterceptor,
        AsyncJerseyClientExitEndInterceptor,
        SunJerseyInterceptor,
        GlassfishJerseyInterceptor,
        JaxRSIdentificationInterceptor,
        JaxRsAsyncEntryMarkerInterceptor,
        JaxRsEntryCompletionInterceptor,
        JaxRsCallableProducerInterceptor,
        JaxRsCallableConsumerInterceptor,
        TurboPOJOIdentifier,
        TibcoHttpEntryPointInterceptor,
        TibcoSoapEntryPointInterceptor,
        GenericTransactionMethodSplitter,
        DOM4JXPathEvaluator,
        DocumentParseInterceptor,
        BindingUnmarshalInterceptor,
        JSONBindingInterceptor,
        SpringWs20DocumentParseInterceptor,
        HTTPResponseTimeInterceptor,
        ApacheHTTP4TransactionDecorator,
        ApacheHTTP43TransactionDecorator,
        ApacheHTTPAsyncClientDecorator,
        ApacheHTTP5AsyncClientDecorator,
        ApacheHTTP5ClientDecorator,
        ApacheHTTPAsyncClientStartInterceptor,
        ApacheHTTPAsyncClientEndInterceptor,
        ApacheHTTP5AsyncClientEndInterceptor,
        ApacheHTTPAsyncClientConsumerInterceptor,
        JDKHTTPTransactionDecorator,
        GlueHTTPCorrelationInterceptor,
        AxisHTTPCorrelationInterceptor,
        WebMethodsHTTPClientInterceptor,
        WLSHTTPCorrelationInterceptor,
        Oc4JHTTPCorrelationInterceptor,
        ApacheAsyncHTTPTransactionDecorator,
        ApacheHTTPTransactionDecorator,
        JRubyHttpCorrelationInterceptor,
        TibcoBWServletTransportDriverTransactionDecorator,
        OkHttpTransactionDecorator,
        OkHttpResponseTimeInterceptor,
        OkHttpV3And4ExitPointInterceptor,
        OpenAIExitInterceptor,
        OkHttpV3And4AsyncExitPointInterceptor,
        OkHttpV3AndV4AsyncExitStartInterceptor,
        OkHttpV3AndV4AsyncExitEndInterceptor,
        HTTPGetInputStreamInterceptor,
        WebMethodsTransactionDecorator,
        HTTPClientDefaultInterceptor,
        HTTPClientGetInterceptor,
        LeafSamplingInterceptor,
        ActivityProducerInterceptor,
        ActivityConsumerInterceptor,
        ActivityMarkerInterceptor,
        ActivityProducerExitInterceptor,
        ActivityProcessingLoopInterceptor,
        ActivityProducerMultiExitInterceptor,
        ActivityConsumerReadStartInterceptor,
        ActivityConsumerReadInitInterceptor,
        ActivityConsumerInProcessTransactionContinuationInterceptor,
        ActivityProducerOutgoingCorrelationInterceptor,
        ActivityProducerInProcessCorrelationInterceptor,
        ActivityLoopEntryInterceptor,
        DebugInterceptor,
        SpringWSInterceptor,
        SpringWSInterceptorPost2dot0,
        SpringRESTClientInterceptor,
        SpringRESTClientCorrelationInterceptor,
        CleanupInterceptor,
        CastorClassDescriptorResolverInterceptor,
        SpringIntegrationMessageChannelExitInterceptor,
        SpringIntegrationMessageHandlerEntryInterceptor,
        SpringIntegrationReceiveEntryEnclosingMarkerInterceptor,
        SpringIntegrationReceiveEntryInterceptor,
        SpringIntegrationReceiveLoopEntryInterceptor,
        ServleRequestInterceptor,
        SpringBatchInterceptor,
        InfinispanExitInterceptor,
        InfinispanEntryInterceptor,
        NettyV3EntryInterceptor,
        NettyV3ExitInterceptor,
        NettyChannelPipelineProducerInterceptor,
        NettyChannelPipelineConsumerInterceptor,
        NettyMarkerInterceptor,
        NettySSLInterceptor,
        NettyV4EntryInterceptor,
        NettyV4AsyncEntryCompletionInterceptor,
        NettyV4AsyncEntryCompletionErrorInterceptor,
        NettyV4ErrorCodeInterceptor,
        NettyV4ProducerInterceptor,
        NettyV4ConsumerInterceptor,
        NettyV4ExitProducerInterceptor,
        NettyV4ExitConnectChannelProducerInterceptor,
        NettyV4ExitConsumerInterceptor,
        NettyV4ExitInterceptor,
        NettyV4ExitStartInterceptor,
        NettyV4ExitEndInterceptor,
        NettyV4ExitMarkerInterceptor,
        GenericNettyV4EntryInterceptor,
        MicronautNettyHttpEntryInterceptor,
        MicronautExitProducerInterceptor,
        MicronautExitConsumerInterceptor,
        MicronautHttpEntryInterceptor,
        MicronautSendAsyncHttpExitStartInterceptor,
        MicronautStreamAsyncHttpExitStartInterceptor,
        MicronautAsyncHttpExitEndInterceptor,
        MicronautSendHttpExitInterceptor,
        MicronautStreamHttpExitInterceptor,
        MicronautHttpEntryCompletionInterceptor,
        MicronautHttpEntryCompletionChunkInterceptor,
        MicronautAsyncEntryCompletionErrorInterceptor,
        MicronautHttpErrorCodeInterceptor,
        VertxMarkerInterceptor,
        VertxHttpEntryInterceptor,
        Vertx36PlusInProcessProducerInterceptor,
        VertxHttpInProcessConsumerInterceptor,
        VertxHttpExitInterceptor,
        VertxHttpErrorCodeInterceptor,
        VertxMessageEntryInterceptor,
        VertxMessageExitInterceptor,
        VertxHttpUriTrackingProducerInterceptor,
        VertxHttpStatusCodeConsumerInterceptor,
        VertxClientConsumerInterceptor,
        VertxHttpEntryStartInterceptor,
        VertxHttpEntryMarkerInterceptor,
        Vertx36PlustHttpEntryMarkerInterceptor,
        VertxHttpEntryCompletionInterceptor,
        VertxV4NettyHttpEntryInterceptor,
        AsyncVertxHttpExitPointStartInterceptor,
        AsyncVertxHttpExitPointEndInterceptor,
        ApacheHttpNioInterceptor,
        SynapseCallbackExecutionInterceptor,
        SynapseCallbackIdentificationInterceptor,
        SynapseCallbackReceiveInterceptor,
        SynapseContextCloneInterceptor,
        SynapseHttpCorrelationInterceptor,
        SynapseHttpDecorator,
        SynpaseHttpInterceptor,
        SynapseHttpNioDecorator,
        SynapseServerWorkerCorrelationInterceptor,
        SynapseWebServiceInterceptor,
        SocketGetInputStreamInterceptor,
        SocketGetOutputStreamInterceptor,
        SocketInputStreamReadInterceptor,
        SocketOutputStreamWriteInterceptor,
        SocketOutputStreamWrite2Interceptor,
        NIOSocketReadLongInterceptor,
        NIOSocketWriteIntInterceptor,
        NIOSocketWriteLongInterceptor,
        SocketEventStreamReadInterceptor,
        SocketEventStreamWriteInterceptor,
        NetVizSocketChannelMethodInterceptor,
        NetvizNettyStreamChannelWriteMethodInterceptor,
        JRMPExitPointInterceptor,
        CompletionListenerInterceptor,
        WebSocketReceiveInterceptor,
        WebSocketExitInterceptor,
        WebSocketOnOpenInterceptor,
        WebSocketMessageHandlerAddInterceptor,
        WebSocketMessageHandlerRemoveInterceptor,
        WebSocketOnCloseInterceptor,
        WebMethodsHTTPServerInterceptor,
        WebMethodsHttpErrorCodeInterceptor,
        WmMethodHTTPDispatchInterceptor,
        WebMethodsNativeTriggerInterceptor,
        GlassfishLifecycleEventInterceptor,
        SLF4JLoggerExceptionInterceptor,
        Log4j2LoggerMessageInterceptor,
        SLF4JLoggerMessageInterceptor,
        LogbackFormattedMessageMarkerInterceptor,
        LogbackFormattedMessageInterceptor,
        Log4j2LoggerExceptionInterceptor,
        Log4jLogRecordInterceptor,
        Log4j2LogRecordInterceptor,
        ShutdownInterceptor,
        JRubyNetHttpExitInterceptor,
        SelfServiceSocketListenerInterceptor,
        SelfServiceSocketBindInterceptor,
        Tibco5SelfServiceAppnodeInterceptor,
        Tibco6SelfServiceAppnodeInterceptor,
        NingAsyncHttpExitInterceptor,
        NingAsyncHttpExitStartInterceptor,
        NingAsyncHttpExitEndInterceptor,
        AsyncTransactionEndDemarcator,
        ETELatencyDemarcatorInterceptor,
        AAsyncExitPointStartInterceptor,
        AAsyncExitPointEndInterceptor,
        AsyncRibbonExitPointStartInterceptor,
        AsyncRibbonExitPointEndInterceptor,
        RibbonHttpExitInterceptor,
        RibbonHttpErrorInterceptor,
        RibbonConsumerInterceptor,
        JettyV9HttpExitInterceptor,
        JettyV9AsyncHttpExitStartInterceptor,
        JettyV9AsyncHttpExitEndInterceptor,
        JettyV8HttpExitInterceptor,
        JettyV8AsyncHttpExitStartInterceptor,
        JettyV8AsyncHttpExitEndInterceptor,
        WebClientExitInterceptor,
        WebClientExitStartInterceptor,
        WebClientExitEndInterceptor,
        WebClientConsumerInterceptor,
        ReactiveStreamsProducerInterceptor,
        ReactiveStreamsConsumerInterceptor,
        RxJava2ProducerInterceptor,
        RxJava2ConsumerInterceptor,
        JoltExitInterceptor,
        DynamoDBInterceptor,
        SprayEntryStartInterceptor,
        SprayEntryCompletionInterceptor,
        SprayErrorCodeInterceptor,
        SprayExitPointInterceptor,
        AsyncSprayExitStartInterceptor,
        AsyncSprayExitEndInterceptor,
        AkkaHttpStreamEntryStartInterceptor,
        AkkaHttpStreamEntryCompletionInterceptor,
        AkkaHttpEntryStartInterceptor,
        AkkaHttpSingleNodeCompletionInterceptor,
        AkkaHttpStashInterceptor,
        AkkaHttpRequestRetrieverInterceptor,
        AkkaHttpResponseInterceptor,
        AkkaHttpMultiNodeCompletionInterceptor,
        AkkaHttpExitInterceptor,
        AsyncAkkaHttpExitStartInterceptor,
        AsyncAkkaHttpExitEndInterceptor,
        AsyncAkka25HttpExitEndInterceptor,
        AkkaHttpErrorCodeInterceptor,
        AkkaHttpRequestStashInterceptor,
        WebMethodsBrokerExit,
        UniversalMessageProducerExit,
        DefaultDispatcherInterceptor,
        WebMethodsBrokerEntry,
        BCIEngineInitInterceptor,
        MongoDBAddCommandListenerInterceptor,
        MongoDBCommandSucceededListenerInterceptor,
        MongoDBCommandFailedListenerInterceptor,
        NoHostAvailableInterceptor,
        MongoDBCommandStartListenerInterceptor,
        MongoDBAsyncExitInterceptor,
        MongoDBAsyncExitStartInterceptor,
        MongoDBAsyncExitEndInterceptor,
        MongoDBStorePayloadInterceptor,
        MongoDBProducerInterceptor,
        MongoDBConsumerInterceptor,
        MongoDBAsyncConnectionErrorInterceptor,
        SlowHeapCountInterceptor,
        FastHeapCountInterceptor,
        HeapCountTraceInterceptor,
        DatastaxExitPointInterceptor,
        CQLErrorInterceptor,
        Datastax1ExitPointInterceptor,
        Datastax4ExitPointInterceptor,
        Datastax4AsyncExitStartInterceptor,
        Datastax4AsyncExitEndInterceptor,
        EntryDispatch,
        ExitDispatch,
        DataCollectorDispatch,
        InfoPointDispatch,
        GenericDispatch,
        AsyncExitStartDispatch,
        AsyncExitEndDispatch,
        AsyncExitInProcessProducer,
        AsyncExitInProcessConsumer,
        SocketAcceptedInterceptor,
        SocketClosedInterceptor,
        GlassfishJerseySplitInterceptor,
        SocketConnectedInterceptor,
        MidDataCollectorDispatch,
        JMSExitPointInterceptor,
        JMSExitPointWithDestinationInterceptor,
        MQGetExitPointInterceptor,
        WMQGetEntryExitInterceptor,
        WMQPutExitPointInterceptor,
        JakartaMessagingExitPointInterceptor,
        JakartaMessagingExitPointWithDestinationInterceptor,
        JakartaMessageListenerInterceptor,
        Java9HttpRequestDecarator,
        Java9HttpClientDecarator,
        Axis2RPCClientInterceptor,
        AxisClientInterceptor,
        Axis2WorkerCorrelationInterceptor,
        CXFClientInterceptor,
        JAXWSRIClientInterceptor,
        Oc4JWSClientInterceptor,
        SpringWebServiceClientInterceptor,
        WAS61JAXRPCClientInterceptor,
        WLSJAXRPCClientInterceptor,
        XFireClientInterceptor,
        IbmBpmUserTaskStartEntryInterceptor,
        IbmBpmUserTaskEndEntryInterceptor,
        IbmBpmUserTaskServiceMarkerInterceptor,
        IbmBpmUserTaskServiceActivityHolderInterceptor,
        IbmBpmUserTaskServiceEntryInterceptor,
        IbmBpmUserTaskCoachReqResHolderInterceptor,
        IbmBpmUserTaskCoachEntryInterceptor,
        IbmBpmSystemTaskEntryInterceptor,
        IbmBpmUserTaskStartProducerInterceptor,
        IbmBpmUserTaskServiceProducerInterceptor,
        IbmBpmUserTaskServiceConsumerInterceptor,
        IbmBpmUserTaskCoachConsumerInterceptor,
        IbmBpmUserTaskEndConsumerInterceptor,
        ThreadPoolExecuteInterceptor,
        ThreadPoolAfterExecuteInterceptor,
        ThreadPoolBeforeExecuteInterceptor,
        JNDILookupInterceptor,
        ObjectPoolLeaseInterceptor,
        ObjectPoolLeaseCompletedInterceptor,
        ObjectPoolReleaseInterceptor,
        Servlet3AsyncEntryMarkerInterceptor,
        Servlet3AsyncContextCompletionInterceptor,
        Servlet3AsyncDispatchProducerInterceptor,
        Servlet3AsyncDispatchConsumerInterceptor,
        JettyHandlerDispatchConsumerInterceptor,
        AnalyticsAutoDataCollectionInterceptor,
        Java11AsyncClientExitInterceptor,
        Java11AsyncClientExitStartInterceptor,
        Java11AsyncClientExitEndInterceptor,
        DaplKafkaProducerInterceptor,
        DaplKafkaProducerRecordInterceptor,
        DaplKafkaConsumerInterceptor,
        DaplKafkaConsumerLagInterceptor,
        DaplKafkaStreamsInterceptor,
        DaplKafkaStreamsProcessorInterceptor,
        DaplKafkaStreamsContextInterceptor,
        DaplKafkaStreamsConsumerRecordInterceptor,
        GrpcEntryInterceptor,
        GrpcAsyncEntryMarkerInterceptor,
        GrpcAsyncEntryCompletionInterceptor,
        GrpcClientExitInterceptor,
        GrpcAsyncExitStartInterceptor,
        GrpcAsyncExitEndInterceptor,
        Http4sExitInterceptor,
        Http4sExitStartInterceptor,
        Http4sExitEndInterceptor,
        CouchbaseExitInterceptor,
        CouchbaseExitStartInterceptor,
        CouchbaseExitEndInterceptor,
        Wso2HttpEntryInterceptor,
        Wso2AsyncEntryCompletionInterceptor,
        Wso2HttpErrorCodeInterceptor,
        Wso2ConsumerInterceptor,
        Wso2HttpExitInterceptor,
        Wso2HttpExitStartInterceptor,
        Wso2HttpExitEndInterceptor;

    }
}

