/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.bootimpl;

import com.singularity.ee.agent.appagent.AgentEntryPoint;
import com.singularity.ee.agent.appagent.boot.ThreadInterceptorStateChangeNotifier;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BreakTracker;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.FastInterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastInterceptorClassRegistry;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastMethodInterceptorDelegator;
import com.singularity.ee.agent.appagent.kernel.bootimpl.BaseMethodInterceptorDelegatorImpl;
import com.singularity.ee.agent.appagent.kernel.bootimpl.IInterceptorMeasurer;
import com.singularity.ee.agent.appagent.kernel.bootimpl.InterceptorTimer;
import com.singularity.ee.agent.appagent.kernel.bootimpl.MutableTransformationId;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FastMethodInterceptorDelegatorImpl
extends BaseMethodInterceptorDelegatorImpl
implements IFastMethodInterceptorDelegator {
    static ThreadLocal<InterceptorInvocationWrapper> tlInterceptorWrapper = new ThreadLocal();
    private Object disabledMarker = new Object();
    private static final boolean IS_RE_TRANSFORM_NOT_SUPPORTED = !AgentEntryPoint.reTransformSupported;
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private ThreadLocal<MutableTransformationId> reentrantCheck = new ThreadLocal<MutableTransformationId>(){

        @Override
        protected MutableTransformationId initialValue() {
            return new MutableTransformationId(0);
        }
    };
    private final IFastInterceptorClassRegistry interceptorClassRegistry = FastInterceptorClassRegistryBoot.getRegisteredImplementation();

    public final int getTransformationId() {
        return this.reentrantCheck.get().getValue();
    }

    @Override
    public final void setAgentDisabled(boolean agentDisabled) {
        this.agentDisabled = agentDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object safeOnMethodBegin(int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues) {
        if (this.agentDisabled || this.disabled) {
            return this.disabledMarker;
        }
        if (this.interceptorClassRegistry.shouldNotDispatchFMID(fastInterceptorId)) {
            return null;
        }
        MutableTransformationId mutableTransformationId = null;
        if (this.interceptorClassRegistry.shouldIgnoreReEntrantCheckOnBegin(fastInterceptorId)) {
            mutableTransformationId = this.reentrantCheck.get();
            if (mutableTransformationId.isSet()) {
                return null;
            }
            mutableTransformationId.setValue(transformationId);
        }
        try {
            Object object = this.safeOnMethodBeginNoReentrantCheck(fastInterceptorId, transformationId, invokedObject, className, methodName, paramValues);
            if (mutableTransformationId != null) {
                mutableTransformationId.reset();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (mutableTransformationId != null) {
                    mutableTransformationId.reset();
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object safeOnMethodBeginNoReentrantCheck(int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues) {
        Object object;
        block18: {
            IFastMethodInterceptor interceptor = this.interceptorClassRegistry.getFastInterceptorInstance(fastInterceptorId);
            if (interceptor == null) {
                this.safeWarn("WARNING: FastMethodInterceptor id " + fastInterceptorId + " invalid. Interceptor invoke failed on " + className + "." + methodName, null);
            }
            try {
                if (IS_RE_TRANSFORM_NOT_SUPPORTED && transformationId > 0 && transformationId < 5000 && BreakTracker.getBreakerArray()[transformationId]) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Object state;
                ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(true);
                if (InterceptorTimer.ENABLED) {
                    InterceptorTimer.onBeginBegin(transformationId);
                }
                if (this.usePrivilegedAction) {
                    state = FastMethodInterceptorDelegatorImpl.runInterceptorMethodBegin(interceptor, fastInterceptorId, transformationId, invokedObject, className, methodName, paramValues);
                } else {
                    long startTimeInNanos = 0L;
                    long startCPUTimeInNanos = 0L;
                    IInterceptorMeasurer interceptorMeasurer = BaseMethodInterceptorDelegatorImpl.interceptorMeasurer;
                    if (interceptorMeasurer != null && interceptorMeasurer.isFastInterceptorMeasurementStarted(fastInterceptorId, interceptor)) {
                        startTimeInNanos = interceptorMeasurer.getStartTimeInNanos();
                        startCPUTimeInNanos = interceptorMeasurer.getStartCPUTimeInNanos();
                    }
                    state = interceptor.onMethodBegin(invokedObject, className, methodName, paramValues, transformationId);
                    if (startTimeInNanos != 0L) {
                        interceptorMeasurer.onFastInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, fastInterceptorId, interceptor, CallType.METHOD_BEGIN);
                    }
                }
                object = state;
                if (!InterceptorTimer.ENABLED) break block18;
            }
            catch (Exception t) {
                try {
                    try {
                        this.safeWarn("WARNING: Error thrown by FastMethodInterceptor's onMethodBegin for " + interceptor.getClass().getName() + " : " + t.getMessage(), t);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (InterceptorTimer.ENABLED) {
                            InterceptorTimer.onBeginEnd(transformationId);
                        }
                        ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(false);
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            InterceptorTimer.onBeginEnd(transformationId);
        }
        ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(false);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void safeOnMethodEnd(int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues, Object state, Throwable thrownException, Object returnValue) {
        try {
            if (invokedObject == null && methodName.equals(CONSTRUCTOR_METHOD_NAME)) {
                return;
            }
            if (state == this.disabledMarker) {
                return;
            }
            MutableTransformationId mutableTransformationId = this.reentrantCheck.get();
            if (mutableTransformationId.isSet()) {
                return;
            }
            mutableTransformationId.setValue(transformationId);
            try {
                this.safeOnMethodEndNoReentrantCheck(fastInterceptorId, transformationId, invokedObject, className, methodName, paramValues, state, thrownException, returnValue);
            }
            finally {
                mutableTransformationId.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void safeOnMethodEndNoReentrantCheck(int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues, Object state, Throwable thrownException, Object returnValue) {
        try {
            IFastMethodInterceptor interceptor = this.interceptorClassRegistry.getFastInterceptorInstance(fastInterceptorId);
            if (interceptor == null) {
                this.safeWarn("WARNING: FastMethodInterceptor id " + fastInterceptorId + " invalid. Interceptor invoke failed.", null);
                return;
            }
            try {
                if (IS_RE_TRANSFORM_NOT_SUPPORTED && transformationId > 0 && transformationId < 5000 && BreakTracker.getBreakerArray()[transformationId]) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(true);
                if (InterceptorTimer.ENABLED) {
                    InterceptorTimer.onEndBegin(transformationId);
                }
                if (this.usePrivilegedAction) {
                    FastMethodInterceptorDelegatorImpl.runInterceptorMethodEnd(interceptor, fastInterceptorId, transformationId, invokedObject, className, methodName, paramValues, state, returnValue, thrownException);
                } else {
                    long startTimeInNanos = 0L;
                    long startCPUTimeInNanos = 0L;
                    IInterceptorMeasurer interceptorMeasurer = BaseMethodInterceptorDelegatorImpl.interceptorMeasurer;
                    if (interceptorMeasurer != null && interceptorMeasurer.isFastInterceptorMeasurementStarted(fastInterceptorId, interceptor)) {
                        startTimeInNanos = interceptorMeasurer.getStartTimeInNanos();
                        startCPUTimeInNanos = interceptorMeasurer.getStartCPUTimeInNanos();
                    }
                    interceptor.onMethodEnd(state, invokedObject, className, methodName, paramValues, thrownException, returnValue, transformationId);
                    if (startTimeInNanos != 0L) {
                        interceptorMeasurer.onFastInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, fastInterceptorId, interceptor, CallType.METHOD_END);
                    }
                }
            }
            catch (Exception t) {
                this.safeWarn("WARNING: Error thrown by FastMethodInterceptor's onMethodEnd for " + interceptor.getClass().getName() + " : " + t.getMessage(), t);
            }
            finally {
                if (InterceptorTimer.ENABLED) {
                    InterceptorTimer.onEndEnd(transformationId);
                }
                ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void safeOnMethodMiddle(int fastInterceptorId, int transformationId, int midMethodId, Object invokedObject, String className, String methodName, Object[] paramValues, Object[] localVars, int lineNum) {
        IFastMethodInterceptor interceptor = this.interceptorClassRegistry.getFastInterceptorInstance(fastInterceptorId);
        if (interceptor == null) {
            return;
        }
        interceptor.onMethodMiddle(invokedObject, className, methodName, paramValues, localVars, lineNum, transformationId, midMethodId);
    }

    static void runInterceptorMethodEnd(IFastMethodInterceptor interceptor, int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues, Object state, Object returnValue, Throwable thrownException) {
        InterceptorInvocationWrapper interceptorWrapper = tlInterceptorWrapper.get();
        if (interceptorWrapper == null) {
            interceptorWrapper = new InterceptorInvocationWrapper();
            tlInterceptorWrapper.set(interceptorWrapper);
        }
        interceptorWrapper.setArgsForMethodEnd(interceptor, fastInterceptorId, transformationId, invokedObject, className, methodName, paramValues, state, returnValue, thrownException);
        AccessController.doPrivileged(interceptorWrapper);
    }

    static Object runInterceptorMethodBegin(IFastMethodInterceptor interceptor, int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues) {
        InterceptorInvocationWrapper interceptorWrapper = tlInterceptorWrapper.get();
        if (interceptorWrapper == null) {
            interceptorWrapper = new InterceptorInvocationWrapper();
            tlInterceptorWrapper.set(interceptorWrapper);
        }
        interceptorWrapper.setArgsForMethodBegin(interceptor, fastInterceptorId, transformationId, invokedObject, className, methodName, paramValues);
        return AccessController.doPrivileged(interceptorWrapper);
    }

    private static final class InterceptorInvocationWrapper
    implements PrivilegedAction<Object> {
        private CallType callType;
        private int transformationId;
        private int fastInterceptorId;
        private Object invokedObject;
        private Object state;
        private Object returnValue;
        private Throwable thrownException;
        private String className;
        private String methodName;
        private Object[] paramValues;
        private IFastMethodInterceptor interceptor;

        InterceptorInvocationWrapper() {
        }

        void setArgsForMethodBegin(IFastMethodInterceptor interceptor, int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues) {
            this.callType = CallType.METHOD_BEGIN;
            this.interceptor = interceptor;
            this.fastInterceptorId = fastInterceptorId;
            this.transformationId = transformationId;
            this.invokedObject = invokedObject;
            this.className = className;
            this.methodName = methodName;
            this.paramValues = paramValues;
        }

        void setArgsForMethodEnd(IFastMethodInterceptor interceptor, int fastInterceptorId, int transformationId, Object invokedObject, String className, String methodName, Object[] paramValues, Object state, Object returnValue, Throwable thrownException) {
            this.interceptor = interceptor;
            this.callType = CallType.METHOD_END;
            this.fastInterceptorId = fastInterceptorId;
            this.transformationId = transformationId;
            this.invokedObject = invokedObject;
            this.className = className;
            this.methodName = methodName;
            this.paramValues = paramValues;
            this.state = state;
            this.returnValue = returnValue;
            this.thrownException = thrownException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() {
            Object returnObject = null;
            long startTimeInNanos = 0L;
            long startCPUTimeInNanos = 0L;
            IInterceptorMeasurer interceptorMeasurer = BaseMethodInterceptorDelegatorImpl.interceptorMeasurer;
            if (interceptorMeasurer != null && interceptorMeasurer.isFastInterceptorMeasurementStarted(this.fastInterceptorId, this.interceptor)) {
                startTimeInNanos = interceptorMeasurer.getStartTimeInNanos();
                startCPUTimeInNanos = interceptorMeasurer.getStartCPUTimeInNanos();
            }
            switch (this.callType) {
                case METHOD_BEGIN: {
                    try {
                        returnObject = this.interceptor.onMethodBegin(this.invokedObject, this.className, this.methodName, this.paramValues, this.transformationId);
                        if (startTimeInNanos == 0L) break;
                        interceptorMeasurer.onFastInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, this.fastInterceptorId, this.interceptor, CallType.METHOD_BEGIN);
                        break;
                    }
                    finally {
                        this.invokedObject = null;
                        this.paramValues = null;
                    }
                }
                case METHOD_END: {
                    try {
                        this.interceptor.onMethodEnd(this.state, this.invokedObject, this.className, this.methodName, this.paramValues, this.thrownException, this.returnValue, this.transformationId);
                        if (startTimeInNanos == 0L) break;
                        interceptorMeasurer.onFastInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, this.fastInterceptorId, this.interceptor, CallType.METHOD_END);
                        break;
                    }
                    finally {
                        this.invokedObject = null;
                        this.paramValues = null;
                        this.thrownException = null;
                        this.returnValue = null;
                    }
                }
            }
            return returnObject;
        }
    }

    public static enum CallType {
        METHOD_BEGIN,
        METHOD_END;

    }
}

