/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.bootimpl;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IInterceptorClassRegistry;
import com.singularity.ee.agent.util.io.Console;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.util.concurrent.ConcurrentHashMap;

public class InterceptorClassRegistry
implements IInterceptorClassRegistry {
    private static final ConcurrentHashMap<String, Class<? extends AMethodInterceptor>> interceptorClasses = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AMethodInterceptor> staticInterceptorObjects = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> classNameToNameMap = new ConcurrentHashMap(128);
    private static final ConcurrentHashMap<String, String> classNameToDescMap = new ConcurrentHashMap(128);
    private static final ConcurrentHashMap<String, Integer> classNameToPriorityMap = new ConcurrentHashMap(128);
    private static final ConcurrentHashMap<String, String> nameToClassNameMap = new ConcurrentHashMap(128);
    static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bootimplInterceptorClassRegistry");

    public static final void bindStaticInterceptorObject(String className, AMethodInterceptor object) {
        staticInterceptorObjects.put(className, object);
        interceptorClasses.put(className, object.getClass());
        InterceptorClassRegistry.initNameCache(object);
    }

    public final void bindClass(String className, Class<? extends AMethodInterceptor> clazz) {
        interceptorClasses.put(className, clazz);
        InterceptorClassRegistry.initNameCache(clazz);
    }

    public static final Class<? extends AMethodInterceptor> getClass(String className) {
        return interceptorClasses.get(className);
    }

    public static final AMethodInterceptor getStaticInterceptorObject(String className) {
        return staticInterceptorObjects.get(className);
    }

    protected static final void initNameCache(Class<? extends AMethodInterceptor> interceptorClass) {
        String name = classNameToNameMap.get(interceptorClass.getName());
        if (name == null) {
            try {
                AMethodInterceptor methodInterceptor = interceptorClass.newInstance();
                InterceptorClassRegistry._initNameCache(methodInterceptor);
            }
            catch (Throwable e) {
                Console.out().println("Error instantiating interceptor " + interceptorClass.getName() + ", reason " + e);
                e.printStackTrace(Console.out());
                name = interceptorClass.getName();
                classNameToNameMap.put(name, name);
                classNameToDescMap.put(name, name);
                nameToClassNameMap.put(name, name);
                classNameToPriorityMap.put(interceptorClass.getName(), 0);
            }
        }
    }

    public static final void initNameCache(AMethodInterceptor instance) {
        String name = classNameToNameMap.get(instance.getClass().getName());
        if (name == null) {
            InterceptorClassRegistry._initNameCache(instance);
        }
    }

    private static final void _initNameCache(AMethodInterceptor instance) {
        String name = instance.getName();
        String desc = instance.getDescription();
        int priority = instance.getPriority();
        String className = instance.getClass().getName();
        classNameToNameMap.put(className, name);
        classNameToDescMap.put(className, desc != null ? desc : name);
        nameToClassNameMap.put(name, className);
        classNameToPriorityMap.put(className, priority);
    }

    protected final void removeFromNameCache(Class<? extends AMethodInterceptor> interceptorClass, AMethodInterceptor interceptor) {
        classNameToNameMap.remove(interceptorClass.getName());
        classNameToDescMap.remove(interceptorClass.getName());
        nameToClassNameMap.remove(interceptor.getName());
        classNameToPriorityMap.remove(interceptorClass.getName());
    }

    public final String getInterceptorName(Class<? extends AMethodInterceptor> interceptorClass) {
        return classNameToNameMap.get(interceptorClass.getName());
    }

    public final String getInterceptorDescription(Class<? extends AMethodInterceptor> interceptorClass) {
        return classNameToDescMap.get(interceptorClass.getName());
    }

    public final int getInterceptorPriority(Class<? extends AMethodInterceptor> interceptorClass) {
        Integer value = classNameToPriorityMap.get(interceptorClass.getName());
        return value == null ? 0 : value;
    }

    public final String getInterceptorClassName(String className) {
        return nameToClassNameMap.get(className);
    }
}

