/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.bootimpl;

import com.singularity.ee.agent.util.io.Console;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class InterceptorTimer {
    public static final boolean ENABLED = System.getProperty("appdynamics.time.interceptors") != null;
    private static final int MAX_TRANSFORMATION_IDS = 1000;
    private static Vector<ThreadData> values = new Vector();
    private static boolean runtimeEnabled = true;
    private static Map<Integer, Counter> previousInterceptorDataMap = null;
    static ThreadLocal<ThreadData> threadData = new ThreadLocal<ThreadData>(){

        @Override
        protected ThreadData initialValue() {
            return new ThreadData();
        }
    };

    public static synchronized void setRuntimeEnabled(boolean flag) {
        runtimeEnabled = flag;
    }

    public static void onBeginBegin(int transformationId) {
        if (!runtimeEnabled) {
            return;
        }
        try {
            InterceptorTimer.threadData.get().startTime.value = System.nanoTime();
        }
        catch (Exception e) {
            e.printStackTrace(Console.out());
        }
    }

    public static void onBeginEnd(int transformationId) {
        if (!runtimeEnabled) {
            return;
        }
        try {
            if (transformationId < 0) {
                transformationId = 0;
            }
            ThreadData data = threadData.get();
            data.beginTime[transformationId].increment(System.nanoTime() - data.startTime.value);
            data.beginCount[transformationId].increment();
        }
        catch (Exception e) {
            e.printStackTrace(Console.out());
        }
    }

    public static void onEndBegin(int transformationId) {
        if (!runtimeEnabled) {
            return;
        }
        try {
            InterceptorTimer.threadData.get().startTime.value = System.nanoTime();
        }
        catch (Exception e) {
            e.printStackTrace(Console.out());
        }
    }

    public static void onEndEnd(int transformationId) {
        if (!runtimeEnabled) {
            return;
        }
        try {
            if (transformationId < 0) {
                transformationId = 0;
            }
            ThreadData data = threadData.get();
            data.endTime[transformationId].increment(System.nanoTime() - data.startTime.value);
            data.endCount[transformationId].increment();
        }
        catch (Exception e) {
            e.printStackTrace(Console.out());
        }
    }

    public static void clearData() {
        InterceptorTimer.setRuntimeEnabled(false);
        previousInterceptorDataMap = null;
        values.clear();
        InterceptorTimer.setRuntimeEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Counter> dumpInterceptorData() {
        InterceptorTimer.setRuntimeEnabled(false);
        try {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Console.out());
            }
            HashMap<Integer, Counter> mergedDataMap = new HashMap<Integer, Counter>();
            for (ThreadData value : values) {
                for (int transformationId = 0; transformationId < 1000; ++transformationId) {
                    if (value.beginCount[transformationId].value == 0L) continue;
                    Counter data = (Counter)mergedDataMap.get(transformationId);
                    if (data == null) {
                        data = new Counter();
                        data.transformationId = transformationId;
                        mergedDataMap.put(transformationId, data);
                    }
                    data.totalBeginTime += value.beginTime[transformationId].value;
                    data.totalBeginCount += value.beginCount[transformationId].value;
                    data.totalEndTime += value.endTime[transformationId].value;
                    data.totalEndCount += value.endCount[transformationId].value;
                }
            }
            HashMap<Integer, Counter> hashMap = mergedDataMap;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace(Console.out());
            Map<Integer, Counter> map = null;
            return map;
        }
        finally {
            InterceptorTimer.setRuntimeEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Counter> dumpInterceptorDataForCurrentInterval(Map<Integer, Counter> totalInterceptorDataMap) {
        Object object;
        InterceptorTimer.setRuntimeEnabled(false);
        try {
            HashMap<Integer, Counter> currentIntervalInterceptorDataMap = new HashMap<Integer, Counter>();
            for (Integer transformationId : totalInterceptorDataMap.keySet()) {
                Counter totalInterceptorData = totalInterceptorDataMap.get(transformationId);
                if (previousInterceptorDataMap == null) {
                    previousInterceptorDataMap = totalInterceptorDataMap;
                    Map<Integer, Counter> map = totalInterceptorDataMap;
                    return map;
                }
                Counter previousInterceptorData = previousInterceptorDataMap.get(transformationId);
                if (previousInterceptorData == null) {
                    Console.out().println("Previous data is null");
                    currentIntervalInterceptorDataMap.put(transformationId, totalInterceptorData);
                    continue;
                }
                Counter currentIntervalInterceptorData = new Counter();
                currentIntervalInterceptorData.totalBeginCount = totalInterceptorData.totalBeginCount - previousInterceptorData.totalBeginCount;
                currentIntervalInterceptorData.totalBeginTime = totalInterceptorData.totalBeginTime - previousInterceptorData.totalBeginTime;
                currentIntervalInterceptorData.totalEndCount = totalInterceptorData.totalEndCount - previousInterceptorData.totalEndCount;
                currentIntervalInterceptorData.totalEndTime = totalInterceptorData.totalEndTime - previousInterceptorData.totalEndTime;
                currentIntervalInterceptorData.transformationId = totalInterceptorData.transformationId;
                currentIntervalInterceptorDataMap.put(transformationId, currentIntervalInterceptorData);
            }
            previousInterceptorDataMap = totalInterceptorDataMap;
            object = currentIntervalInterceptorDataMap;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace(Console.out());
            object = null;
            return object;
        }
        finally {
            InterceptorTimer.setRuntimeEnabled(true);
        }
    }

    public static class Counter {
        public long totalBeginTime;
        public long totalBeginCount;
        public long totalEndTime;
        public long totalEndCount;
        public int transformationId;
    }

    static class ThreadData {
        public MyLong[] beginCount = new MyLong[1000];
        public MyLong[] beginTime = new MyLong[1000];
        public MyLong[] endCount = new MyLong[1000];
        public MyLong[] endTime = new MyLong[1000];
        MyLong startTime = new MyLong();

        public ThreadData() {
            this.fill(this.beginCount);
            this.fill(this.beginTime);
            this.fill(this.endCount);
            this.fill(this.endTime);
            values.add(this);
        }

        private void fill(MyLong[] arr) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new MyLong();
            }
        }
    }

    static class MyLong {
        long value = 0L;

        MyLong() {
        }

        public void set(long l) {
            this.value = l;
        }

        public void increment() {
            ++this.value;
        }

        public void increment(long l) {
            this.value += l;
        }
    }
}

