/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.bootimpl;

import com.singularity.ee.agent.appagent.AgentEntryPoint;
import com.singularity.ee.agent.appagent.boot.ThreadInterceptorStateChangeNotifier;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BaseMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BreakTracker;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IMethodInterceptorDelegator;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.MethodExecutionEnvironment;
import com.singularity.ee.agent.appagent.kernel.bootimpl.BaseMethodInterceptorDelegatorImpl;
import com.singularity.ee.agent.appagent.kernel.bootimpl.IInterceptorMeasurer;
import com.singularity.ee.agent.appagent.kernel.bootimpl.InterceptorClassRegistry;
import com.singularity.ee.agent.appagent.kernel.bootimpl.InterceptorTimer;
import com.singularity.ee.agent.appagent.kernel.bootimpl.MutableTransformationId;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class MethodInterceptorDelegatorImpl
extends BaseMethodInterceptorDelegatorImpl
implements IMethodInterceptorDelegator {
    final ThreadLocal<InterceptorInvocationWrapper> tlInterceptorWrapper = new ThreadLocal();
    private static final boolean IS_RE_TRANSFORM_NOT_SUPPORTED = !AgentEntryPoint.reTransformSupported;
    private static ThreadLocal<MutableTransformationId> reentrantCheck = new ThreadLocal<MutableTransformationId>(){

        @Override
        protected MutableTransformationId initialValue() {
            return new MutableTransformationId(0);
        }
    };
    private Object interceptors;

    public final int getTransformationId() {
        return reentrantCheck.get().getValue();
    }

    public MethodInterceptorDelegatorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInterceptorDelegatorImpl(String[] interceptorClassNames, int[] transformationIds) {
        try {
            if (this.agentDisabled || this.disabled) {
                return;
            }
            if (reentrantCheck.get().isSet()) {
                return;
            }
            reentrantCheck.get().setAsUnknown();
            try {
                if (interceptorClassNames.length == 1) {
                    Class<? extends AMethodInterceptor> interceptorClass;
                    this.interceptors = InterceptorClassRegistry.getStaticInterceptorObject(interceptorClassNames[0]);
                    if (this.interceptors == null && (interceptorClass = this.getInterceptorClass(interceptorClassNames[0])) != null) {
                        try {
                            this.interceptors = interceptorClass.newInstance();
                            ((AMethodInterceptor)this.interceptors).setTransformationId(transformationIds[0]);
                        }
                        catch (Throwable t) {
                            this.safeWarn("Error while creating MethodInterceptor instance for " + interceptorClassNames[0] + " : " + t.getMessage(), t);
                        }
                    }
                } else {
                    this.interceptors = new AMethodInterceptor[interceptorClassNames.length];
                    for (int i = 0; i < interceptorClassNames.length; ++i) {
                        Class<? extends AMethodInterceptor> interceptorClass;
                        ((AMethodInterceptor[])this.interceptors)[i] = InterceptorClassRegistry.getStaticInterceptorObject(interceptorClassNames[i]);
                        if (((AMethodInterceptor[])this.interceptors)[i] != null || (interceptorClass = this.getInterceptorClass(interceptorClassNames[i])) == null) continue;
                        try {
                            ((AMethodInterceptor[])this.interceptors)[i] = interceptorClass.newInstance();
                            ((AMethodInterceptor[])this.interceptors)[i].setTransformationId(transformationIds[i]);
                            continue;
                        }
                        catch (Throwable t) {
                            this.safeWarn("Error while creating MethodInterceptor instance for " + interceptorClassNames[i] + " : " + t.getMessage(), t);
                        }
                    }
                }
            }
            finally {
                reentrantCheck.get().reset();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final Class<? extends AMethodInterceptor> getInterceptorClass(String interceptorClassName) {
        Class<? extends AMethodInterceptor> interceptorClass = InterceptorClassRegistry.getClass(interceptorClassName);
        if (interceptorClass == null) {
            this.safeWarn("Error while creating MethodInterceptor instance for " + interceptorClassName + " : Could not find class.", null);
        }
        return interceptorClass;
    }

    public final void safeOnMethodBegin(MethodExecutionEnvironment env) {
        block15: {
            try {
                if (this.interceptors == null) {
                    return;
                }
                if (reentrantCheck.get().isSet()) {
                    return;
                }
                reentrantCheck.get().setAsUnknown();
                try {
                    ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(true);
                    if (this.interceptors instanceof AMethodInterceptor) {
                        if (this.usePrivilegedAction) {
                            this.runInterceptor(CallType.SAFE_ON_METHOD_BEGIN, (AMethodInterceptor)this.interceptors, env);
                        } else {
                            this.invokeOnBegin(env, (AMethodInterceptor)this.interceptors);
                        }
                    } else {
                        for (int i = 0; i < ((AMethodInterceptor[])this.interceptors).length; ++i) {
                            if (this.usePrivilegedAction) {
                                this.runInterceptor(CallType.SAFE_ON_METHOD_BEGIN, ((AMethodInterceptor[])this.interceptors)[i], env);
                                continue;
                            }
                            this.invokeOnBegin(env, ((AMethodInterceptor[])this.interceptors)[i]);
                        }
                    }
                }
                finally {
                    reentrantCheck.get().reset();
                    ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(false);
                }
            }
            catch (Throwable t) {
                try {
                    this.safeWarn("Fatal error: ", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!BaseMethodInterceptorDelegatorBoot.shouldPropagateErrorToApplication((Throwable)t)) break block15;
                throw (Error)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invokeOnBegin(MethodExecutionEnvironment env, AMethodInterceptor interceptor) {
        block16: {
            try {
                if (interceptor == null) break block16;
                int transformationId = interceptor.getTransformationId();
                try {
                    if (IS_RE_TRANSFORM_NOT_SUPPORTED && transformationId < 5000 && BreakTracker.getBreakerArray()[transformationId]) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                reentrantCheck.get().setValue(transformationId);
                if (InterceptorTimer.ENABLED) {
                    InterceptorTimer.onBeginBegin(transformationId);
                }
                if (this.usePrivilegedAction) {
                    this.runInterceptor(CallType.METHOD_BEGIN, interceptor, env);
                } else {
                    long startTimeInNanos = 0L;
                    long startCPUTimeInNanos = 0L;
                    IInterceptorMeasurer interceptorMeasurer = BaseMethodInterceptorDelegatorImpl.interceptorMeasurer;
                    if (interceptorMeasurer != null && interceptorMeasurer.isSlowInterceptorMeasurementStarted(env, interceptor)) {
                        startTimeInNanos = interceptorMeasurer.getStartTimeInNanos();
                        startCPUTimeInNanos = interceptorMeasurer.getStartCPUTimeInNanos();
                    }
                    interceptor.onMethodBegin(env);
                    if (startTimeInNanos != 0L) {
                        interceptorMeasurer.onSlowInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, env, interceptor, CallType.METHOD_BEGIN);
                    }
                }
            }
            catch (Exception t) {
                if (interceptor != null) {
                    this.safeWarn("Error thrown by MethodInterceptor's onMethodBeginTracked for " + interceptor.getClass().getName() + " : " + t.getMessage(), t);
                }
            }
            finally {
                if (InterceptorTimer.ENABLED && interceptor != null) {
                    InterceptorTimer.onBeginEnd(interceptor.getTransformationId());
                }
            }
        }
    }

    public final void safeOnMethodEndNormal(MethodExecutionEnvironment env) {
        this.safeOnMethodEnd(env);
    }

    public final void safeOnMethodEndException(MethodExecutionEnvironment env) {
        this.safeOnMethodEnd(env);
    }

    private void safeOnMethodEnd(MethodExecutionEnvironment env) {
        block15: {
            try {
                ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(true);
                if (this.interceptors == null) {
                    return;
                }
                if (reentrantCheck.get().isSet()) {
                    return;
                }
                reentrantCheck.get().setAsUnknown();
                try {
                    if (this.interceptors instanceof AMethodInterceptor) {
                        if (this.usePrivilegedAction) {
                            this.runInterceptor(CallType.SAFE_ON_METHOD_END, (AMethodInterceptor)this.interceptors, env);
                        } else {
                            this.invokeOnEnd(env, (AMethodInterceptor)this.interceptors);
                        }
                    } else {
                        for (int i = ((AMethodInterceptor[])this.interceptors).length - 1; i >= 0; --i) {
                            if (this.usePrivilegedAction) {
                                this.runInterceptor(CallType.SAFE_ON_METHOD_END, ((AMethodInterceptor[])this.interceptors)[i], env);
                                continue;
                            }
                            this.invokeOnEnd(env, ((AMethodInterceptor[])this.interceptors)[i]);
                        }
                    }
                }
                finally {
                    reentrantCheck.get().reset();
                    ThreadInterceptorStateChangeNotifier.getInstance().setInterceptorRunningOnThread(false);
                }
            }
            catch (Throwable t) {
                try {
                    this.safeWarn("Fatal error: ", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!BaseMethodInterceptorDelegatorBoot.shouldPropagateErrorToApplication((Throwable)t)) break block15;
                throw (Error)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invokeOnEnd(MethodExecutionEnvironment env, AMethodInterceptor interceptor) {
        block16: {
            try {
                if (interceptor == null) break block16;
                int transformationId = interceptor.getTransformationId();
                try {
                    if (IS_RE_TRANSFORM_NOT_SUPPORTED && transformationId < 5000 && BreakTracker.getBreakerArray()[transformationId]) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                reentrantCheck.get().setValue(transformationId);
                if (InterceptorTimer.ENABLED) {
                    InterceptorTimer.onEndBegin(transformationId);
                }
                if (this.usePrivilegedAction) {
                    this.runInterceptor(CallType.METHOD_END, interceptor, env);
                } else {
                    long startTimeInNanos = 0L;
                    long startCPUTimeInNanos = 0L;
                    IInterceptorMeasurer interceptorMeasurer = BaseMethodInterceptorDelegatorImpl.interceptorMeasurer;
                    if (interceptorMeasurer != null && interceptorMeasurer.isSlowInterceptorMeasurementStarted(env, interceptor)) {
                        startTimeInNanos = interceptorMeasurer.getStartTimeInNanos();
                        startCPUTimeInNanos = interceptorMeasurer.getStartCPUTimeInNanos();
                    }
                    interceptor.onMethodEnd(env);
                    if (startTimeInNanos != 0L) {
                        interceptorMeasurer.onSlowInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, env, interceptor, CallType.METHOD_END);
                    }
                }
            }
            catch (Exception t) {
                if (interceptor != null) {
                    this.safeWarn("Error thrown by MethodInterceptor's onMethodEndTracked for " + interceptor.getClass().getName() + " : " + t.getMessage(), t);
                }
            }
            finally {
                if (InterceptorTimer.ENABLED && interceptor != null) {
                    InterceptorTimer.onEndEnd(interceptor.getTransformationId());
                }
            }
        }
    }

    final void runInterceptor(CallType callType, AMethodInterceptor interceptor, MethodExecutionEnvironment env) {
        InterceptorInvocationWrapper interceptorWrapper = this.tlInterceptorWrapper.get();
        if (interceptorWrapper == null) {
            interceptorWrapper = new InterceptorInvocationWrapper();
            this.tlInterceptorWrapper.set(interceptorWrapper);
        }
        interceptorWrapper.setArgs(callType, interceptor, env, this);
        AccessController.doPrivileged(interceptorWrapper);
        interceptorWrapper.clear();
    }

    private static final class InterceptorInvocationWrapper
    implements PrivilegedAction<Object> {
        private CallType callType;
        private AMethodInterceptor interceptor;
        private MethodExecutionEnvironment env;
        private MethodInterceptorDelegatorImpl mid;

        InterceptorInvocationWrapper() {
        }

        void setArgs(CallType callType, AMethodInterceptor interceptor, MethodExecutionEnvironment env, MethodInterceptorDelegatorImpl mid) {
            this.callType = callType;
            this.interceptor = interceptor;
            this.env = env;
            this.mid = mid;
        }

        void clear() {
            this.interceptor = null;
            this.env = null;
            this.mid = null;
        }

        @Override
        public Object run() {
            long startTimeInNanos = 0L;
            long startCPUTimeInNanos = 0L;
            IInterceptorMeasurer interceptorMeasurer = BaseMethodInterceptorDelegatorImpl.interceptorMeasurer;
            if (interceptorMeasurer != null && interceptorMeasurer.isSlowInterceptorMeasurementStarted(this.env, this.interceptor)) {
                startTimeInNanos = interceptorMeasurer.getStartTimeInNanos();
                startCPUTimeInNanos = interceptorMeasurer.getStartCPUTimeInNanos();
            }
            switch (this.callType) {
                case METHOD_BEGIN: {
                    this.interceptor.onMethodBegin(this.env);
                    if (startTimeInNanos == 0L) break;
                    interceptorMeasurer.onSlowInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, this.env, this.interceptor, CallType.METHOD_BEGIN);
                    break;
                }
                case METHOD_END: {
                    this.interceptor.onMethodEnd(this.env);
                    if (startTimeInNanos == 0L) break;
                    interceptorMeasurer.onSlowInterceptorCallComplete(startTimeInNanos, startCPUTimeInNanos, this.env, this.interceptor, CallType.METHOD_END);
                    break;
                }
                case SAFE_ON_METHOD_BEGIN: {
                    this.mid.invokeOnBegin(this.env, this.interceptor);
                    break;
                }
                case SAFE_ON_METHOD_END: {
                    this.mid.invokeOnEnd(this.env, this.interceptor);
                }
            }
            return null;
        }
    }

    public static enum CallType {
        METHOD_BEGIN,
        METHOD_END,
        SAFE_ON_METHOD_BEGIN,
        SAFE_ON_METHOD_END;

    }
}

