/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.classloader;

import com.singularity.ee.agent.appagent.AgentEntryPoint;
import com.singularity.ee.agent.appagent.IAgentClassLoader;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IAgentBootLogger;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.SysOutAgentBootLogger;
import com.singularity.ee.agent.appagent.kernel.classloader.Post17AgentClassLoader;
import com.singularity.ee.agent.appagent.kernel.classloader.Post19AgentClassLoader;
import com.singularity.ee.agent.appagent.kernel.classloader.Pre17AgentClassLoader;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.agent.util.classloader.BootStrapClassLoaderProxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class AgentClassLoader
extends URLClassLoader
implements IAgentClassLoader {
    private static final String CONCURRENT_CLASS_LOADING_PROPERTY = "appdynamics.agent.concurrent.class.loading";
    protected static IAgentBootLogger logger = new SysOutAgentBootLogger();
    private static final String[] CLASS_PREFIXES_TO_PRELOAD = new String[]{"com.singularity.ee.agent.appagent.kernel.", "com.singularity.ee.agent.appagent.services.bciengine.", "com.singularity.ee.agent.commonservices.metricgeneration", "com.singularity.ee.agent.util.", "com.singularity.ee.util.", "com.singularity.org.objectweb.asm."};
    private static String JAVA_AGENT_JAR_FILE_NAME = "javaagent.jar";
    public static final String TEMPLATE_QUALIFIER = "com.singularity.ee.agent.appagent.services.bciengine.templates";
    private volatile boolean preLoadInProgress;
    private Map<String, Class<?>> mapOfPreLoadedClasses;
    private final Lock lock;
    private volatile Method findBootstrapClassMethod;
    private volatile Method getBootstrapResourceMethod;
    private volatile boolean findBootstrapClassMethodMissing;
    private volatile ClassLoader bootClassLoader;
    private volatile boolean errorGettingBootClassLoader;
    private volatile boolean errorGettingBootstrapResourceMethod;
    private volatile Method jrockitFindBootstrapClassMethod;
    private volatile boolean jrockitFindBootstrapClassMethodMissing;
    private final String agentInstallDir;
    private Set<String> adBootstrapClassNames;
    private static String[] delegateDirectToParentClassExprs;
    private final Map<String, GeneratedClass> generatedClasses;
    private final ConcurrentHashMap<String, Class<?>> dynamicallyDefinedInterfaces;
    protected volatile Method defineClassMethod;
    protected volatile Method findLoadedClassMethod;
    private static final Class<?> DUMMY_CLASS;
    private volatile boolean preMainTestFailed;
    private static final String SHOULD_TEST_FOR_CLASS_LOADS_IN_TRANSFORM = "appdynamics.test.for.class.loads.in.transform";
    private volatile boolean testForClassLoadsInTransform;
    private final ThreadLocal<Integer> transformActiveOnThread = new ThreadLocal();
    private final BootStrapClassLoaderProxy bootStrapClassLoaderProxy;
    private static final String AGENT_LOG_CLASSLOADING_PROPERTY = "appdynamics.log.classloading";
    private static final String AGENT_DELEGATE_PARENT_LOADER_PROPERTY = "appdynamics.delegate.parent.classes";
    private static final boolean shouldLogClassLoading;
    private static List<String> classLoadingLogBuffer;

    protected static Method getRegistrationMethod() {
        Method registerMethod = null;
        String value = System.getProperty(CONCURRENT_CLASS_LOADING_PROPERTY);
        if (!"false".equals(value)) {
            try {
                registerMethod = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerMethod.setAccessible(true);
                Object object = registerMethod.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("Failure: " + nsme);
            }
            catch (Throwable tt) {
                tt.printStackTrace();
            }
        }
        return registerMethod;
    }

    protected AgentClassLoader(URL[] urls, ClassLoader parent, String agentInstallDir) {
        super(urls, parent != null ? parent : AgentClassLoader.determineParentForAgentClassLoader());
        this.agentInstallDir = agentInstallDir;
        this.lock = new ReentrantLock();
        this.generatedClasses = new ConcurrentHashMap<String, GeneratedClass>();
        this.dynamicallyDefinedInterfaces = new ConcurrentHashMap();
        this.testForClassLoadsInTransform = this.determineTestForClassLoadsInTransform();
        this.bootStrapClassLoaderProxy = BootStrapClassLoaderProxy.getInstance();
        String delegateClassProperty = System.getProperty(AGENT_DELEGATE_PARENT_LOADER_PROPERTY);
        if (delegateClassProperty != null) {
            String[] expressions = delegateClassProperty.split(",");
            AgentClassLoader.setDelegateDirectToParentClassExprs(expressions);
        }
    }

    private static ClassLoader determineParentForAgentClassLoader() {
        ClassLoader returnClassLoader = ClassLoader.getSystemClassLoader().getParent();
        if (returnClassLoader != null) {
            while (returnClassLoader.getParent() != null) {
                returnClassLoader = returnClassLoader.getParent();
            }
        }
        return returnClassLoader;
    }

    protected AgentClassLoader(URL[] urls, String agentInstallDir) {
        super(urls, (ClassLoader)null);
        this.agentInstallDir = agentInstallDir;
        this.lock = new ReentrantLock();
        this.generatedClasses = new ConcurrentHashMap<String, GeneratedClass>();
        this.dynamicallyDefinedInterfaces = new ConcurrentHashMap();
        this.testForClassLoadsInTransform = this.determineTestForClassLoadsInTransform();
        this.bootStrapClassLoaderProxy = BootStrapClassLoaderProxy.getInstance();
    }

    private boolean determineTestForClassLoadsInTransform() {
        boolean bReturn = true;
        String testForClassLoadsInTransformProp = System.getProperty(SHOULD_TEST_FOR_CLASS_LOADS_IN_TRANSFORM);
        if (testForClassLoadsInTransformProp != null) {
            bReturn = Boolean.parseBoolean(testForClassLoadsInTransformProp);
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> returnObject = null;
        if (this.testForClassLoadsInTransform && this.testForTransformInCurrentThread()) {
            logger.warn("Attempt to load class " + className + " during transform");
            throw new ClassNotFoundException(String.format("Unable to load class %s because transform() is active", className));
        }
        if (!this.preLoadInProgress && this.mapOfPreLoadedClasses != null) {
            returnObject = this.loadClassSpecial(className, resolve);
        }
        if (returnObject == null && ((returnObject = this.dynamicallyDefinedInterfaces.get(className.replace('.', '/'))) == null || returnObject == DUMMY_CLASS)) {
            boolean lockGrabbed = this.acquireLockIfNotSynchronized();
            try {
                returnObject = this.loadClassParentLast(className, resolve);
            }
            finally {
                this.releaseLockIfAcquired(lockGrabbed);
            }
        }
        return returnObject;
    }

    private Class<?> loadClassSpecial(String className, boolean resolve) throws ClassNotFoundException {
        boolean isBootClass;
        Class<?> returnObject = null;
        boolean bl = isBootClass = this.adBootstrapClassNames != null && this.adBootstrapClassNames.contains(className);
        if (!isBootClass) {
            if (className.startsWith("com.singularity")) {
                returnObject = this.mapOfPreLoadedClasses.get(className);
            }
        } else {
            returnObject = this.findBootstrapClassWithReflection(className);
        }
        if (returnObject != null && resolve) {
            this.resolveClass(returnObject);
        }
        return returnObject;
    }

    protected abstract Class<?> loadClassParentLast(String var1, boolean var2) throws ClassNotFoundException;

    protected Class<?> loadClassInternal(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> returnClass;
        block11: {
            returnClass = null;
            returnClass = this.findLoadedClass(className);
            if (returnClass == null) {
                if (className.startsWith("java.") && this.getParent() == null) {
                    returnClass = this.delegateLoadToParent(className);
                } else {
                    if (AgentClassLoader.shouldDelegateDirectlyToParent(className)) {
                        try {
                            returnClass = this.delegateLoadToParent(className);
                        }
                        catch (ClassNotFoundException e) {
                            returnClass = this.findClass(className);
                            if (shouldLogClassLoading && returnClass != null && !className.startsWith("java.")) {
                                this.logClassLoading("CLASS LOADING: Loading agent loader class " + returnClass.getName() + " from AGENT Class Loader");
                            }
                            break block11;
                        }
                    }
                    try {
                        returnClass = this.findClass(className);
                        if (shouldLogClassLoading && returnClass != null && !className.startsWith("java.")) {
                            this.logClassLoading("CLASS LOADING: Loading agent loader class " + returnClass.getName() + " from AGENT Class Loader");
                        }
                    }
                    catch (ClassNotFoundException e) {
                        returnClass = this.tryDelegateGeneratedOrParentLoader(className, e);
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(returnClass);
        }
        return returnClass;
    }

    private Class<?> tryDelegateGeneratedOrParentLoader(String className, ClassNotFoundException e) throws ClassNotFoundException {
        try {
            Class<?> returnClass = this.findGeneratedClass(className);
            if (returnClass == null) {
                returnClass = this.delegateLoadToParent(className);
            }
            return returnClass;
        }
        catch (ClassNotFoundException e1) {
            throw e;
        }
    }

    private Class<?> delegateLoadToParent(String className) throws ClassNotFoundException {
        Class<?> loadedClass = null;
        loadedClass = this.getParent() != null ? this.getParent().loadClass(className) : this.findBootstrapClassWithReflection(className);
        if (shouldLogClassLoading && loadedClass != null && !className.startsWith("java.")) {
            this.logClassLoading("CLASS LOADING: Loading parent or bootstrap class " + loadedClass.getName() + " from class loader " + loadedClass.getClassLoader());
        }
        return loadedClass;
    }

    public Class<?> findBootstrapClassWithReflection(String className) throws ClassNotFoundException {
        return this.bootStrapClassLoaderProxy.findBootstrapClassWithReflection(className);
    }

    private final ClassLoader setBootClassLoaderObject() {
        if (this.bootClassLoader == null && !this.errorGettingBootClassLoader) {
            String[] bootClassLoaderFieldNames;
            for (String fieldName : bootClassLoaderFieldNames = this.getIBMBootClassLoaderFieldNames()) {
                try {
                    Field systemClassLoaderField = ClassLoader.class.getDeclaredField(fieldName);
                    systemClassLoaderField.setAccessible(true);
                    this.bootClassLoader = (ClassLoader)systemClassLoaderField.get(null);
                    break;
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getCause();
                    }
                    if (e instanceof NoSuchFieldException) continue;
                    logger.warn("Exception caught : " + e.toString() + " trying to locate bootstrap ClassLoader object using field name " + fieldName, e);
                    break;
                }
            }
        }
        if (this.bootClassLoader == null) {
            logger.warn("Unable to locate IBM Boot ClassLoader");
            this.errorGettingBootClassLoader = true;
        }
        return this.bootClassLoader;
    }

    protected abstract String[] getIBMBootClassLoaderFieldNames();

    public InputStream getBootstrapResource(String resourceName) throws Throwable {
        InputStream returnIS = null;
        if (this.getBootstrapResourceMethod == null && !this.errorGettingBootstrapResourceMethod) {
            try {
                this.getBootstrapResourceMethod = ClassLoader.class.getDeclaredMethod("getBootstrapResource", String.class);
                this.getBootstrapResourceMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                this.errorGettingBootstrapResourceMethod = true;
                this.setBootClassLoaderObject();
            }
        }
        if (this.getBootstrapResourceMethod != null) {
            URL url = (URL)this.getBootstrapResourceMethod.invoke(null, resourceName);
            if (url != null) {
                returnIS = url.openStream();
            }
        } else if (this.bootClassLoader != null) {
            returnIS = this.bootClassLoader.getResourceAsStream(resourceName);
        }
        return returnIS;
    }

    public boolean tryToLock() {
        return this.lock.tryLock();
    }

    public void releaseLock() {
        this.lock.unlock();
    }

    public static AgentClassLoader getAgentClassLoader(final URL[] urls, final ClassLoader parent, final String agentInstallDir) {
        AgentClassLoader returnObject = AccessController.doPrivileged(new PrivilegedAction<AgentClassLoader>(){

            @Override
            public AgentClassLoader run() {
                AgentClassLoader returnObject = null;
                if (JavaVersionUtil.isJava9orHigher()) {
                    returnObject = new Post19AgentClassLoader(urls, parent, agentInstallDir);
                }
                if (returnObject == null) {
                    returnObject = JavaVersionUtil.isJava7orHigher() ? new Post17AgentClassLoader(urls, parent, agentInstallDir) : new Pre17AgentClassLoader(urls, parent, agentInstallDir);
                }
                return returnObject;
            }
        });
        return returnObject;
    }

    public static AgentClassLoader getAgentClassLoader(URL[] urls, String agentInstallDir) {
        AgentClassLoader returnObject = null;
        String version = System.getProperty("java.version");
        returnObject = JavaVersionUtil.isJava7orHigher() ? new Post17AgentClassLoader(urls, agentInstallDir) : new Pre17AgentClassLoader(urls, agentInstallDir);
        return returnObject;
    }

    protected boolean acquireLockIfNotSynchronized() {
        boolean bReturn = false;
        if (!Thread.holdsLock(this)) {
            this.lock.lock();
            bReturn = true;
        }
        return bReturn;
    }

    protected void releaseLockIfAcquired(boolean lockAcquired) {
        if (lockAcquired) {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preLoadAgentClasses() {
        this.preLoadInProgress = true;
        try {
            URL[] classPath = this.getURLs();
            this.mapOfPreLoadedClasses = new HashMap();
            for (URL nextURL : classPath) {
                try {
                    this.defineClassesFromURL(nextURL);
                }
                catch (Exception e) {
                    logger.warn("Exception caught : " + e.toString() + " trying to preload agent classes from " + nextURL, (Throwable)e);
                }
            }
            this.getADBootstrapClassNames();
        }
        finally {
            this.preLoadInProgress = false;
        }
    }

    private final void defineClassesFromURL(URL url) throws IOException, URISyntaxException {
        File nextClassPathFile = new File(url.toURI());
        if (nextClassPathFile.getName().endsWith(".jar") || nextClassPathFile.getName().endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(nextClassPathFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getName().startsWith("com/singularity/ee/agent/util/log4j")) continue;
                this.defineClassFromZipEntry(zipEntry, zipFile, url);
            }
            zipFile.close();
        }
    }

    private final void defineClassFromZipEntry(ZipEntry zipEntry, ZipFile zipFile, URL url) {
        try {
            this.defineClassFromZipEntry(zipFile, zipEntry, url);
        }
        catch (Exception e) {
            logger.warn(String.format("Caught %s attempting to define class \"%s\"", e.toString(), zipEntry.getName()));
        }
    }

    private final void defineClassFromZipEntry(ZipFile zipFile, ZipEntry zipEntry, URL url) throws IOException {
        String className = AgentClassLoader.getClassNameFromZipEntry(zipEntry);
        if (className != null) {
            if (className.contains(TEMPLATE_QUALIFIER)) {
                return;
            }
            boolean preload = false;
            if (this.findLoadedClass(className) == null) {
                for (String nextClassPrefix : CLASS_PREFIXES_TO_PRELOAD) {
                    if (!className.startsWith(nextClassPrefix)) continue;
                    preload = true;
                    break;
                }
                if (preload && this.mapOfPreLoadedClasses.get(className) == null) {
                    byte[] classFileImage = AgentClassLoader.getBytes(zipEntry, zipFile);
                    try {
                        Class<?> clazz = this.defineClass(className, classFileImage, 0, classFileImage.length, new CodeSource(url, (Certificate[])null));
                        this.mapOfPreLoadedClasses.put(className, clazz);
                    }
                    catch (Exception e) {
                        logger.warn("Exception caught : " + e.toString() + " in defineClassFromZipEntry() trying to define class " + className, (Throwable)e);
                    }
                }
            }
        }
    }

    private static final String getClassNameFromZipEntry(ZipEntry zipEntry) {
        String zipEntryName = zipEntry.getName();
        if (zipEntryName.endsWith(".class")) {
            return zipEntryName.substring(0, zipEntryName.length() - 6).replace('/', '.');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        byte[] returnArray = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            byte[] nextBuf;
            int numRead;
            int numLeft;
            InputStream is = zipFile.getInputStream(zipEntry);
            bis = new BufferedInputStream(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(baos);
            while ((numLeft = bis.available()) != 0 && (numRead = bis.read(nextBuf = new byte[numLeft])) >= 0) {
                ((BufferedOutputStream)bos).write(nextBuf, 0, numRead);
            }
            bos.close();
            bos = null;
            returnArray = baos.toByteArray();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return returnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getADBootstrapClassNames() {
        File installDirFile;
        if (this.agentInstallDir != null && (installDirFile = new File(this.agentInstallDir)).exists() && installDirFile.isDirectory()) {
            File javaAgentJar;
            String javaAgentName = null;
            try {
                javaAgentName = AgentEntryPoint.getJavaAgentName();
            }
            catch (Throwable t) {
                logger.warn("Exception caught : " + t.toString() + " trying to determine name of javaagent jar file", t);
            }
            if (javaAgentName == null) {
                javaAgentName = JAVA_AGENT_JAR_FILE_NAME;
            }
            if ((javaAgentJar = new File(installDirFile, javaAgentName)).exists() && !javaAgentJar.isDirectory()) {
                this.adBootstrapClassNames = new HashSet<String>();
                ZipFile zipFile = null;
                try {
                    try {
                        zipFile = new ZipFile(javaAgentJar);
                        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                        while (zipEntries.hasMoreElements()) {
                            ZipEntry zipEntry = zipEntries.nextElement();
                            String className = AgentClassLoader.getClassNameFromZipEntry(zipEntry);
                            if (className == null) continue;
                            this.adBootstrapClassNames.add(className);
                        }
                    }
                    finally {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                }
                catch (IOException e) {
                    logger.warn("Exception caught : " + e.toString() + " in getADBootstrapClassNames()", (Throwable)e);
                    e.printStackTrace(System.err);
                }
            }
        }
        if (this.adBootstrapClassNames == null) {
            logger.warn("Unable to determine the names of AD Agent boot classes because " + JAVA_AGENT_JAR_FILE_NAME + " could not be located");
        }
    }

    public void setLogger(IAgentBootLogger newLogger) {
        logger = newLogger;
    }

    private void logClassLoading(String msg) {
        if (this.isInPreMain()) {
            if (classLoadingLogBuffer != null) {
                classLoadingLogBuffer.add(msg);
            }
        } else {
            if (classLoadingLogBuffer != null) {
                for (String cmsg : classLoadingLogBuffer) {
                    logger.info((Object)cmsg);
                }
                classLoadingLogBuffer = null;
            }
            logger.info((Object)msg);
        }
    }

    public static void setDelegateDirectToParentClassExprs(String[] delegateDirectToParentClassExprs) {
        if (AgentClassLoader.delegateDirectToParentClassExprs != null) {
            String[] newDelegateDirectToParentClassExprs = Arrays.copyOf(AgentClassLoader.delegateDirectToParentClassExprs, AgentClassLoader.delegateDirectToParentClassExprs.length + delegateDirectToParentClassExprs.length);
            System.arraycopy(delegateDirectToParentClassExprs, 0, newDelegateDirectToParentClassExprs, AgentClassLoader.delegateDirectToParentClassExprs.length, delegateDirectToParentClassExprs.length);
            AgentClassLoader.delegateDirectToParentClassExprs = newDelegateDirectToParentClassExprs;
        } else {
            AgentClassLoader.delegateDirectToParentClassExprs = delegateDirectToParentClassExprs;
        }
    }

    private static boolean shouldDelegateDirectlyToParent(String className) {
        boolean bReturn = false;
        if (delegateDirectToParentClassExprs != null) {
            for (String nextClassExpr : delegateDirectToParentClassExprs) {
                if (!className.matches(nextClassExpr)) continue;
                bReturn = true;
                break;
            }
        }
        return bReturn;
    }

    public void defineGeneratedClass(String className, byte[] classBytes, ProtectionDomain protectionDomain) {
        this.generatedClasses.put(className.replace('/', '.'), new GeneratedClass(classBytes, protectionDomain));
    }

    private Class<?> findGeneratedClass(String className) {
        Class<?> returnClass = null;
        GeneratedClass generatedClass = this.generatedClasses.remove(className.replace('/', '.'));
        if (generatedClass != null) {
            returnClass = this.defineClass(className, generatedClass.getClassBytes(), 0, generatedClass.getClassBytes().length, generatedClass.getProtectionDomain());
        }
        if (shouldLogClassLoading && returnClass != null && !className.startsWith("java.")) {
            this.logClassLoading("CLASS LOADING: Loading Generated class " + returnClass.getName() + " from class loader " + returnClass.getClassLoader());
        }
        return returnClass;
    }

    public void addURLToClassPath(URL url) {
        this.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> defineImplementedInterface(String interfaceName) {
        Class clazz = null;
        interfaceName = interfaceName.replace('.', '/');
        if (this.getParent() == null || this.dynamicallyDefinedInterfaces.putIfAbsent(interfaceName, DUMMY_CLASS) != null) {
            return null;
        }
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this);
        try {
            InputStream is = this.getResourceAsStream(interfaceName + ".class");
            if (is != null) {
                byte[] classBytes = this.convertToByteArray(is);
                if (this.defineClassMethod == null) {
                    this.defineClassMethod = this.getDefineClassMethod();
                }
                if (this.findLoadedClassMethod == null) {
                    this.findLoadedClassMethod = this.getFindLoadedClassMethod();
                }
                String loadedInterfaceClassName = interfaceName.replace('/', '.');
                clazz = (Class)this.findLoadedClassMethod.invoke((Object)this.getParent(), loadedInterfaceClassName);
                if (clazz == null) {
                    clazz = (Class)this.defineClassMethod.invoke((Object)this.getParent(), loadedInterfaceClassName, classBytes, 0, classBytes.length, null);
                }
                this.resolveClass(clazz);
                this.dynamicallyDefinedInterfaces.put(interfaceName, clazz);
            }
        }
        catch (Throwable t) {
            logger.warn(String.format("Unable to define interface %s to parent ClassLoader because of %s", interfaceName, t), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] convertToByteArray(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int numRemaining;
            while ((numRemaining = bis.available()) > 0) {
                byte[] buffer = new byte[numRemaining];
                int numRead = bis.read(buffer);
                if (numRead < 0) {
                    break;
                }
                baos.write(buffer, 0, numRead);
            }
        }
        finally {
            bis.close();
            baos.close();
        }
        byte[] returnBytes = baos.toByteArray();
        return returnBytes;
    }

    protected Method getDefineClassMethod() throws NoSuchMethodException {
        Class<SecureClassLoader> classLoaderClass = SecureClassLoader.class;
        Method defineClassMethod = classLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, CodeSource.class);
        defineClassMethod.setAccessible(true);
        return defineClassMethod;
    }

    protected Method getFindLoadedClassMethod() throws NoSuchMethodException {
        Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        findLoadedClassMethod.setAccessible(true);
        return findLoadedClassMethod;
    }

    public ClassLoader getClassLoaderDynamicallyDefinedIn(String interfaceName) {
        ClassLoader returnClassLoader = null;
        Class<?> clazz = this.dynamicallyDefinedInterfaces.get(interfaceName.replace('.', '/'));
        if (clazz != null && clazz != DUMMY_CLASS) {
            returnClassLoader = clazz.getClassLoader();
        }
        return returnClassLoader;
    }

    private boolean testForTransformInCurrentThread() {
        Integer transformOnCurrentThread;
        boolean bReturn = false;
        if (!this.isInPreMain() && (transformOnCurrentThread = this.transformActiveOnThread.get()) != null) {
            bReturn = transformOnCurrentThread > 0;
        }
        return bReturn;
    }

    public void setTransformOnCurrentThread(boolean transformOnCurrentThread) {
        Integer numTransformOnCurrentThread = this.transformActiveOnThread.get();
        if (numTransformOnCurrentThread == null) {
            if (transformOnCurrentThread) {
                this.transformActiveOnThread.set(1);
            }
        } else if (transformOnCurrentThread) {
            this.transformActiveOnThread.set(numTransformOnCurrentThread + 1);
        } else {
            this.transformActiveOnThread.set(numTransformOnCurrentThread - 1);
        }
    }

    private boolean isInPreMain() {
        boolean inPreMain = false;
        if (!this.preMainTestFailed) {
            try {
                inPreMain = AgentEntryPoint.isInPreMain();
            }
            catch (Throwable t) {
                this.preMainTestFailed = true;
                t.printStackTrace(System.err);
            }
        }
        return inPreMain;
    }

    public boolean isTestForClassLoadsInTransform() {
        return this.testForClassLoadsInTransform;
    }

    public void setTestForClassLoadsInTransform(boolean testForClassLoadsInTransform) {
        this.testForClassLoadsInTransform = testForClassLoadsInTransform;
    }

    public String getAgentVersion(Class<?> clazz) throws IOException {
        return null;
    }

    static {
        DUMMY_CLASS = AgentClassLoader.class;
        shouldLogClassLoading = Boolean.getBoolean(AGENT_LOG_CLASSLOADING_PROPERTY);
        classLoadingLogBuffer = shouldLogClassLoading ? new ArrayList() : null;
    }

    private static class GeneratedClass {
        private byte[] classBytes;
        private ProtectionDomain protectionDomain;

        GeneratedClass(byte[] classBytes, ProtectionDomain protectionDomain) {
            this.classBytes = classBytes;
            this.protectionDomain = protectionDomain;
        }

        byte[] getClassBytes() {
            return this.classBytes;
        }

        ProtectionDomain getProtectionDomain() {
            return this.protectionDomain;
        }
    }
}

