/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.classloader;

import com.singularity.ee.agent.appagent.java9.Java9PermissionObtainer;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ReflectionException;

public abstract class AgentClassLoaderReflector {
    private static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.AgentClassLoaderReflector");

    public static boolean defineImplementedInterface(String interfaceName, Java9PermissionObtainer java9PermissionObtainer) {
        ClassLoader agentClassLoader = AgentClassLoaderReflector.class.getClassLoader();
        boolean OK = false;
        try {
            Class clazz;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("defineImplementedInterface called for \"%s\"", interfaceName));
            }
            boolean bl = OK = (clazz = (Class)AgentReflectionUtility.invokeMethod(agentClassLoader, "defineImplementedInterface", new Class[]{String.class}, new Object[]{interfaceName})) != null;
            if (OK) {
                if (JavaVersionUtil.isJava9orHigher()) {
                    AgentClassLoaderReflector.giveCallerAccessToNewModule(clazz, java9PermissionObtainer);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Interface \"%s\" has been defined", interfaceName));
                }
            }
        }
        catch (ReflectionException e) {
            logger.error(String.format("Caught %s trying dynamically define implemented interface %s", new Object[]{e, interfaceName}), e);
        }
        return OK;
    }

    public static ClassLoader getClassLoaderDynamicallyDefinedIn(String interfaceName) {
        ClassLoader agentClassLoader = AgentClassLoaderReflector.class.getClassLoader();
        ClassLoader classLoaderDefinedIn = null;
        try {
            classLoaderDefinedIn = (ClassLoader)AgentReflectionUtility.invokeMethod(agentClassLoader, "getClassLoaderDynamicallyDefinedIn", new Class[]{String.class}, new Object[]{interfaceName});
        }
        catch (ReflectionException e) {
            logger.error(String.format("Caught %s trying dynamically define implemented interface %s", new Object[]{e, interfaceName}), e);
        }
        return classLoaderDefinedIn;
    }

    private static void giveCallerAccessToNewModule(Class<?> newClass, Java9PermissionObtainer java9PermissionObtainer) {
        java9PermissionObtainer.getAccessToClass(newClass, true, logger);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Current module has been given access to module containing class %s", newClass.getName()));
        }
    }
}

