/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.classloader;

import com.singularity.ee.agent.appagent.kernel.classloader.AgentClassLoader;
import java.lang.reflect.Method;
import java.net.URL;

public class Post17AgentClassLoader
extends AgentClassLoader {
    private static final String[] BOOT_CLASSLOADER_FIELD_NAMES = new String[]{"bootstrapClassLoader"};
    private Method getClassLoadingLockMethod;

    Post17AgentClassLoader(URL[] urls, ClassLoader parent, String agentInstallDir) {
        super(urls, parent, agentInstallDir);
    }

    Post17AgentClassLoader(URL[] urls, String agentInstallDir) {
        super(urls, agentInstallDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClassParentLast(String className, boolean resolve) throws ClassNotFoundException {
        Object classLoadingLock;
        Class<?> returnClass = null;
        Object object = classLoadingLock = this.adGetClassLoadingLock(className);
        synchronized (object) {
            returnClass = this.loadClassInternal(className, resolve);
        }
        return returnClass;
    }

    Object adGetClassLoadingLock(String className) throws ClassNotFoundException {
        Object returnObject = null;
        try {
            if (this.getClassLoadingLockMethod == null) {
                Method newGetClassLoadingLockMethod = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
                newGetClassLoadingLockMethod.setAccessible(true);
                this.getClassLoadingLockMethod = newGetClassLoadingLockMethod;
            }
            returnObject = this.getClassLoadingLockMethod.invoke((Object)this, className);
        }
        catch (Throwable t) {
            logger.warn("Exception caught : " + t.toString() + " attempting to obtain class loading lock for class " + className, t);
            throw new ClassNotFoundException("Cannot load class " + className + " because unable to obtain class loading lock", t);
        }
        return returnObject;
    }

    @Override
    protected String[] getIBMBootClassLoaderFieldNames() {
        return BOOT_CLASSLOADER_FIELD_NAMES;
    }

    static {
        Method method = Post17AgentClassLoader.getRegistrationMethod();
        if (method != null) {
            try {
                Object object = method.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

