/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.classloader;

import com.singularity.ee.agent.appagent.kernel.classloader.AgentClassLoader;
import com.singularity.ee.agent.appagent.kernel.classloader.Post17AgentClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Post19AgentClassLoader
extends Post17AgentClassLoader {
    Post19AgentClassLoader(URL[] urls, ClassLoader parent, String agentInstallDir) {
        super(urls, parent, agentInstallDir);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz;
        try {
            byte[] classBytes;
            InputStream is = this.getResourceFromClassPath(name.replace('.', '/') + ".class");
            if (is != null) {
                classBytes = this.convertToByteArray(is);
                if (this.defineClassMethod == null) {
                    this.defineClassMethod = this.getDefineClassMethod();
                }
            } else {
                throw new ClassNotFoundException(String.format("Unable to load class %s", name));
            }
            clazz = (Class)this.defineClassMethod.invoke((Object)this, name, classBytes, 0, classBytes.length, AgentClassLoader.class.getProtectionDomain().getCodeSource());
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception t) {
            throw new ClassNotFoundException(String.format("Unable to load class %s because of %s", name, t.toString()), t);
        }
        return clazz;
    }

    private InputStream getResourceFromClassPath(String resourceName) {
        InputStream returnObject = null;
        try {
            URL url = this.findResource(resourceName);
            if (url != null) {
                returnObject = url.openStream();
            }
        }
        catch (Exception t) {
            logger.warn(String.format("Unable to find class %s due to %s", resourceName, t.toString()), (Throwable)t);
        }
        return returnObject;
    }

    @Override
    public String getAgentVersion(Class<?> clazz) {
        URL[] urls;
        String returnVersion = null;
        for (URL url : urls = this.getURLs()) {
            try {
                String path = URLDecoder.decode(url.getPath(), "UTF-8");
                if (!url.getProtocol().equals("file")) continue;
                try {
                    File file = new File(path);
                    returnVersion = Post19AgentClassLoader.getVersionFromManifest(file, clazz);
                }
                catch (IOException e) {
                    logger.warn("Error opening " + url + ": " + e);
                    continue;
                }
                if (returnVersion == null) continue;
                break;
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("File path encoding error while opening " + url + ": " + e);
            }
        }
        return returnVersion;
    }

    private static String getVersionFromManifest(File file, Class<?> clazz) throws IOException {
        Attributes mainAttributes;
        String resourceName;
        String returnVersion = null;
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && jarFile.getEntry(resourceName = clazz.getName().replace(".", "/") + ".class") != null && (mainAttributes = manifest.getMainAttributes()) != null) {
            returnVersion = mainAttributes.getValue("Implementation-Version");
        }
        return returnVersion;
    }

    static {
        Method method = Post19AgentClassLoader.getRegistrationMethod();
        if (method != null) {
            try {
                Object object = method.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

