/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.agentdiagnostics.memory;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public class ADConcurrentHashMapTracker
implements IAgentRunnable {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.diagnostics.ADConcurrentHashMapTracker");
    public static int SCHEDULE_INTERVAL_SEC = 60;
    public static boolean DEFAULT_ENABLED = true;
    private int lastNMaps;
    private int lastAverageMapEntries;
    private int lastTotalEntries;
    private double nMapDelta;

    public void run() {
        this.reset();
        ConcurrentHashMap instanceTracker = ADConcurrentHashMap.getInstanceTracker();
        int currentSize = instanceTracker.size();
        this.nMapDelta = (double)(currentSize - this.lastNMaps) / (double)SCHEDULE_INTERVAL_SEC;
        this.lastNMaps = currentSize;
        for (WeakReference weakToProcess : instanceTracker.keySet()) {
            ADConcurrentHashMap toProcess = (ADConcurrentHashMap)weakToProcess.get();
            if (toProcess == null) continue;
            this.lastTotalEntries += toProcess.size();
            this.lastAverageMapEntries = this.lastTotalEntries / instanceTracker.size();
        }
        this.logStatistics();
    }

    private void reset() {
        this.lastNMaps = 0;
        this.lastTotalEntries = 0;
        this.lastAverageMapEntries = 0;
    }

    public int getLastNMaps() {
        return this.lastNMaps;
    }

    public int getLastAverageMapEntries() {
        return this.lastAverageMapEntries;
    }

    public int getLastTotalEntries() {
        return this.lastTotalEntries;
    }

    public double getnMapDelta() {
        return this.nMapDelta;
    }

    private void logStatistics() {
        logger.info("***** ADConcurrentHashMapTracker Stats *****");
        logger.info("Total number of maps: " + this.lastNMaps);
        logger.info("Total number of entries: " + this.lastTotalEntries);
        logger.info("Average number of entries in each map: " + this.lastAverageMapEntries);
    }
}

