/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.agentdiagnostics.memory;

import com.singularity.ee.agent.appagent.kernel.spi.IAgentServiceContext;
import com.singularity.ee.agent.appagent.kernel.spi.IServiceContext;
import com.singularity.ee.agent.appagent.kernel.spi.IServicePropertyListener;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.memory.ADConcurrentHashMapTracker;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.memory.MemoryTrackerClassInterceptor;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.memory.MemoryTrackerMethodInterceptor;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.memory.SizeReporter;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.spi.AgentDiagnosticConfig;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.rule.bci.ClassRuleApplier;
import com.singularity.ee.agent.util.rule.bci.MethodRuleApplier;
import com.singularity.ee.agent.util.rule.reflect.FieldReflector;
import com.singularity.ee.agent.util.rule.reflect.IFieldListener;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.memory.IMemoryCalculator;
import com.singularity.ee.util.memory.MemoryCalculatorFactory;
import com.singularity.ee.util.memory.calc.ObjectLogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.string.StringOperations;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;

public class MemoryMonitor
implements IServicePropertyListener,
IFieldListener {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.diagnostics.MemoryMonitor");
    private static final String MEMORY_METRIC_PREFIX = "Object Size|";
    private static final String MEMORY_METRICS_SUFFIX = " (MB)";
    private static final int MAX_OBJECTS_TO_TRACK = 25;
    private static final int DEFAULT_INTERVAL_MINS = 10;
    private static AtomicInteger totalObjectsTracked = new AtomicInteger(0);
    private static Map<Object, String> classObjectsToTrack = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.Option.IDENTITY_COMPARISONS);
    private static Map<Object, String> methodObjectsToTrack = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.Option.IDENTITY_COMPARISONS);
    private Map<Object, String> fieldObjectsToTrack = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.Option.IDENTITY_COMPARISONS);
    private static Set<String> monitorClassNames = new HashSet<String>();
    private static Set<String> objectNamesToLog = new HashSet<String>();
    private IServiceContext serviceContext;
    private Map<String, String> diagServiceProps;
    private ClassRuleApplier classRuleApplier;
    private MethodRuleApplier methodRuleApplier;
    private FieldReflector fieldReflector;
    private SizeReporter sizeReporter;
    private ADConcurrentHashMapTracker concurrentHashMapTracker;
    private volatile boolean concurrentHashMapTrackerEnabled = ADConcurrentHashMapTracker.DEFAULT_ENABLED;
    private IAgentScheduledFuture concurrentHashMapTrackerFuture;
    private MemoryCalculatorFactory factory;
    private IMemoryCalculator calculator;

    public MemoryMonitor(IServiceContext serviceContext, Map<String, String> diagServiceProps) {
        this.serviceContext = serviceContext;
        this.diagServiceProps = diagServiceProps;
        IBCIEngineService bciEngine = (IBCIEngineService)serviceContext.getService(IBCIEngineService.class);
        this.classRuleApplier = new ClassRuleApplier(bciEngine, MemoryTrackerClassInterceptor.class);
        this.methodRuleApplier = new MethodRuleApplier(bciEngine, MemoryTrackerMethodInterceptor.class);
        this.fieldReflector = new FieldReflector(bciEngine, serviceContext.getAgentScheduler(), this);
        this.fieldReflector.setFieldNames(diagServiceProps.get("memory-monitor-static-fields"));
        IADLogger iLogger = ADLoggerFactory.getLogger("com.singularity.MemoryCalculator");
        ObjectLogger objectLogger = new ObjectLogger(iLogger, serviceContext.getKernel().getLogsDir());
        this.factory = new MemoryCalculatorFactory(((IAgentServiceContext)serviceContext).getInstrumentation(), iLogger, MemoryCalculatorFactory.CalculatorType.ADVANCED);
        this.calculator = this.factory.getCalculator();
        AgentDiagnosticConfig.setMemoryMonitorEnabled(Boolean.parseBoolean(diagServiceProps.get("memory-monitoring-enable")));
        AgentDiagnosticConfig.setMemoryCalculatorType(diagServiceProps.get("memory-calculator"));
        this.setMaxDepth(diagServiceProps.get("memory-monitor-max-depth"));
        this.setMaxObjects(diagServiceProps.get("memory-monitor-total-objects"));
        this.calculator.setSummaryLogger(objectLogger);
        this.calculator.setContentLogger(objectLogger);
        this.sizeReporter = new SizeReporter(serviceContext, classObjectsToTrack, methodObjectsToTrack, this.fieldObjectsToTrack, objectNamesToLog, this.factory);
        this.concurrentHashMapTracker = new ADConcurrentHashMapTracker();
        this.parseClassNames(diagServiceProps.get("memory-monitor-class-filter"));
        String[] props = new String[]{"memory-monitoring-enable", "memory-monitoring-interval-in-minutes", "memory-monitor-max-depth", "memory-monitor-total-objects", "memory-monitor-methods", "memory-monitor-static-fields", "memory-monitor-class-filter", "memory-monitor-classes", "memory-monitor-enable-object-logging", "memory-monitor-objects-to-log", "memory-monitor-enable-object-content-logging", "memory-calculator", "agent-track-ad-concurrent-hash-maps"};
        serviceContext.getKernel().getConfigManager().registerConfigPropertyChangeListener("AgentDiagnosticsService", props, (IServicePropertyListener)this);
        serviceContext.getAgentScheduler().scheduleAtFixedRate(new IAgentRunnable(){

            public void run() {
                totalObjectsTracked.set(classObjectsToTrack.size() + methodObjectsToTrack.size() + MemoryMonitor.this.fieldObjectsToTrack.size());
            }
        }, 60L, 60L, AgentTimeUnit.SECONDS);
    }

    public void start() {
        this.setupSizeReporter();
        this.setupMethodsToMonitor(this.diagServiceProps.get("memory-monitor-methods"));
        this.setupClassesToMonitor(this.diagServiceProps.get("memory-monitor-classes"));
        this.setObjectNamesToLog(this.diagServiceProps.get("memory-monitor-objects-to-log"));
        logger.info("Memory Monitor started with enabled[" + AgentDiagnosticConfig.isMemoryMonitorEnabled() + "], interval[" + AgentDiagnosticConfig.getMemoryMonitorInterval() + "]");
    }

    private void parseClassNames(String clsNames) {
        HashSet<String> set = new HashSet<String>();
        if (!StringOperations.isEmpty((String)clsNames)) {
            StringTokenizer st = new StringTokenizer(clsNames, ",");
            while (st.hasMoreTokens()) {
                String clsName = st.nextToken().trim();
                if (StringOperations.isEmpty((String)clsName)) continue;
                set.add(clsName);
            }
        }
        monitorClassNames.clear();
        monitorClassNames.addAll(set);
        methodObjectsToTrack.clear();
        logger.info("Updated monitor class names " + monitorClassNames + ". Removed all tracked method objects.");
    }

    private void setObjectNamesToLog(String objectNames) {
        HashSet<String> set = new HashSet<String>();
        if (!StringOperations.isEmpty((String)objectNames)) {
            StringTokenizer st = new StringTokenizer(objectNames, ",");
            while (st.hasMoreTokens()) {
                String objectName = st.nextToken().trim();
                if (StringOperations.isEmpty((String)objectName)) continue;
                set.add(MemoryMonitor.createMetricName(objectName));
            }
        }
        objectNamesToLog.clear();
        objectNamesToLog.addAll(set);
        logger.info("Updated object names to log " + objectNamesToLog);
    }

    private void setMaxDepth(String val) {
        int depth = StringOperations.safeParseInteger((String)val, (int)500000);
        AgentDiagnosticConfig.setMemoryMonitorMaxDepth(depth);
        this.calculator.setMaxStackDepth(depth);
    }

    private void setMaxObjects(String val) {
        int maxObjects = StringOperations.safeParseInteger((String)val, (int)500000);
        AgentDiagnosticConfig.setMemoryMonitorTotalObjects(maxObjects);
        this.calculator.setMaxObjectsToVisit(maxObjects);
    }

    private void setupClassesToMonitor(String clsNameStr) {
        try {
            logger.info("BCI Rules to apply for Classes[" + clsNameStr + "]");
            if (classObjectsToTrack.size() > 0) {
                logger.info("Clearing all current objects from classes being tracked " + classObjectsToTrack);
                totalObjectsTracked.getAndAdd(classObjectsToTrack.size() * -1);
                classObjectsToTrack.clear();
            }
            this.classRuleApplier.applyRules(clsNameStr);
        }
        catch (Exception e) {
            logger.warn("Error in applying Memory Tracking interceptors", e);
        }
    }

    public static void addObjectToMonitorFromClasses(Object obj) {
        if (classObjectsToTrack.get(obj) == null && totalObjectsTracked.get() < 25) {
            logger.info("Added objects to track from class interceptor [" + obj.getClass().getName() + "#" + System.identityHashCode(obj) + "]");
            classObjectsToTrack.put(obj, MemoryMonitor.createMetricName(obj.getClass().getSimpleName()));
            totalObjectsTracked.incrementAndGet();
        }
    }

    private void setupMethodsToMonitor(String clsNameStr) {
        try {
            logger.info("BCI Rules to apply for Methods[" + clsNameStr + "]");
            this.methodRuleApplier.applyRules(clsNameStr);
            logger.info("Clearing all current objects from methods being tracked " + methodObjectsToTrack);
            totalObjectsTracked.getAndAdd(methodObjectsToTrack.size() * -1);
            methodObjectsToTrack.clear();
        }
        catch (Exception e) {
            logger.warn("Error in applying Memory Tracking interceptors", e);
        }
    }

    public static void addObjectToMonitorFromMethods(Object obj) {
        if (methodObjectsToTrack.get(obj) == null && (monitorClassNames.size() == 0 || monitorClassNames.contains(obj.getClass().getName())) && totalObjectsTracked.get() < 25) {
            logger.info("Added objects to track from method interceptor [" + obj.getClass().getName() + "#" + System.identityHashCode(obj) + "]");
            methodObjectsToTrack.put(obj, MemoryMonitor.createMetricName(obj.getClass().getSimpleName()));
            totalObjectsTracked.incrementAndGet();
        }
    }

    private void setupFieldsToMonitor(String fldNameStr) {
        try {
            logger.info("Applying new fields " + fldNameStr);
            logger.info("Clearing all current objects from fields being tracked " + methodObjectsToTrack);
            totalObjectsTracked.getAndAdd(this.fieldObjectsToTrack.size() * -1);
            this.fieldObjectsToTrack.clear();
            this.fieldReflector.setFieldNames(fldNameStr);
        }
        catch (Exception e) {
            logger.info("Error in applying field names to monitor", e);
        }
    }

    @Override
    public void setFieldValue(Object obj, String cls, String fld) {
        if (this.fieldObjectsToTrack.get(obj) == null && totalObjectsTracked.get() < 25) {
            logger.info("Added objects to track from fields [" + cls + "#" + fld + "#" + System.identityHashCode(obj) + "]");
            StringBuilder metricName = new StringBuilder();
            metricName.append(cls.substring(cls.lastIndexOf(46) + 1, cls.length())).append('.').append(fld);
            this.fieldObjectsToTrack.put(obj, MemoryMonitor.createMetricName(metricName.toString()));
            totalObjectsTracked.incrementAndGet();
        }
    }

    private static String createMetricName(String name) {
        StringBuilder metricName = new StringBuilder(MEMORY_METRIC_PREFIX);
        metricName.append(name).append(MEMORY_METRICS_SUFFIX);
        return metricName.toString();
    }

    private void setupSizeReporter() {
        AgentDiagnosticConfig.setMemoryMonitorInterval(StringOperations.safeParseInteger((String)this.diagServiceProps.get("memory-monitoring-interval-in-minutes"), (int)10));
        this.serviceContext.getAgentScheduler().scheduleWithFixedDelay(this.sizeReporter, 60L, 60L, AgentTimeUnit.SECONDS);
    }

    private void setupConcurrentHashMapTracker() {
        this.concurrentHashMapTrackerFuture = this.serviceContext.getAgentScheduler().scheduleWithFixedDelay(this.concurrentHashMapTracker, ADConcurrentHashMapTracker.SCHEDULE_INTERVAL_SEC, ADConcurrentHashMapTracker.SCHEDULE_INTERVAL_SEC, AgentTimeUnit.SECONDS);
    }

    private void setCalculatorType(String newPropertyValue) {
        if (!StringOperations.isEmpty((String)newPropertyValue)) {
            try {
                MemoryCalculatorFactory.CalculatorType type = MemoryCalculatorFactory.CalculatorType.valueOf(newPropertyValue.trim());
                AgentDiagnosticConfig.setMemoryCalculatorType(newPropertyValue);
                this.factory.setCalculatorType(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void servicePropertyChanged(String serviceName, String propertyName, String newPropertyValue) {
        logger.info("Updating config for " + serviceName + " prop=" + propertyName + ", val=" + newPropertyValue);
        if (propertyName.equals("memory-monitoring-enable")) {
            AgentDiagnosticConfig.setMemoryMonitorEnabled(Boolean.parseBoolean(newPropertyValue));
        } else if (propertyName.equals("memory-monitoring-interval-in-minutes")) {
            AgentDiagnosticConfig.setMemoryMonitorInterval(StringOperations.safeParseInteger((String)newPropertyValue, (int)10));
        } else if (propertyName.equals("memory-monitor-classes")) {
            this.setupClassesToMonitor(newPropertyValue);
        } else if (propertyName.equals("memory-monitor-methods")) {
            this.setupMethodsToMonitor(newPropertyValue);
        } else if (propertyName.equals("memory-monitor-static-fields")) {
            this.setupFieldsToMonitor(newPropertyValue);
        } else if (propertyName.equals("memory-monitor-max-depth")) {
            this.setMaxDepth(newPropertyValue);
        } else if (propertyName.equals("memory-monitor-class-filter")) {
            this.parseClassNames(newPropertyValue);
        } else if (propertyName.equals("memory-calculator")) {
            this.setCalculatorType(newPropertyValue);
        } else if (propertyName.equals("memory-monitor-total-objects")) {
            this.setMaxObjects(newPropertyValue);
        } else if (propertyName.equals("memory-monitor-objects-to-log")) {
            this.setObjectNamesToLog(newPropertyValue);
        } else if (propertyName.equals("memory-monitor-enable-object-logging")) {
            AgentDiagnosticConfig.setMemoryMonitorObjectLoggingEnabled(Boolean.parseBoolean(newPropertyValue));
            this.calculator.enableContentSummaryLogging(Boolean.parseBoolean(newPropertyValue));
        } else if (propertyName.equals("memory-monitor-enable-object-content-logging")) {
            AgentDiagnosticConfig.setMemoryMonitorObjectContentLoggingEnabled(Boolean.parseBoolean(newPropertyValue));
            this.calculator.enableObjectDumpLogging(Boolean.parseBoolean(newPropertyValue));
        } else if (propertyName.equals("agent-track-ad-concurrent-hash-maps")) {
            this.concurrentHashMapTrackerEnabled = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)ADConcurrentHashMapTracker.DEFAULT_ENABLED);
            if (this.concurrentHashMapTrackerEnabled) {
                this.setupConcurrentHashMapTracker();
            } else if (this.concurrentHashMapTrackerFuture != null) {
                this.concurrentHashMapTrackerFuture.cancel(false);
            }
        }
    }
}

