/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.agentdiagnostics.memory;

import com.appdynamics.apm.appagent.api.IMetricAndEventReporter;
import com.singularity.ee.agent.appagent.kernel.spi.IServiceContext;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.spi.AgentDiagnosticConfig;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.memory.IMemoryCalculator;
import com.singularity.ee.util.memory.MemoryCalculatorFactory;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class SizeReporter
implements IAgentRunnable {
    private static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.diagnostics.SizeReporter");
    private IServiceContext serviceContext;
    private int iteration;
    private Map<String, Long> objectSizeCache;
    private MemoryCalculatorFactory calcFactory;
    private Map<Object, String> classObjectsToTrack;
    private Map<Object, String> methodObjectsToTrack;
    private Map<Object, String> fieldObjectsToTrack;
    private Set<String> objectNamesToLog;
    private int factor = 1000000;

    public SizeReporter(IServiceContext serviceContext, Map<Object, String> methodObjectsToTrack, Map<Object, String> fieldObjectsToTrack, Map<Object, String> classObjectsToTrack, Set<String> objectNamesToLog, MemoryCalculatorFactory calcFactory) {
        this.serviceContext = serviceContext;
        this.classObjectsToTrack = classObjectsToTrack;
        this.methodObjectsToTrack = methodObjectsToTrack;
        this.fieldObjectsToTrack = fieldObjectsToTrack;
        this.objectNamesToLog = objectNamesToLog;
        this.calcFactory = calcFactory;
        this.iteration = 0;
        this.objectSizeCache = new HashMap<String, Long>();
    }

    public void run() {
        if (!AgentDiagnosticConfig.isMemoryMonitorEnabled() || this.methodObjectsToTrack.isEmpty() && this.fieldObjectsToTrack.isEmpty() && this.classObjectsToTrack.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not reporting metrics MemoryMonitor[" + AgentDiagnosticConfig.isMemoryMonitorEnabled() + "], objcts[" + this.methodObjectsToTrack.size() + "]");
            }
            return;
        }
        try {
            boolean reportCurrent;
            IMetricAndEventReporter reporter = this.serviceContext.getKernel().getLifeCycleManager().getMetricAndEventPublisher();
            boolean bl = reportCurrent = this.iteration % AgentDiagnosticConfig.getMemoryMonitorInterval() == 0;
            if (reportCurrent) {
                this.iteration = 0;
            }
            IdentityHashMap<Object, String> objectsToReport = new IdentityHashMap<Object, String>();
            objectsToReport.putAll(this.classObjectsToTrack);
            objectsToReport.putAll(this.methodObjectsToTrack);
            objectsToReport.putAll(this.fieldObjectsToTrack);
            IMemoryCalculator calculator = this.calcFactory.getCalculator();
            for (Object obj : objectsToReport.keySet()) {
                String metricName = (String)objectsToReport.get(obj);
                if (reportCurrent) {
                    this.reportCurrentMetric(reporter, calculator, obj, metricName);
                    continue;
                }
                this.reportlastMinuteMetric(reporter, metricName);
            }
            ++this.iteration;
        }
        catch (Throwable t) {
            logger.error("Error in reporting object size ", t);
        }
    }

    private void reportlastMinuteMetric(IMetricAndEventReporter reporter, String metricName) {
        Long size = this.objectSizeCache.get(metricName);
        if (size != null) {
            reporter.reportAverageMetric(metricName, size.longValue());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Reporting last minute metrics for " + metricName + ", size=" + size);
        }
    }

    private void reportCurrentMetric(IMetricAndEventReporter reporter, IMemoryCalculator calculator, Object obj, String metricName) {
        long startTime = System.currentTimeMillis();
        calculator.enableObjectDumpLogging(this.objectNamesToLog.contains(metricName));
        long memSizeInMB = calculator.deepSize(obj, metricName, -1L) / (long)this.factor;
        this.objectSizeCache.put(metricName, memSizeInMB);
        reporter.reportAverageMetric(metricName, memSizeInMB);
        if (logger.isDebugEnabled()) {
            logger.debug("For " + metricName + " reported size=" + memSizeInMB + " MB, time taken to compute=" + (System.currentTimeMillis() - startTime));
        }
    }
}

