/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.agentdiagnostics.spi;

import com.singularity.ee.agent.appagent.kernel.boot.IJavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.boot.JavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.spi.IBootServiceProvider;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.spi.IAgentErrorHandler;
import com.singularity.ee.agent.util.log4j.IAgentLogger;
import com.singularity.ee.agent.util.reflect.ReflectionUtility;

public abstract class ErrorHandlerFactory {
    private static final String AGENT_ERROR_HANDLER_CLASS_NAME = "com.singularity.ee.agent.appagent.services.agentdiagnostics.safety.AgentErrorHandler";
    private static final IJavaAgentBootExtension javaAgentBootExtension = JavaAgentBootExtension.getInstance();

    public static IAgentErrorHandler createAgentErrorHandler(IAgentLogger agentLogger) throws Exception {
        IBootServiceProvider bootServiceProvider;
        IAgentErrorHandler returnObject = null;
        if (javaAgentBootExtension != null && (bootServiceProvider = javaAgentBootExtension.getBootServiceProvider()) != null) {
            returnObject = bootServiceProvider.createAgentErrorHandler(agentLogger);
        }
        if (returnObject == null) {
            returnObject = ErrorHandlerFactory.createAgentErrorHandlerUsingReflection(agentLogger);
        }
        return returnObject;
    }

    private static IAgentErrorHandler createAgentErrorHandlerUsingReflection(IAgentLogger agentLogger) throws Exception {
        IAgentErrorHandler errorHandler = null;
        ClassLoader thisClassLoader = ErrorHandlerFactory.class.getClassLoader();
        if (thisClassLoader != null) {
            Class<?> agentErrorHandlerClass = thisClassLoader.loadClass(AGENT_ERROR_HANDLER_CLASS_NAME);
            errorHandler = (IAgentErrorHandler)ReflectionUtility.newInstance(agentErrorHandlerClass, new Class[]{IAgentLogger.class}, agentLogger);
        }
        return errorHandler;
    }
}

