/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.ReTransformTask;
import com.singularity.ee.agent.appagent.services.bciengine.RuntimeExcludeManager;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassContainer;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassTransformationCallback;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IAgentEventDataHandler;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IClassTransformation;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.ALLRuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import dagger.Lazy;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AClassTransformation
implements IClassTransformation {
    protected static final int MAX_NUMBER_OF_NO_TRANSFORM_MESSAGES = 10;
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.AClassTransformation");
    private boolean active;
    protected ReTransformTask reTransformWorker;
    private Instrumentation instrumentation;
    protected Lazy<IBCIEngineService> bciEngineRef;
    protected volatile int numNoTransformMessagesIssued;
    protected final IAgentEventDataHandler agentEventHandler;
    protected final IMemoryLimitCheck memoryLimitCheck;

    protected AClassTransformation(Instrumentation instrumentation, Lazy<IBCIEngineService> bciEngineRef, IAgentEventDataHandler agentEventHandler, IMemoryLimitCheck memoryLimitCheck, IAgentSchedulerManager schedulerManager) {
        this.instrumentation = instrumentation;
        this.bciEngineRef = bciEngineRef;
        this.agentEventHandler = agentEventHandler;
        this.memoryLimitCheck = memoryLimitCheck;
        this.reTransformWorker = new ReTransformTask(schedulerManager.getAgentGlobalScheduler(), bciEngineRef, this);
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return this.instrumentation.isRedefineClassesSupported();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    @Override
    public abstract void registerForRetransform(ClassFileTransformer var1);

    abstract void actualRetransform(ClassContainer[] var1) throws UnableToRetransformException;

    protected abstract void actualRetransform(ClassTransformationCallback var1, Class[] var2) throws UnableToRetransformException;

    @Override
    public void pingForRetransform() {
        this.reTransformWorker.ping();
    }

    @Override
    public void retransformClass(ClassTransformationCallback callback, Class<?> ... classes) throws UnableToRetransformException {
        HashSet<Class> clazzForRetransform = new HashSet<Class>();
        for (Class<?> clazz : classes) {
            Class targetClass = AClassTransformation.classToRetransform(clazz);
            if (targetClass == null) continue;
            clazzForRetransform.add(targetClass);
        }
        this._retransformClass(callback, false, clazzForRetransform.toArray(new Class[clazzForRetransform.size()]));
    }

    @Override
    public void retransformClass(ClassTransformationCallback callback, String ... classNameArr) throws UnableToRetransformException {
        if (!this.active) {
            return;
        }
        HashSet<String> className = new HashSet<String>();
        for (int i = classNameArr.length - 1; i >= 0; --i) {
            className.add(classNameArr[i]);
        }
        Class[] allClasses = this.instrumentation.getAllLoadedClasses();
        HashSet<Class> clazzForRetransform = new HashSet<Class>();
        for (Class clazz : allClasses) {
            Class targetClass;
            if (!className.contains(clazz.getName()) || (targetClass = AClassTransformation.classToRetransform(clazz)) == null) continue;
            clazzForRetransform.add(targetClass);
        }
        this._retransformClass(callback, false, clazzForRetransform.toArray(new Class[clazzForRetransform.size()]));
    }

    @Override
    public void retransformClassesForRule(ClassTransformationCallback callback, Set<AClassTransformationRule> addedRules, Set<AClassTransformationRule> removedRules, boolean reTransformInPremain) throws UnableToRetransformException {
        if (!this.active) {
            return;
        }
        if (addedRules.isEmpty() && removedRules.isEmpty()) {
            return;
        }
        try {
            Class[] allClasses;
            HashSet<Class> clazzForRetransform = new HashSet<Class>();
            for (Class clazz : allClasses = this.instrumentation.getAllLoadedClasses()) {
                ArrayList<AClassTransformationRule> listOfNewRulesForThisClass = null;
                ArrayList<AClassTransformationRule> listOfDeletedRulesForThisClass = null;
                String className = clazz.getName().replace('.', '/');
                ClassLoader loader = clazz.getClassLoader();
                if (((IBCIEngineService)this.bciEngineRef.get()).geTransformationRuleEngine().excludeFromProcessing(className, loader)) continue;
                for (AClassTransformationRule rule : addedRules) {
                    if (!this.isMatching(clazz, loader, rule)) continue;
                    if (listOfNewRulesForThisClass == null) {
                        listOfNewRulesForThisClass = new ArrayList<AClassTransformationRule>();
                    }
                    listOfNewRulesForThisClass.add(rule);
                }
                for (AClassTransformationRule rule : removedRules) {
                    if (rule.isTrackingMatches()) {
                        if (!rule.getModifiedClassNames().contains(className)) continue;
                        if (listOfDeletedRulesForThisClass == null) {
                            listOfDeletedRulesForThisClass = new ArrayList<AClassTransformationRule>();
                        }
                        listOfDeletedRulesForThisClass.add(rule);
                        continue;
                    }
                    if (!this.isMatching(clazz, loader, rule)) continue;
                    if (listOfDeletedRulesForThisClass == null) {
                        listOfDeletedRulesForThisClass = new ArrayList();
                    }
                    listOfDeletedRulesForThisClass.add(rule);
                }
                if (listOfNewRulesForThisClass == null && listOfDeletedRulesForThisClass == null) continue;
                if (!this.isEquivalentMatchingRulesForClass(clazz, listOfNewRulesForThisClass, listOfDeletedRulesForThisClass)) {
                    Class targetClass = AClassTransformation.classToRetransform(clazz);
                    if (targetClass == null) continue;
                    if (!this.isModifiableClass(targetClass)) {
                        logger.info(targetClass + " not modifiable, skipping for retransform.");
                        continue;
                    }
                    clazzForRetransform.add(targetClass);
                    this.logRetransformMatches(targetClass, listOfNewRulesForThisClass, listOfDeletedRulesForThisClass);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace(String.format("Retransformation for class %s is suppressed because new matching rules are equivalent to removed rules", clazz.getName()));
            }
            if (clazzForRetransform.size() > 0) {
                this._retransformClass(callback, reTransformInPremain, clazzForRetransform.toArray(new Class[clazzForRetransform.size()]));
            }
        }
        catch (UnableToRetransformException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.warn("Error in class re-transformation for rule set " + addedRules, e);
        }
    }

    private void _retransformClass(ClassTransformationCallback callback, boolean reTransformInPremain, Class<?> ... classes) throws UnableToRetransformException {
        if (logger.isDebugEnabled()) {
            logger.debug("retransformClass for called for " + this.getClass().getSimpleName());
        }
        if (!this.isActive() || classes.length == 0) {
            return;
        }
        HashSet bypassedClasses = new HashSet();
        classes = this.filterClassesForRetransformation(bypassedClasses, classes);
        this.testOKToRetransform(classes.length);
        if (classes.length > 0) {
            this._retransformFilteredClasses(callback, reTransformInPremain, classes);
        }
        if (bypassedClasses.size() > 0) {
            this._retransformFilteredOutClasses(callback, reTransformInPremain, bypassedClasses);
        }
    }

    private void _retransformFilteredClasses(ClassTransformationCallback callback, boolean reTransformInPremain, Class<?> ... classes) throws UnableToRetransformException {
        if (((IBCIEngineService)this.bciEngineRef.get()).isEnableBatchRetransformation()) {
            logger.debug("Re-transforming classes in batches.");
            this.reTransformWorker.addClassesToReTransform(callback, classes);
            if (reTransformInPremain) {
                logger.debugParams("Re-transformation for following classes will happen after all services start: {}", Arrays.toString(classes));
            } else {
                this.reTransformWorker.ping();
            }
        } else {
            logger.debug("Re-transforming the list of classes all together.");
            this.actualRetransform(callback, classes);
            logger.debugParams("Re-transformed classes {}", Arrays.toString(classes));
        }
    }

    private void _retransformFilteredOutClasses(ClassTransformationCallback callback, boolean reTransformInPremain, Collection<Class<?>> filteredOutClasses) throws UnableToRetransformException {
        if (((IBCIEngineService)this.bciEngineRef.get()).isEnableBatchRetransformation()) {
            Object[] classArray = filteredOutClasses.toArray(new Class[filteredOutClasses.size()]);
            logger.debug("Re-transforming classes individually within ReTransformTask.");
            this.reTransformWorker.addClassesToReTransformIndividually(callback, (Class<?>[])classArray);
            if (reTransformInPremain) {
                logger.debugParams("Re-transformation for following classes will happen after all services start: {}", Arrays.toString(classArray));
            } else {
                this.reTransformWorker.ping();
            }
        } else {
            logger.debug("Re-transforming the list of classes individually.");
            for (Class<?> clazz : filteredOutClasses) {
                try {
                    this.actualRetransform(callback, new Class[]{clazz});
                }
                catch (UnableToRetransformException e) {
                    throw e;
                }
                catch (Throwable t) {
                    logger.error(String.format("Caught \"%s\" trying to retransform %s", t.toString(), clazz.getName()), t);
                }
            }
            logger.debugParams("Re-transformed classes [{}]", filteredOutClasses);
        }
    }

    private boolean isMatching(Class clazz, ClassLoader loader, AClassTransformationRule rule) {
        try {
            ClassMethodFilter classMethodFilter = rule.getFilter();
            if (!(classMethodFilter.getRuntimeClassFilter() instanceof ALLRuntimeClassFilter)) {
                BasicClassInfo basicInfo = new BasicClassInfo(loader, clazz.getName().replace('.', '/'));
                IBCIEngineService bciEngine = (IBCIEngineService)this.bciEngineRef.get();
                RuntimeClassInfo runtimeInfo = new RuntimeClassInfo(clazz, bciEngine.isClassLookAheadEnabledForClass(clazz.getName()), bciEngine.isSafeToCallHasAnnotation(clazz), bciEngine.getClassMetaDataManager());
                if (classMethodFilter.getBasicClassFilter().matchClass(basicInfo) && classMethodFilter.getRuntimeClassFilter().matchClass(basicInfo, runtimeInfo)) {
                    return true;
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Error while matching class " + clazz + " against rule " + rule, t);
        }
        return false;
    }

    protected final void sendAgentEvent(String eventSubType, String message) {
        HashMap<String, String> envDetails = new HashMap<String, String>();
        envDetails.put("VM_INFO", SystemInfo.getVMInfo());
        envDetails.put("OS_INFO", SystemInfo.getMachineInfo());
        this.agentEventHandler.onInfoAgentEvent(eventSubType, envDetails, message, true);
    }

    protected abstract boolean isModifiableClass(Class<?> var1);

    protected Class<?>[] filterClassesForRetransformation(Collection<Class<?>> bypassedClasses, Class<?> ... classes) {
        ArrayList listOfClasses = new ArrayList(classes.length);
        for (Class<?> clazz : classes) {
            IBCIEngineService.RetransformSupressionStatus retransformSupressionStatus = ((IBCIEngineService)this.bciEngineRef.get()).shouldSuppressClassRetransform(clazz);
            if (retransformSupressionStatus == IBCIEngineService.RetransformSupressionStatus.DO_NOT_SUPPRESS) {
                listOfClasses.add(clazz);
                continue;
            }
            if (retransformSupressionStatus == IBCIEngineService.RetransformSupressionStatus.SUPPRESS_APPD_CLASS && bypassedClasses != null) {
                bypassedClasses.add(clazz);
                logger.info(String.format("Class \"%s\" cannot be retransformed in batch - will attempt individually", clazz.getName()));
                continue;
            }
            String message = String.format("Cannot retransform class \"%s\" because it is loaded from a \"done\" Glassfish ClassLoader or the class was excluded from retransformation (check bci-retransformation-excludes section in app-agent-config.xml)", clazz.getName());
            if (this.numNoTransformMessagesIssued++ < 10) {
                logger.info(message);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(message);
                continue;
            }
            if (this.numNoTransformMessagesIssued != 10) continue;
            logger.info("No more unable to transform class messages will be issued");
        }
        classes = listOfClasses.toArray(new Class[listOfClasses.size()]);
        return classes;
    }

    private boolean isEquivalentMatchingRulesForClass(Class<?> clazz, List<AClassTransformationRule> newRuleList, List<AClassTransformationRule> deletedRuleList) {
        boolean bReturn = false;
        if (newRuleList != null && deletedRuleList != null && newRuleList.size() == deletedRuleList.size()) {
            ArrayList<AClassTransformationRule> copyNewRuleList = new ArrayList<AClassTransformationRule>(newRuleList);
            ArrayList<AClassTransformationRule> copyDeletedRuleList = new ArrayList<AClassTransformationRule>(deletedRuleList);
            ArrayList<AClassTransformationRule[]> listOfRulesToReplace = new ArrayList<AClassTransformationRule[]>(copyNewRuleList.size());
            Iterator newRuleIter = copyNewRuleList.iterator();
            block0: while (newRuleIter.hasNext()) {
                AClassTransformationRule newTR = (AClassTransformationRule)newRuleIter.next();
                Iterator deletedRuleIter = copyDeletedRuleList.iterator();
                while (deletedRuleIter.hasNext()) {
                    AClassTransformationRule deletedTR = (AClassTransformationRule)deletedRuleIter.next();
                    if (!newTR.isEquivalentTo(deletedTR)) continue;
                    newRuleIter.remove();
                    deletedRuleIter.remove();
                    listOfRulesToReplace.add(new AClassTransformationRule[]{deletedTR, newTR});
                    continue block0;
                }
            }
            if (copyNewRuleList.size() == 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Substituting new TransformationRules for old ones on behalf of class %s", clazz.getName()));
                }
                ((IBCIEngineService)this.bciEngineRef.get()).replaceTransformationRules(clazz, listOfRulesToReplace);
                bReturn = true;
            }
        }
        return bReturn;
    }

    static Class classToRetransform(Class clazz) {
        Class<?> result = clazz;
        if (RuntimeExcludeManager.isLambdaClass(clazz)) {
            String name = clazz.getName();
            int k = name.indexOf("$$Lambda$");
            try {
                Class<?> enclosingClass;
                result = enclosingClass = Class.forName(name.substring(0, k), false, clazz.getClassLoader());
                logger.info("The agent will retransform  " + result.getName() + " to (re- or un-)instrument " + clazz.getName());
            }
            catch (Exception ex) {
                logger.warn("Failed to find enclosing class for lambda class " + clazz.getName(), ex);
                return null;
            }
        }
        if (RuntimeExcludeManager.excludeClass(result)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Class " + result.getName() + " excluded by RuntimeExcludeManager");
            }
            return null;
        }
        return result;
    }

    private void logRetransformMatches(Class<?> clazz, List<AClassTransformationRule> listOfNewRules, List<AClassTransformationRule> listOfDeletedRules) {
        if (listOfNewRules != null) {
            for (AClassTransformationRule rule : listOfNewRules) {
                if (rule.isTrackingMatches()) continue;
                logger.info("Re-transforming class [" + clazz.getName() + "] because its classname matches an active rule [" + rule + "]");
            }
        }
        if (listOfDeletedRules != null) {
            for (AClassTransformationRule rule : listOfDeletedRules) {
                if (rule.isTrackingMatches()) continue;
                logger.info("Re-transforming class [" + clazz.getName() + "] because its classname matches deleted rule [" + rule + "]");
            }
        }
    }

    protected void testOKToRetransform(int numClassesToRetransform) throws UnableToRetransformException {
        if (!this.memoryLimitCheck.isMemoryAvailableForRetransform()) {
            IBCIEngineInfoProvider infoProvider = ((IBCIEngineService)this.bciEngineRef.get()).getInfoProvider();
            if (infoProvider != null) {
                infoProvider.incrementFailedRetransformRequest(1);
            }
            throw new UnableToRetransformException(String.format("Not enough Memory for retransformation.  %d classes cannot be retransformed", numClassesToRetransform), this.agentEventHandler, this.memoryLimitCheck);
        }
    }
}

