/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.ClassLoaderNoLongerExistsException;
import com.singularity.ee.agent.appagent.services.bciengine.ClassToRetransform;
import com.singularity.ee.agent.appagent.services.bciengine.DeferredClassInstrumenter;
import com.singularity.ee.agent.appagent.services.bciengine.DeferredClassRetransformer;
import com.singularity.ee.agent.appagent.services.bciengine.NoOpBootClassRetransformer;
import com.singularity.ee.agent.appagent.services.bciengine.RuntimeExcludeManager;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;
import com.singularity.ee.agent.util.AgentSystemInfo;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ADeferredClassRetransformer<T> {
    protected static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ADeferredClassRetransformer");
    private static Boolean preferToRetransform;
    protected final Instrumentation instrumentation;
    private final IMemoryLimitCheck memoryLimitCheck;

    protected ADeferredClassRetransformer(Instrumentation instrumentation, IMemoryLimitCheck memoryLimitCheck) {
        this.instrumentation = instrumentation;
        this.memoryLimitCheck = memoryLimitCheck;
    }

    public Collection<ClassToRetransform> transformDeferredClasses(Collection<ClassToRetransform> classes) {
        Collection<ClassToRetransform> unprocessed = new ArrayList<ClassToRetransform>();
        ArrayList approvedClasses = new ArrayList();
        Map<ClassToRetransform, Class<?>> allClassMap = null;
        for (ClassToRetransform candidateClass : classes) {
            try {
                Class<?> clazz;
                String className = candidateClass.getClassName();
                ClassLoader loader = candidateClass.getClassLoader();
                if (allClassMap == null) {
                    allClassMap = this.getMapOfAllClasses();
                }
                if ((clazz = ADeferredClassRetransformer.locateClass(candidateClass, allClassMap)) == null) {
                    logger.warn("Couldn't locate loaded class " + className + ", might try again later");
                    unprocessed.add(candidateClass);
                    continue;
                }
                if (this.isExcludedAtRuntime(clazz) || this.classInspected(clazz, loader, candidateClass.getClassBytes(), approvedClasses)) continue;
                unprocessed.add(candidateClass);
            }
            catch (ClassLoaderNoLongerExistsException classLoaderNoLongerExistsException) {}
        }
        if (approvedClasses.size() > 0) {
            if (this.memoryLimitCheck.isMemoryAvailableForRetransform()) {
                this.processApprovedClasses(approvedClasses, classes.size());
            } else {
                unprocessed = classes;
            }
        }
        if (unprocessed.size() > 0) {
            logger.info("Failed to instrument/redefine or transformDeferredClasses " + unprocessed.size() + " classes out of " + classes.size() + " deferred for BCI, might try later");
        }
        return unprocessed;
    }

    protected abstract boolean classInspected(Class var1, ClassLoader var2, byte[] var3, List<T> var4);

    protected abstract void processApprovedClasses(List<T> var1, int var2);

    public abstract boolean areClassBytesRequired();

    private Map<ClassToRetransform, Class<?>> getMapOfAllClasses() {
        Class[] allClassArray = this.instrumentation.getAllLoadedClasses();
        HashMap returnMap = new HashMap(allClassArray.length);
        for (Class nextClass : allClassArray) {
            returnMap.put(new ClassToRetransform(nextClass), nextClass);
        }
        return returnMap;
    }

    private static Class<?> locateClass(ClassToRetransform classToRetransform, Map<ClassToRetransform, Class<?>> allClassMap) {
        Class<?> returnClass = allClassMap.get(classToRetransform);
        return returnClass;
    }

    public static ADeferredClassRetransformer getBootClassTransformer(Instrumentation instrumentation, IBCIEngineService bciEngine, IMemoryLimitCheck memoryLimitCheck) {
        if (ADeferredClassRetransformer.shouldTryToRetransformClasses()) {
            if (bciEngine.isRetransformClassesSupported()) {
                return new DeferredClassRetransformer(instrumentation, memoryLimitCheck);
            }
            logger.warn("retransformClasses is not supported on this platform");
        }
        if (bciEngine.isRedefineClassesSupported()) {
            return new DeferredClassInstrumenter(instrumentation, bciEngine.getClassFileTransformer(), memoryLimitCheck);
        }
        logger.warn("The agent is unable to process deferred BCI");
        return new NoOpBootClassRetransformer(instrumentation, memoryLimitCheck);
    }

    private static boolean shouldTryToRetransformClasses() {
        if (preferToRetransform == null) {
            String defaultValue = AgentSystemInfo.isSoleAgent() ? "false" : "true";
            String value = System.getProperties().getProperty("appdynamics.agent.prefer.retransformClasses", defaultValue);
            preferToRetransform = Boolean.parseBoolean(value);
            logger.info("Preference to retransform classes = " + preferToRetransform);
        }
        return preferToRetransform;
    }

    private boolean isExcludedAtRuntime(Class clazz) {
        if (RuntimeExcludeManager.excludeClass(clazz)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Class " + clazz.getName() + " excluded by RuntimeExcludeManager");
            }
            return true;
        }
        return false;
    }
}

