/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.MethodExecutionEnvironment;
import com.singularity.ee.agent.appagent.kernel.boot.JavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.spi.IBootServiceProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AFastMethodInterceptor;
import com.singularity.ee.agent.appagent.services.transactionmonitor.common.boot.InterceptorExceptionLogging;
import com.singularity.ee.agent.appagent.services.transactionmonitor.spi.ICurrentTransactionContextBase;
import com.singularity.ee.agent.appagent.services.transactionmonitor.spi.ITransactionMonitorBase;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;

public abstract class AFastTrackedMethodInterceptor
extends AFastMethodInterceptor {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.AFastTrackedMethodInterceptor");
    public static final byte INTERCEPTOR_OWNS_CRC = 1;
    public static final byte INTERCEPTOR_OWNS_CTC = 2;
    public static final byte SERVICE_ENDPOINT_MARKER = 4;
    public static final byte TRANSIENT_BT_MARKER = 8;
    public static final byte LIVEMODE_BT_MARKER = 16;
    public static final byte DOTNET_INTERCEPTOR_OWNS_EUM = 32;
    private static IBootServiceProvider bootServiceProvider;
    protected static volatile ITransactionMonitorBase txMonitorBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object onMethodBegin(Object invokedObject, String className, String methodName, Object[] paramValues, int transformationId) {
        try {
            Object object = this.onMethodBeginTracked(invokedObject, className, methodName, paramValues, transformationId);
            return object;
        }
        catch (Exception t) {
            logger.error("Error in onBegin " + this.getName(), t);
            Object var7_8 = null;
            return var7_8;
        }
        finally {
            AFastTrackedMethodInterceptor.locateBootServiceProvider();
            bootServiceProvider.safeReportStatusToInterceptorStatusMediator(className, methodName, transformationId, ((Object)((Object)this)).getClass());
        }
    }

    public abstract Object onMethodBeginTracked(Object var1, String var2, String var3, Object[] var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onMethodEnd(Object state, Object invokedObject, String className, String methodName, Object[] paramValues, Throwable thrownException, Object returnValue, int transformationId) {
        try {
            this.onMethodEndTracked(state, invokedObject, className, methodName, paramValues, thrownException, returnValue, transformationId);
        }
        catch (Exception t) {
            logger.error("Error in onEnd " + this.getName(), t);
        }
        finally {
            AFastTrackedMethodInterceptor.locateBootServiceProvider();
            bootServiceProvider.safeReportStatusToInterceptorStatusMediator(className, methodName, transformationId, ((Object)((Object)this)).getClass());
        }
    }

    public abstract void onMethodEndTracked(Object var1, Object var2, String var3, String var4, Object[] var5, Throwable var6, Object var7, int var8);

    protected static ITransactionMonitorBase resolveTxMonitor() {
        if (txMonitorBase == null) {
            AFastTrackedMethodInterceptor.locateBootServiceProvider();
            if (bootServiceProvider != null) {
                txMonitorBase = bootServiceProvider.getTransactionMonitor();
            }
        }
        return txMonitorBase;
    }

    protected void logException(Object invokedObject, String className, String methodName, Object[] paramValues, boolean isDebug, ICurrentTransactionContextBase transactionContext, String onMethod, Throwable e, IADLogger logger) {
        boolean shouldLogAsError = InterceptorExceptionLogging.LogAtErrorLevel(e);
        if (shouldLogAsError || isDebug) {
            AFastTrackedMethodInterceptor.resolveTxMonitor();
            ICurrentTransactionContextBase currentTransactionContextBase = null;
            if (txMonitorBase != null) {
                currentTransactionContextBase = txMonitorBase.getCurrentTransactionBase();
            }
            String message = "Error in TEP : " + onMethod + " for : " + MethodExecutionEnvironment.toString((Object)invokedObject, (String)className, (String)methodName, (Object[])paramValues) + ", transactionContext local copy: " + transactionContext + ", transactionContext fetched from btContext " + (currentTransactionContextBase != null ? currentTransactionContextBase.toString() : "unknown");
            if (shouldLogAsError) {
                logger.error(message, e);
            } else {
                logger.debug(message, e);
            }
        }
    }

    private static IBootServiceProvider locateBootServiceProvider() {
        if (bootServiceProvider == null) {
            bootServiceProvider = JavaAgentBootExtension.getInstance().getBootServiceProvider();
        }
        return bootServiceProvider;
    }
}

