/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.AFastTrackedMethodInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.IRateLimitManager;
import com.singularity.ee.agent.util.log4j.IADLogger;

public abstract class AFastTrackedRateLimitMethodInterceptor
extends AFastTrackedMethodInterceptor {
    private static final Object RATE_LIMITED = new Object();
    protected final IRateLimitManager rateLimitManager;

    public AFastTrackedRateLimitMethodInterceptor(IRateLimitManager rateLimitManager) {
        this.rateLimitManager = rateLimitManager;
    }

    @Override
    public final Object onMethodBeginTracked(Object invokedObject, String className, String methodName, Object[] paramValues, int transformationId) {
        if (this.rateLimitManager.isRateLimited(transformationId)) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.getName() + " is rate limited for " + transformationId + " on method begin. So skipping.");
            }
            return RATE_LIMITED;
        }
        return this.onMethodBeginTrackedImpl(invokedObject, className, methodName, paramValues, transformationId);
    }

    public abstract Object onMethodBeginTrackedImpl(Object var1, String var2, String var3, Object[] var4, int var5);

    @Override
    public final void onMethodEndTracked(Object state, Object invokedObject, String className, String methodName, Object[] paramValues, Throwable thrownException, Object returnValue, int transformationId) {
        if (state == RATE_LIMITED) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.getName() + " is rate limited for " + transformationId + " on method end. So skipping.");
            }
            return;
        }
        this.onMethodEndTrackedImpl(state, invokedObject, className, methodName, paramValues, thrownException, returnValue, transformationId);
    }

    public abstract void onMethodEndTrackedImpl(Object var1, Object var2, String var3, String var4, Object[] var5, Throwable var6, Object var7, int var8);

    public abstract IADLogger getLogger();

    @Override
    public boolean shouldPassParamsToOnMethodBegin() {
        return true;
    }

    @Override
    public boolean shouldCallOnMethodEnd() {
        return true;
    }

    @Override
    public boolean shouldPassReturnValueToOnMethodEnd() {
        return true;
    }
}

