/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.IOpcodeToString;
import com.singularity.ee.agent.appagent.services.bciengine.jsp.JspConstants;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AOpcodeToString
implements JspConstants,
IOpcodeToString {
    private final Map<Integer, String> fieldCache = new ConcurrentHashMap<Integer, String>();

    @Override
    public String resolveOpcode(int opcode) {
        String cached = this.fieldCache.get(opcode);
        if (cached != null) {
            return cached;
        }
        Field[] fields = this.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                Object value = field.get(null);
                if (!(value instanceof Integer) || (Integer)value != opcode) continue;
                String name = field.getName() + "(" + opcode + ")";
                this.fieldCache.put(opcode, name);
                return name;
            }
            catch (IllegalAccessException e) {
                return "Error" + e.getMessage() + String.valueOf(opcode);
            }
        }
        return String.valueOf(opcode);
    }

    protected abstract Field[] getDeclaredFields();
}

