/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.BCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.IAbandonedClassBCIManager;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IAgentEventDataHandler;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.string.StringOperations;
import java.lang.instrument.IllegalClassFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AbandonedClassBCIManager
implements IAbandonedClassBCIManager {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.AbandonedClassBCIManager");
    private static final int MAX_ATTEMPTS = 5;
    private final BCIEngineService bciEngine;
    private final BlockingQueue<AbandonedClassQueueElement> queueOfAbandonedClasses;
    private final IAgentScheduledExecutorService scheduler;
    private final IAgentEventDataHandler agentEventHandler;
    private IAgentScheduledFuture future;
    private static long SCHEDULE_FUTURE_IN_SECONDS = 300L;

    public static void resetSchedule(long newSchedule) {
        SCHEDULE_FUTURE_IN_SECONDS = newSchedule;
    }

    AbandonedClassBCIManager(BCIEngineService bciEngine, IAgentScheduledExecutorService scheduler, IAgentEventDataHandler agentEventHandler) {
        this.bciEngine = bciEngine;
        this.scheduler = scheduler;
        this.agentEventHandler = agentEventHandler;
        this.queueOfAbandonedClasses = new LinkedBlockingQueue<AbandonedClassQueueElement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abandonClass(BasicClassInfo basicClassInfo, byte[] originalClassBytes) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Class \"%s\" abandoned - could not be BCId", basicClassInfo.getClassName()));
        }
        this.queueOfAbandonedClasses.offer(new AbandonedClassQueueElement(basicClassInfo, originalClassBytes));
        AbandonedClassBCIManager abandonedClassBCIManager = this;
        synchronized (abandonedClassBCIManager) {
            if (this.queueOfAbandonedClasses.size() > 0 && this.future == null) {
                this.schedule();
            }
        }
    }

    public synchronized void schedule() {
        this.future = this.scheduler.schedule(this, SCHEDULE_FUTURE_IN_SECONDS, AgentTimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LinkedList listOfElementsToProcess = new LinkedList();
        this.queueOfAbandonedClasses.drainTo(listOfElementsToProcess);
        IByteCodeTransformer transformer = this.bciEngine.getClassFileTransformer();
        ArrayList<String> listOfClassesThatShouldHaveBeenTransformed = new ArrayList<String>();
        LinkedList<AbandonedClassQueueElement> retryList = new LinkedList<AbandonedClassQueueElement>();
        for (AbandonedClassQueueElement nextElement : listOfElementsToProcess) {
            BasicClassInfo basicClassInfo = nextElement.getBasicClassInfo();
            byte[] classBytes = nextElement.getClassBytes();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Class \"%s\" being processed by AbandonedClassBCIManager", basicClassInfo.getClassName()));
            }
            ClassLoader classLoader = basicClassInfo.getLoader();
            try {
                String className = basicClassInfo.getClassName().replace('/', '.');
                Class<?> alreadyLoadedClass = classLoader != null ? classLoader.loadClass(className) : this.bciEngine.getBootstrapClassManager().getBootstrapClassIfLoaded(className);
                byte[] bcidClass = transformer.transform(classLoader, basicClassInfo.getClassName(), alreadyLoadedClass, alreadyLoadedClass.getProtectionDomain(), classBytes);
                if (bcidClass == null) continue;
                listOfClassesThatShouldHaveBeenTransformed.add(className);
            }
            catch (ClassNotFoundException e) {
                String message = String.format("%s caught trying to analyze abandoned class %s and max attempts reached", e, basicClassInfo.getClassName());
                if (++nextElement.numAttempts < 5) {
                    retryList.add(nextElement);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(message, e);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(message, e);
                    continue;
                }
                logger.warn(message);
            }
            catch (IllegalClassFormatException cfe) {
                logger.error(String.format("%s caught trying to analyze abandoned class %s", cfe, basicClassInfo.getClassName()), cfe);
            }
        }
        this.queueOfAbandonedClasses.addAll(retryList);
        AbandonedClassBCIManager abandonedClassBCIManager = this;
        synchronized (abandonedClassBCIManager) {
            if (this.queueOfAbandonedClasses.size() > 0) {
                this.schedule();
            } else {
                this.future = null;
            }
        }
        if (listOfClassesThatShouldHaveBeenTransformed.size() > 0) {
            this.sendAbandonedBCIEventToController(listOfClassesThatShouldHaveBeenTransformed);
        }
    }

    private void sendAbandonedBCIEventToController(Collection<String> listOfClassNames) {
        String allClassNames = StringOperations.convertToDelimiterSeparatedString(listOfClassNames, (String)"\n");
        this.agentEventHandler.onErrorAgentEvent(null, null, "Unable to BCI class(es) " + allClassNames + " because of potential ClassLoader deadlock.");
    }

    private static class AbandonedClassQueueElement {
        private final BasicClassInfo basicClassInfo;
        private final byte[] classBytes;
        private int numAttempts;

        AbandonedClassQueueElement(BasicClassInfo basicClassInfo, byte[] classBytes) {
            this.basicClassInfo = basicClassInfo;
            this.classBytes = classBytes;
        }

        BasicClassInfo getBasicClassInfo() {
            return this.basicClassInfo;
        }

        byte[] getClassBytes() {
            return this.classBytes;
        }
    }
}

