/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassTransformationCallback;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;

class AllClassRetransformer
implements IAgentRunnable {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.AllClassRetransformer");
    private final Class<?>[] classesToRetransform;
    private int currentClassIndex;
    private final IAgentScheduledExecutorService scheduler;
    private final IBCIEngineService bciEngine;
    private final int numClassesToTransformAtATime;
    private IAgentScheduledFuture future;

    AllClassRetransformer(Class<?>[] classesToRetransform, IAgentScheduledExecutorService scheduler, IBCIEngineService bciEngine, int numClassesToTransformAtATime) {
        this.scheduler = scheduler;
        this.classesToRetransform = classesToRetransform;
        this.bciEngine = bciEngine;
        this.numClassesToTransformAtATime = numClassesToTransformAtATime;
    }

    void scheduleToRun(long initialDelay, long frequency) {
        this.future = this.scheduler.scheduleWithFixedDelay(this, 0L, frequency, AgentTimeUnit.MILLISECONDS);
    }

    public void run() {
        int numReTransformed = 0;
        while (numReTransformed < this.numClassesToTransformAtATime && this.currentClassIndex < this.classesToRetransform.length) {
            Class<?> clazz = this.classesToRetransform[this.currentClassIndex++];
            if (this.bciEngine.geTransformationRuleEngine().excludeFromProcessing(clazz, clazz.getClassLoader())) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Class %s is not retransformed, because excluded by BCIFixer", clazz.getName()));
                continue;
            }
            try {
                if (this.bciEngine.isRetransformCandidate(clazz)) {
                    this.bciEngine.retransformClass((ClassTransformationCallback)null, clazz);
                    ++numReTransformed;
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Class %s is not retransformed, because not retransform candidate", clazz.getName()));
            }
            catch (Throwable e) {
                logger.error(String.format("%s caught in AllClassRetransformer.run()", e), e);
            }
        }
        logger.info(String.format("%d classes have been retransformed by AllClassRetransformer", numReTransformed));
        if (this.currentClassIndex >= this.classesToRetransform.length) {
            this.future.cancel(false);
        }
    }
}

