/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.kernel.spi.AMBeanBase;
import com.singularity.ee.agent.appagent.services.bciengine.BCIEngineInfoProviderMBean;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.ModifiedMethods;
import com.singularity.ee.agent.appagent.services.bciengine.NullBCIEngineMetricHolder;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineMetricHolder;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.string.StringOperations;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class BCIEngineInfoProvider
extends AMBeanBase
implements BCIEngineInfoProviderMBean,
IBCIEngineInfoProvider {
    private final IBCIEngineService bciEngineService;
    private volatile int numClassesTransformed;
    private volatile int numMethodsTransformed;
    private volatile int numClassesLoaded;
    private volatile int numClassesRetransformed;
    private volatile int numValidationFailures;
    private volatile int numTimedOutTransformations;
    private volatile int numAbandonedBCI;
    private volatile int numFailedRetransforms;
    private volatile int numBootstrapLookups;
    private volatile int numBootstrapRefreshes;
    private volatile int numBootstrapClassLoads;
    private volatile int numBootstrapClassLoadMisses;
    private static final Boolean TRUE = true;
    private volatile boolean detailCollection;
    private volatile ConcurrentHashMap<String, ModifiedMethods> mapOfModifiedClassesAndMethods;
    private volatile ConcurrentHashMap<String, Boolean> classesToTrace;
    private final IBCIEngineMetricHolder agentBCIMetricHolder;
    private final IBCIEngineMetricHolder noOpMetricHolder;
    private IBCIEngineMetricHolder metricHolderInUse;

    BCIEngineInfoProvider(IBCIEngineService bciEngineService, IBCIEngineMetricHolder agentBCIMetricHolder, IADLogger logger) {
        super(logger);
        this.metricHolderInUse = this.noOpMetricHolder = new NullBCIEngineMetricHolder();
        this.bciEngineService = bciEngineService;
        this.agentBCIMetricHolder = agentBCIMetricHolder;
        this.metricHolderInUse = agentBCIMetricHolder;
    }

    @Override
    public int getNumberOfTransformedClasses() {
        return this.numClassesTransformed;
    }

    @Override
    public int getNumberOfTransformedMethods() {
        return this.numMethodsTransformed;
    }

    @Override
    public int getNumberOfClassesLoaded() {
        return this.numClassesLoaded;
    }

    @Override
    public int getNumberOfClassesRetransformed() {
        return this.numClassesRetransformed;
    }

    @Override
    public int getNumberOfValidationFailures() {
        return this.numValidationFailures;
    }

    @Override
    public int getNumberOfTimedOutTransformations() {
        return this.numTimedOutTransformations;
    }

    @Override
    public int getNumberOfAbandonedBCIAttempts() {
        return this.numAbandonedBCI;
    }

    @Override
    public int getNumberOfFailedRetransforms() {
        return this.numFailedRetransforms;
    }

    @Override
    public int getNumberOfBootstrapClassLookups() {
        return this.numBootstrapLookups;
    }

    @Override
    public int getNumberOfBootstrapRefreshes() {
        return this.numBootstrapRefreshes;
    }

    @Override
    public int getNumberOfBootstrapClassLoads() {
        return this.numBootstrapClassLoads;
    }

    @Override
    public int getNumberOfBootstrapClassLoadMisses() {
        return this.numBootstrapClassLoadMisses;
    }

    @Override
    protected String getMBeanTypeName() {
        return "BCIEngineInfoProvider";
    }

    @Override
    public void incrementNumClassesTransformed(int incr) {
        this.numClassesTransformed += incr;
        this.metricHolderInUse.incrementClassTransforms(incr);
    }

    @Override
    public void incrementNumMethodsTransformed(int incr) {
        this.numMethodsTransformed += incr;
        this.metricHolderInUse.incrementMethodTransforms(incr);
    }

    @Override
    public void incrementNumClassesLoaded(int incr) {
        this.numClassesLoaded += incr;
        this.metricHolderInUse.incrementClassLoads(incr);
    }

    @Override
    public void incrementNumClassesRetransformed(int incr) {
        this.numClassesRetransformed += incr;
        this.metricHolderInUse.incrementClassReTransformed(incr);
    }

    @Override
    public void incrementNumValidationFailures(int incr) {
        this.numValidationFailures += incr;
        this.metricHolderInUse.incrementValidationFailure(incr);
    }

    @Override
    public void incrementNumTimedOutTransformations(int incr) {
        this.numTimedOutTransformations += incr;
        this.metricHolderInUse.incrementTransformationTimeout(incr);
    }

    @Override
    public void incrementAbandonedBCICount(int incr) {
        this.numAbandonedBCI += incr;
        this.metricHolderInUse.incrementAbandonedBCIs(incr);
    }

    @Override
    public void incrementFailedRetransformRequest(int incr) {
        this.numFailedRetransforms += incr;
        this.metricHolderInUse.incrementFailedRetransformRequests(incr);
    }

    @Override
    public void incrementNumberOfBootstrapClassLookups(int incr) {
        this.numBootstrapLookups += incr;
        this.metricHolderInUse.incrementBootstrapClassLookups(incr);
    }

    @Override
    public void incrementNumberOfBootstrapRefreshes(int incr) {
        this.numBootstrapRefreshes += incr;
        this.metricHolderInUse.incrementBootstrapClassRefreshes(incr);
    }

    @Override
    public void incrementNumberOfBootstrapClassLoads(int incr) {
        this.numBootstrapClassLoads += incr;
        this.metricHolderInUse.incrementBootstrapClassLoads(incr);
    }

    @Override
    public void incrementNumberOfBootstrapClassLoadMisses(int incr) {
        this.numBootstrapClassLoadMisses += incr;
        this.metricHolderInUse.incrementBootstrapClassLoadMisses(incr);
    }

    @Override
    public void incrementTransformationTime(long incr) {
        this.metricHolderInUse.incrementTransformTime(incr);
    }

    @Override
    public void incrementNonTransformationTime(long incr) {
        this.metricHolderInUse.incrementNonTransformTime(incr);
    }

    @Override
    public void incrementBackgroundTransformationTime(long incr) {
        this.metricHolderInUse.incrementNumberBackgroundTransformations(1);
        this.metricHolderInUse.incrementBackgroundTransformationTime(incr);
    }

    @Override
    public void incrementTimeToCreateMetaData(long incr) {
        this.metricHolderInUse.incrementNumberOfMetaDataCreated(1);
        this.metricHolderInUse.incrementTimeToCreateMetaData(incr);
    }

    @Override
    public void incrementTimeToPurgeMetaData(long incr) {
        this.metricHolderInUse.incrementNumberOfPurgeMetaDataOperations(1);
        this.metricHolderInUse.incrementTimeToPurgeMetaData(incr);
    }

    @Override
    public void incrementTimeToReadClassFiles(long incr) {
        this.metricHolderInUse.incrementNumberOfClassFileReads(1);
        this.metricHolderInUse.incrementTimeToReadClassFiles(incr);
    }

    @Override
    public boolean isDetailCollection() {
        return this.detailCollection;
    }

    @Override
    public void setDetailCollection(boolean newDetailCollection) {
        this.detailCollection = newDetailCollection;
        if (!this.detailCollection && this.mapOfModifiedClassesAndMethods != null) {
            this.mapOfModifiedClassesAndMethods.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineModifiedClassAndMethods(String className, ModifiedMethods modifiedMethods) {
        if (this.detailCollection) {
            if (this.mapOfModifiedClassesAndMethods == null) {
                BCIEngineInfoProvider bCIEngineInfoProvider = this;
                synchronized (bCIEngineInfoProvider) {
                    if (this.mapOfModifiedClassesAndMethods == null) {
                        this.mapOfModifiedClassesAndMethods = new ADConcurrentHashMap();
                    }
                }
            }
            this.mapOfModifiedClassesAndMethods.put(className, modifiedMethods);
        }
    }

    @Override
    public String getTransformedClassNames() {
        StringBuilder sb = new StringBuilder();
        if (!this.detailCollection) {
            sb.append("BCIEngineInfoProvider not in detail mode - no information available");
        } else if (this.mapOfModifiedClassesAndMethods == null || this.mapOfModifiedClassesAndMethods.size() == 0) {
            sb.append("No classes transformed");
        } else {
            for (String nextClassName : this.mapOfModifiedClassesAndMethods.keySet()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(nextClassName.replace('/', '.'));
            }
        }
        return sb.toString();
    }

    @Override
    public String getTransformedMethodsForClass(String className) {
        StringBuilder sb = new StringBuilder();
        if (!this.detailCollection) {
            sb.append("BCIEngineInfoProvider not in detail mode - no information available");
        } else {
            ModifiedMethods modifiedMethods = this.mapOfModifiedClassesAndMethods.get(className.replace('.', '/'));
            if (modifiedMethods == null) {
                sb.append(String.format("No modified methods for class %s", className));
            } else {
                String[][] instrumentedMethods;
                for (String[] nextMethod : instrumentedMethods = modifiedMethods.getModifiedMethodsAsArray()) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(nextMethod[0]).append(',').append(nextMethod[1]);
                    String[] interceptors = modifiedMethods.getModifyingInterceptorsForMethod(nextMethod[0], nextMethod[1]);
                    if (interceptors == null || interceptors.length <= 0) continue;
                    sb.append(" modified by: ");
                    for (int i = 0; i < interceptors.length; ++i) {
                        if (i > 0) {
                            sb.append(',');
                        }
                        sb.append(interceptors[i]);
                    }
                }
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isRetransformClassesSupported() {
        return this.bciEngineService.isRetransformClassesSupported();
    }

    @Override
    public boolean isSystemExclude(String className) {
        return this.bciEngineService.geTransformationRuleEngine().isSystemExclude(className);
    }

    @Override
    public boolean isTransformerDisabled() {
        return this.bciEngineService.geTransformationRuleEngine().isTransformerDisabled();
    }

    @Override
    public void setTransformerDisabled(boolean disable) {
        this.bciEngineService.geTransformationRuleEngine().setTransformerDisabled(disable);
    }

    @Override
    public boolean forceRetransform(String className) {
        try {
            return this.bciEngineService.retransformClassNames(className.replace('/', '.'));
        }
        catch (UnableToRetransformException e) {
            this.logger.error(String.format("Exception %s caught in forceRetransform() for class %s", e, className), e);
            return false;
        }
    }

    @Override
    public void traceFor(String className) {
        this.getClassesToTrace();
        this.classesToTrace.putIfAbsent(className.replace('.', '/'), TRUE);
    }

    @Override
    public String getBCITraceClasses() {
        String returnString = "No classes to trace";
        if (this.classesToTrace != null) {
            returnString = StringOperations.convertToCommaSeparateString((Collection)this.classesToTrace.keySet());
        }
        return returnString;
    }

    @Override
    public void removeTraceFor(String className) {
        if (this.classesToTrace != null) {
            this.classesToTrace.remove(className.replace('.', '/'));
        }
    }

    @Override
    public boolean isTracingEnabledFor(String className) {
        boolean bReturn = false;
        if (this.classesToTrace != null) {
            bReturn = this.classesToTrace.get(className.replace('.', '/')) == TRUE;
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<String, Boolean> getClassesToTrace() {
        if (this.classesToTrace == null) {
            BCIEngineInfoProvider bCIEngineInfoProvider = this;
            synchronized (bCIEngineInfoProvider) {
                if (this.classesToTrace == null) {
                    this.classesToTrace = new ADConcurrentHashMap();
                }
            }
        }
        return this.classesToTrace;
    }

    @Override
    public boolean isTracingEnabledForAnyClass() {
        return this.classesToTrace != null && this.classesToTrace.size() != 0;
    }

    @Override
    public String getBCIWriteClassDirectory() {
        IByteCodeTransformer transformer = this.bciEngineService.getClassFileTransformer();
        if (transformer != null) {
            return transformer.getBCIWriteClassDirectory();
        }
        return null;
    }

    @Override
    public void setBCIWriteClassDirectory(String directory) {
        IByteCodeTransformer transformer = this.bciEngineService.getClassFileTransformer();
        if (transformer != null) {
            transformer.setBCIWriteClassDirectory(directory);
        }
    }

    @Override
    public void enableBCIMetric(boolean enable) {
        this.metricHolderInUse = !enable ? this.noOpMetricHolder : this.agentBCIMetricHolder;
    }

    public void hotDisable() {
        this.agentBCIMetricHolder.hotDisable();
    }
}

