/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.InterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.services.bciengine.BCIEngineInitInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.init.ASuperClass;
import com.singularity.ee.agent.appagent.services.bciengine.init.IBCIEngineIntf;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchClassNameFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchInterfaceFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchSuperClassNameFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodInfo;
import com.singularity.ee.agent.util.io.StreamUtil;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;

class BCIEngineInitializer {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.BCIEngineInitializer");
    private static final String INTERFACE_NAME = IBCIEngineIntf.class.getName();
    private static final String SUPER_CLASS_NAME = ASuperClass.class.getName();
    private static final String PLAIN_OLD_CLASS_NAME = "com.singularity.ee.agent.appagent.services.bciengine.init.PlainOldClass";
    private static final String EXTENDING_SUPER_CLASS_NAME = "com.singularity.ee.agent.appagent.services.bciengine.init.ExtendingSuperClass";
    private static final String IMPLEMENTING_INTERFACE_CLASS_NAME = "com.singularity.ee.agent.appagent.services.bciengine.init.ImplementingInterface";
    private static final String[] CLASSES_TO_TRANSFORM = new String[]{"com.singularity.ee.agent.appagent.services.bciengine.init.PlainOldClass", "com.singularity.ee.agent.appagent.services.bciengine.init.ExtendingSuperClass", "com.singularity.ee.agent.appagent.services.bciengine.init.ImplementingInterface"};
    private static final String[] METHOD_NAMES = new String[]{"sampleMethod", "sampleMethodReturningObject", "sampleMethodTakingStringArgument"};
    private static final MethodInfo sampleMethodMethodInfo = new MethodInfo("sampleMethod", "void");
    private static final MethodInfo sampleMethodReturningObjectMethodInfo = new MethodInfo("sampleMethodReturningObject", "java.lang.Object");
    private static final MethodInfo sampleMethodTakingStringArgumentMethodInfo = new MethodInfo("sampleMethodTakingStringArgument", "java.lang.Object", new String[]{"java.lang.String"});
    private static final MethodInfo[] methodInfoArray = new MethodInfo[]{sampleMethodMethodInfo, sampleMethodReturningObjectMethodInfo, sampleMethodTakingStringArgumentMethodInfo};
    private final IBCIEngineService bciEngine;
    private final ClassLoader classLoader;

    BCIEngineInitializer(IBCIEngineService bciEngine) {
        this.bciEngine = bciEngine;
        this.classLoader = this.getClass().getClassLoader();
        InterceptorClassRegistryBoot.bindClass((String)BCIEngineInitInterceptor.class.getName(), BCIEngineInitInterceptor.class);
    }

    void defineRules() {
        ClassMethodFilter classMethodFilter = new MatchInterfaceFilter(INTERFACE_NAME, METHOD_NAMES);
        TransformationRule rule = new TransformationRule(classMethodFilter, BCIEngineInitInterceptor.class);
        this.bciEngine.geTransformationRuleEngine().registerTransformationRule(rule);
        List<MethodInfo> listOfMethodInfo = Arrays.asList(methodInfoArray);
        classMethodFilter = new MatchSuperClassNameFilter(SUPER_CLASS_NAME, listOfMethodInfo);
        rule = new TransformationRule(classMethodFilter, BCIEngineInitInterceptor.class);
        this.bciEngine.geTransformationRuleEngine().registerTransformationRule(rule);
        StringMatchBoot methodNameMatcher = new StringMatchBoot(StringMatchBootType.EQUALS, METHOD_NAMES[0]);
        classMethodFilter = new MatchClassNameFilter(PLAIN_OLD_CLASS_NAME, methodNameMatcher);
        rule = new TransformationRule(classMethodFilter, BCIEngineInitInterceptor.class);
        this.bciEngine.geTransformationRuleEngine().registerTransformationRule(rule);
    }

    void forceTransformation() {
        IByteCodeTransformer transformer = this.bciEngine.getClassFileTransformer();
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        URLClassLoader fakeClassLoader = new URLClassLoader(new URL[0], this.classLoader);
        for (String nextClass : CLASSES_TO_TRANSFORM) {
            byte[] classBytes = this.getClassBytes(nextClass);
            if (classBytes == null) continue;
            try {
                transformer.transform(fakeClassLoader, nextClass.replace('.', '/'), null, protectionDomain, classBytes);
            }
            catch (IllegalClassFormatException e) {
                logger.error(String.format("%s caught trying to transform class %s", e, nextClass), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassBytes(String className) {
        byte[] classBytes = null;
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            classBytes = StreamUtil.getClassBytes((ClassLoader)this.classLoader, (String)className);
        }
        catch (IOException e) {
            logger.error(String.format("%s caught trying to read class bytes for %s", e, className), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
        return classBytes;
    }
}

