/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AnonymousClassDefTransformerBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.BaseMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IAnonymousClassDefTransformer;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.kernel.spi.IAgentDelegateBase;
import com.singularity.ee.agent.appagent.kernel.spi.IAgentEnvironment;
import com.singularity.ee.agent.appagent.kernel.spi.IAgentServiceContext;
import com.singularity.ee.agent.appagent.kernel.spi.IClassLoadListener;
import com.singularity.ee.agent.appagent.kernel.spi.IClassLoaderProvider;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.appagent.kernel.spi.IServiceContext;
import com.singularity.ee.agent.appagent.kernel.spi.IServicePropertyListener;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceConfig;
import com.singularity.ee.agent.appagent.kernel.spi.exception.ConfigException;
import com.singularity.ee.agent.appagent.kernel.spi.exception.ServiceStartException;
import com.singularity.ee.agent.appagent.kernel.spi.exception.ServiceStopException;
import com.singularity.ee.agent.appagent.services.bciengine.ASMConsumerFactory;
import com.singularity.ee.agent.appagent.services.bciengine.ASURLClassLoaders;
import com.singularity.ee.agent.appagent.services.bciengine.AbandonedClassBCIManager;
import com.singularity.ee.agent.appagent.services.bciengine.AllClassRetransformer;
import com.singularity.ee.agent.appagent.services.bciengine.BCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.BCIEngineInitializer;
import com.singularity.ee.agent.appagent.services.bciengine.BootstrapClassManager;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.IDeferredClassBCIHandler;
import com.singularity.ee.agent.appagent.services.bciengine.IEarlyRuleApplier;
import com.singularity.ee.agent.appagent.services.bciengine.InstrumentationHandler;
import com.singularity.ee.agent.appagent.services.bciengine.SystemExcludeManager;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.bciengine.TranformationInfoCache;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationManager;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassTransformationCallback;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IAgentEventDataHandler;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineMetricHolder;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ITransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.ALLByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.ALLRuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.transformation.AnonymousClassDefTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.transformation.java9.Java9ClassTransformerFactory;
import com.singularity.ee.agent.appagent.services.jmxservice.IMBeanRegistrationManager;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.debug.spi.IAgentDebugEventSenderBase;
import com.singularity.ee.agent.util.classloader.BootStrapClassLoaderProxy;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.properties.PropertyReader;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import dagger.CustomImpl;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.MalformedObjectNameException;

@Singleton
@CustomImpl
public class BCIEngineService
implements IBCIEngineService,
IServicePropertyListener {
    static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.BCIEngineService");
    private static final ILogger iLogger = logger;
    private static final int DEFAULT_RETRANSFORMATION_BATCH_SIZE = 50;
    private static final String EXCLUDE_CLASSES_LOADED_FROM_CLASSLOADER_PROP_NAME_PREFIX_1 = "exclude.classes.from.class.loader.1";
    private final TransformationRuleEngine transformationRuleEngine;
    private final Instrumentation instrumentation;
    private final IConfigManager configManager;
    private final TransformationManager transformationManager;
    private final IAgentEventDataHandler agentEventHandler;
    private final IEarlyRuleApplier earlyRuleApplier;
    private IByteCodeTransformer byteCodeTransformer;
    private ClassFileTransformer java9ClassFileTransformer;
    private IServiceConfig serviceConfig;
    private IAgentServiceContext serviceContext;
    private InstrumentationHandler instrumentationHandler;
    private boolean enableJson = true;
    private boolean enableXml = true;
    private boolean enableBatchRetransformation = true;
    private volatile IBCIEngineService.UnreachableThrowableTestAction enableUnreachableThrowTest = IBCIEngineService.UnreachableThrowableTestAction.CORRECT;
    private int retransformBatchSize = 50;
    private StringMatchBoot[] classLookAheadFiltersEnabled;
    private StringMatchBoot[] classLookAheadFiltersDisabled;
    private volatile boolean disableClassVerification;
    private boolean disableEarlyRuleAppliers;
    private boolean disableInfoProviderMBean;
    private boolean disableGlassfishClassloaderSuppression;
    private volatile int maxLimitOnNoOfClassesReported = 1000;
    private volatile int maxLimitOnNoOfMethodsReported = 300;
    private volatile Set<String> dumpCallStackOnLoadClassNames;
    private volatile IDeferredClassBCIHandler deferredClassBCIHandler;
    private volatile boolean infoProviderDetail;
    private volatile IClassMetaDataManager classMetaDataManager;
    private volatile boolean wasGlassfishDetermined;
    private volatile boolean isGlassfish;
    private static final String GLASSFISH_GIVEAWAY_PROPERTY = "com.sun.aas.installRoot";
    private volatile Set<String> excludedClassLoaderClassNames;
    private volatile BootstrapClassManager bootstrapClassManager;
    private BCIEngineInfoProvider infoProvider;
    private volatile Set<String> setOfURLClassLoaderClassNamesToUseGetResourceAsStream;
    private volatile AbandonedClassBCIManager abandonedClassBCIManager;
    private volatile Set<String> setOfURLClassLoaderClassNamesToUseAvoidResourceAsStream;
    private final IBCIEngineMetricHolder agentSpecificMetricHolder;
    private final IMBeanRegistrationManager mBeanRegistrationManager;
    private final IMemoryLimitCheck memoryLimitCheck;
    private final IAgentDelegateBase agentDelegateBase;
    private volatile boolean enableMetrics;
    private static final boolean IS_USING_BOOT_LOADER = BCIEngineService.class.getClassLoader() == null;
    private Boolean jvmIgnoresStackFrames;
    private final IAgentScheduledThreadPoolExecutor agentScheduler;
    private boolean agentClassesTransformationEnabled;
    private boolean disableClassloaderReader = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)"disable.classloader.reader"), (boolean)false);
    private final IJava9Util java9Util;
    private static final String JAVA9_TRANSFORMER_FACTORY_CLASS_NAME = "com.singularity.ee.agent.appagent.services.bciengine.asm.Java9TransformerFactory";
    private final BootStrapClassLoaderProxy bootStrapClassLoaderProxy;
    private final IClassLoaderProvider classLoaderProvider;

    @Inject
    public BCIEngineService(IAgentSchedulerManager agentSchedulerManager, Instrumentation instrumentation, IConfigManager configManager, TranformationInfoCache tranformationIdGenerator, InstrumentationHandler instrumentationHandler, IAgentEventDataHandler agentEventHandler, IEarlyRuleApplier earlyRuleApplier, IBCIEngineMetricHolder metricHolder, IMBeanRegistrationManager mBeanRegistrationManager, IAgentEnvironment agentEnvironment, IAgentDebugEventSenderBase debugEventSender, IMemoryLimitCheck memoryLimitCheck, IAgentDelegateBase agentDelegateBase, IJava9Util java9Util, Java9ClassTransformerFactory java9ClassTransformerFactory, BootStrapClassLoaderProxy bootStrapClassLoaderProxy, IClassLoaderProvider classLoaderProvider) {
        this.configManager = configManager;
        this.agentScheduler = agentSchedulerManager.getAgentGlobalScheduler();
        this.transformationManager = new TransformationManager(this, agentSchedulerManager, agentEnvironment);
        this.instrumentation = instrumentation;
        this.instrumentationHandler = instrumentationHandler;
        this.agentEventHandler = agentEventHandler;
        this.earlyRuleApplier = earlyRuleApplier;
        this.agentSpecificMetricHolder = metricHolder;
        this.mBeanRegistrationManager = mBeanRegistrationManager;
        this.memoryLimitCheck = memoryLimitCheck;
        this.agentDelegateBase = agentDelegateBase;
        this.bootStrapClassLoaderProxy = bootStrapClassLoaderProxy;
        BCTLoggerUtil.useAgentScheduler(this.agentScheduler);
        BCTLoggerUtil.println("#############################################################");
        BCTLoggerUtil.println("Starting ByteCodeTransformer at " + new Date());
        BCTLoggerUtil.println("#############################################################");
        BCTLoggerUtil.println("Using " + agentDelegateBase.getAgentDescription() + " Version [" + agentEnvironment.getAgentVersion() + "]");
        BCTLoggerUtil.println("Running IBM " + agentDelegateBase.getAgentDescription() + " [" + (agentEnvironment.isIBMBinary() ? "Yes" : "No") + "]");
        SystemExcludeManager systemExcludeManager = new SystemExcludeManager();
        this.transformationRuleEngine = new TransformationRuleEngine(systemExcludeManager, this.agentScheduler, tranformationIdGenerator, debugEventSender);
        this.byteCodeTransformer = ASMConsumerFactory.createNewByteCodeTransformer(this.transformationRuleEngine, this, agentEventHandler, agentEnvironment, debugEventSender, this.agentScheduler, java9Util, bootStrapClassLoaderProxy);
        this.java9Util = java9Util;
        this.java9ClassFileTransformer = java9ClassTransformerFactory.createJava9ByteCodeTransformer(this.byteCodeTransformer);
        this.classLoaderProvider = classLoaderProvider;
    }

    @Override
    public String getName() {
        return "BCIEngine";
    }

    @Override
    public boolean isClassLookAheadEnabledForClass(String className) {
        boolean bReturn = false;
        className = className.replace('/', '.');
        for (StringMatchBoot stringMatch : this.classLookAheadFiltersEnabled) {
            if (!stringMatch.matchString(className)) continue;
            bReturn = true;
            break;
        }
        if (bReturn) {
            for (StringMatchBoot stringMatch : this.classLookAheadFiltersDisabled) {
                if (!stringMatch.matchString(className)) continue;
                bReturn = false;
                break;
            }
            if (bReturn && logger.isTraceEnabled()) {
                logger.trace("Class lookahead feature being applied for class " + className);
            }
        }
        return bReturn;
    }

    @Override
    public void setServiceContext(IServiceContext serviceCtx) {
        this.serviceContext = (IAgentServiceContext)serviceCtx;
        this.byteCodeTransformer.setDeferredBCIHandler(this.getDeferredClassBCIHandler());
        this.getClassLookaheadFilters();
    }

    private void getClassLookaheadFilters() {
        String jvmVendor;
        ArrayList<StringMatchBoot> listOfLookaheadClassMatchesEnabled = new ArrayList<StringMatchBoot>();
        ArrayList<StringMatchBoot> listOfLookaheadClassMatchesDisabled = new ArrayList<StringMatchBoot>();
        Properties sysProps = new Properties();
        sysProps.putAll((Map<?, ?>)System.getProperties());
        for (Map.Entry<Object, Object> nextProp : sysProps.entrySet()) {
            String key = (String)nextProp.getKey();
            String value = (String)nextProp.getValue();
            if (!key.startsWith("appdynamics.bciengine.class.lookahead") || value.length() < 1) continue;
            boolean enabled = true;
            if (value.startsWith("!")) {
                enabled = false;
                value = value.substring(1);
            }
            StringMatchBoot stringMatch = value.equals("*") ? StringMatchBoot.ALWAYS_MATCH : (value.length() >= 3 && value.startsWith("*") && value.endsWith("*") ? new StringMatchBoot(StringMatchBootType.CONTAINS, value.substring(1, value.length() - 1)) : (value.startsWith("*") ? new StringMatchBoot(StringMatchBootType.ENDSWITH, value.substring(1)) : (value.endsWith("*") ? new StringMatchBoot(StringMatchBootType.STARTSWITH, value.substring(0, value.length() - 1)) : new StringMatchBoot(StringMatchBootType.EQUALS, value))));
            if (enabled) {
                listOfLookaheadClassMatchesEnabled.add(stringMatch);
                continue;
            }
            listOfLookaheadClassMatchesDisabled.add(stringMatch);
        }
        if (listOfLookaheadClassMatchesEnabled.size() == 0 && listOfLookaheadClassMatchesDisabled.size() == 0 && (jvmVendor = sysProps.getProperty("java.vendor")) != null && jvmVendor.length() >= 3 && jvmVendor.substring(0, 3).equalsIgnoreCase("IBM")) {
            listOfLookaheadClassMatchesEnabled.add(StringMatchBoot.ALWAYS_MATCH);
        }
        this.classLookAheadFiltersEnabled = listOfLookaheadClassMatchesEnabled.toArray(new StringMatchBoot[listOfLookaheadClassMatchesEnabled.size()]);
        this.classLookAheadFiltersDisabled = listOfLookaheadClassMatchesDisabled.toArray(new StringMatchBoot[listOfLookaheadClassMatchesDisabled.size()]);
    }

    @Override
    public void configure(IServiceConfig serviceConfig) throws ConfigException {
        this.serviceConfig = serviceConfig;
        PropertyReader initialProperties = new PropertyReader(serviceConfig.getConfigProperties());
        this.enableJson = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("enable-json-bci-rules"), (boolean)true);
        this.enableXml = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("enable-xml-bci-rules"), (boolean)true);
        this.enableBatchRetransformation = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("enable-batch-retransformation"), (boolean)true);
        this.retransformBatchSize = StringOperations.safeParseInteger((String)serviceConfig.getConfigProperties().get("retransformation-batch-size"), (int)50);
        boolean runInterceptorInPrivilegedAction = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("enable-interceptors-for-security"), (boolean)false);
        BaseMethodInterceptorDelegatorBoot.setUsePrivilegedAction((boolean)runInterceptorInPrivilegedAction);
        this.memoryLimitCheck.setClassMemoryLimitCheckEnabled(StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("enable-class-memory-check-before-retransform"), (boolean)true));
        this.memoryLimitCheck.setMinClassMemoryInMBNeededForRetransform(StringOperations.safeParseInteger((String)serviceConfig.getConfigProperties().get("class-memory-available-in-mb-before-retransform"), (int)5));
        this.transformationRuleEngine.setExcludeInterceptors(StringOperations.parseCommaSeparatedString((String)serviceConfig.getConfigProperties().get("exclude-interceptors")));
        this.disableClassloaderReader = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("disable-classloader-reader"), (boolean)false);
        this.disableClassloaderReader = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)"disable.classloader.reader"), (boolean)this.disableClassloaderReader);
        boolean enableNonClassTypeCheck = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("exclude-nonclasstype-for-transformation"), (boolean)false);
        enableNonClassTypeCheck = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)"exclude.nonclasstype.for.transformation"), (boolean)enableNonClassTypeCheck);
        this.transformationRuleEngine.setExcludeNonClassTypeForTransformation(enableNonClassTypeCheck);
        if (serviceConfig.getCustomConfig() != null) {
            this.transformationRuleEngine.setSystemExecludesFromConfigXML(serviceConfig.getCustomConfig());
        }
        boolean disableTrasformer = this.agentDelegateBase.isTranformerDisabled() || initialProperties.getBooleanProperty("disable-classfile-transformer", false, iLogger);
        this.transformationRuleEngine.setTransformerDisabled(disableTrasformer);
        String classLoadersProp = serviceConfig.getConfigProperties().get("force.use.get.resource.as.stream.class.loaders");
        if (classLoadersProp != null) {
            this.setOfURLClassLoaderClassNamesToUseGetResourceAsStream = this.parseClassLoaderClassNames(classLoadersProp);
        }
        if ((classLoadersProp = serviceConfig.getConfigProperties().get("avoid.use.get.resource.as.stream.class.loaders")) != null) {
            this.setOfURLClassLoaderClassNamesToUseAvoidResourceAsStream = this.parseClassLoaderClassNames(classLoadersProp);
        }
        this.disableEarlyRuleAppliers = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)"appdynamics.bciengine.disable.early.rule.appliers"), (boolean)false);
        this.disableInfoProviderMBean = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)"appdynamics.bciengine.disable.info.provider.mbean"), (boolean)false);
        this.disableGlassfishClassloaderSuppression = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)"appdynamics.disable.glassfish.classloader.suppression"), (boolean)false);
        this.enableMetrics = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("enable-bci-metrics"), (boolean)false);
        if (this.infoProvider != null) {
            this.infoProvider.enableBCIMetric(this.enableMetrics);
        }
        this.enableUnreachableThrowTest = BCIEngineService.parseUnreachableAction(serviceConfig.getConfigProperties().get("enable-unreachable-throw-test"), this.enableUnreachableThrowTest);
        this.getExcludedClassLoaderClassNames(serviceConfig.getConfigProperties());
        this.transformationManager.configure(serviceConfig);
    }

    private static IBCIEngineService.UnreachableThrowableTestAction parseUnreachableAction(String propValue, IBCIEngineService.UnreachableThrowableTestAction previousValue) {
        IBCIEngineService.UnreachableThrowableTestAction returnValue = previousValue;
        if (propValue != null) {
            for (IBCIEngineService.UnreachableThrowableTestAction nextAction : IBCIEngineService.UnreachableThrowableTestAction.values()) {
                if (!nextAction.name().equalsIgnoreCase(propValue)) continue;
                returnValue = nextAction;
                break;
            }
        }
        return returnValue;
    }

    private Set<String> parseClassLoaderClassNames(String propValue) {
        HashSet<String> returnSet = null;
        String[] parsedClassNames = propValue.split(",");
        if (parsedClassNames.length > 0) {
            returnSet = new HashSet<String>(parsedClassNames.length);
            for (String nextClassName : parsedClassNames) {
                returnSet.add(nextClassName);
            }
        }
        return returnSet;
    }

    @Override
    public void start() throws ServiceStartException {
        String[] props = new String[]{"enable-json-bci-rules", "enable-xml-bci-rules", "unregister-classfile-transformer", "disable-classfile-transformer", "exclude-interceptors", "bci-log-config", "retransformation-batch-size", "enable-batch-retransformation", "enable-class-memory-check-before-retransform", "class-memory-available-in-mb-before-retransform", "print-instructions", "enable-interceptors-for-security", "disable-class-verification", EXCLUDE_CLASSES_LOADED_FROM_CLASSLOADER_PROP_NAME_PREFIX_1, "bciengine-info-provider-detail", "force.use.get.resource.as.stream.class.loaders", "enable-bci-metrics", "enable-unreachable-throw-test", "bciengine-disable-retransformation"};
        this.configManager.registerConfigPropertyChangeListener(this.getName(), props, (IServicePropertyListener)this);
        this.transformationManager.init(this.configManager);
        if (!this.disableEarlyRuleAppliers) {
            if (!this.isRetransformClassesSupported()) {
                this.loadEarlyRuleAppliers();
            } else {
                logger.info("BCI Early Rule Appliers are bypassed because retransformation is supported");
            }
        } else {
            logger.info("BCI Early Rule Appliers are bypassed because they are disabled");
        }
        this.engageByteCodeTransformations();
    }

    private void engageByteCodeTransformations() {
        if (!IS_USING_BOOT_LOADER) {
            BCIEngineInitializer bciEngineInitializer = new BCIEngineInitializer(this);
            bciEngineInitializer.defineRules();
            bciEngineInitializer.forceTransformation();
        }
        this.getBootstrapClassManager();
        boolean removeTransformer = StringOperations.safeParseBoolean((String)this.serviceConfig.getConfigProperties().get("unregister-classfile-transformer"), (boolean)false);
        boolean registerForRetransform = StringOperations.safeParseBoolean((String)this.serviceConfig.getConfigProperties().get("register-for-retransform"), (boolean)true);
        if (!removeTransformer && registerForRetransform) {
            AnonymousClassDefTransformer anonClassTransformer = new AnonymousClassDefTransformer(this.byteCodeTransformer);
            this.instrumentationHandler.registerTransformer(this.java9ClassFileTransformer != null ? this.java9ClassFileTransformer : this.byteCodeTransformer);
            AnonymousClassDefTransformerBoot.register((IAnonymousClassDefTransformer)anonClassTransformer);
        } else {
            logger.info("Byte Code Transfomer NOT Registered");
        }
    }

    @Override
    public void allServicesStarted() {
        if (!this.disableInfoProviderMBean) {
            BCIEngineInfoProvider infoProvider = new BCIEngineInfoProvider(this, this.agentSpecificMetricHolder, logger);
            infoProvider.setDetailCollection(this.infoProviderDetail);
            try {
                this.mBeanRegistrationManager.registerMBean((Object)infoProvider, infoProvider.getObjectName());
                this.infoProvider = infoProvider;
                logger.info("BCIEngineService has created BCIEngineInfoProvider");
            }
            catch (MalformedObjectNameException e) {
                logger.error("BCIEngine unable to register InfoProvider", e);
            }
        }
        this.memoryLimitCheck.initializeMemoryMXBean();
    }

    @Override
    public void addClassLoadListener(IClassLoadListener classLoadListener) {
        this.byteCodeTransformer.addClassLoadListener(classLoadListener);
    }

    @Override
    public boolean isAgentClassesTransformationEnabled() {
        return this.agentClassesTransformationEnabled;
    }

    @Override
    public void setAgentClassesTransformationEnabled(boolean enable) {
        this.agentClassesTransformationEnabled = enable;
    }

    @Override
    public boolean isClassLoaderReaderDisabled() {
        return this.disableClassloaderReader;
    }

    @Override
    public void stop() throws ServiceStopException {
        throw new UnsupportedOperationException("");
    }

    @Override
    public ITransformationRuleEngine geTransformationRuleEngine() {
        return this.transformationRuleEngine;
    }

    @Override
    public IByteCodeTransformer getClassFileTransformer() {
        return this.byteCodeTransformer;
    }

    @Override
    public boolean retransformClassesForAgentMain() {
        if (this.instrumentationHandler.isRetransformClassesSupported()) {
            Class[] allClasses = this.instrumentation.getAllLoadedClasses();
            new AllClassRetransformer(allClasses, this.agentScheduler, this, 100).scheduleToRun(0L, 5000L);
            return true;
        }
        return false;
    }

    @Override
    public boolean isRetransformCandidate(Class clazz) throws TimeoutWaitingForLockException {
        for (AClassTransformationRule transformationRule : this.geTransformationRuleEngine().getTransformationRules()) {
            ClassMethodFilter classMethodFilter = transformationRule.getFilter();
            if (classMethodFilter.getRuntimeClassFilter() instanceof ALLRuntimeClassFilter || classMethodFilter.getByteCodeClassFilter() instanceof ALLByteCodeClassFilter) continue;
            BasicClassInfo basicInfo = new BasicClassInfo(clazz.getClassLoader(), clazz.getName());
            RuntimeClassInfo runtimeInfo = new RuntimeClassInfo(clazz, this.isClassLookAheadEnabledForClass(clazz.getName()), this.isSafeToCallHasAnnotation(clazz), this.getClassMetaDataManager());
            if (!classMethodFilter.getRuntimeClassFilter().matchClass(basicInfo, runtimeInfo)) continue;
            for (Method method : clazz.getDeclaredMethods()) {
                if (!this.isCandidateBecauseOfMethodMatch(classMethodFilter, method)) continue;
                return true;
            }
            if (!this.isCandidateBecauseOfInheritance(basicInfo, runtimeInfo, clazz, classMethodFilter, transformationRule)) continue;
            return true;
        }
        return false;
    }

    private boolean isCandidateBecauseOfMethodMatch(ClassMethodFilter classMethodFilter, Method method) {
        boolean match = classMethodFilter.getMethodFilter().matchMethod(new MethodInfo(method));
        if (match && logger.isDebugEnabled()) {
            logger.debug("Method is a re-transformation candidate because of basic method match.  ClassMethodFilter: " + classMethodFilter + "Method name: " + method.getName());
        }
        return match;
    }

    private boolean isCandidateBecauseOfInheritance(BasicClassInfo basicInfo, RuntimeClassInfo runtimeInfo, Class clazz, ClassMethodFilter classMethodFilter, AClassTransformationRule transformationRule) {
        if (!classMethodFilter.getRuntimeClassFilter().matchClassWithHierarchy(basicInfo, runtimeInfo)) {
            return false;
        }
        boolean match = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!classMethodFilter.getMethodFilter().matchMethod(new MethodInfo(method))) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Method [" + method.getName() + "] is a re-transformation candidate because of method match in inheritance.  BasicClassInfo: " + basicInfo + "RuntimeClassInfo: " + runtimeInfo.getRunTimeClass().getName() + " Rule:[" + transformationRule + "]");
            }
            match = true;
            break;
        }
        return match;
    }

    @Override
    public void pingForRetransformInPremain() {
        if (this.enableBatchRetransformation) {
            logger.info("Pinging to retransform classes by worker");
            this.instrumentationHandler.pingForRetransform();
        }
    }

    @Override
    public boolean retransformClass(Class<?> ... clazz) throws UnableToRetransformException {
        return this.retransformClass((ClassTransformationCallback)null, clazz);
    }

    @Override
    public boolean retransformClass(ClassTransformationCallback callback, Class<?> ... clazz) throws UnableToRetransformException {
        if (logger.isDebugEnabled()) {
            logger.debug("BCIEngine attempting to retransform class: [" + clazz + "] ");
        }
        return this.instrumentationHandler.retransformClass(callback, clazz);
    }

    @Override
    public boolean retransformClassNames(String ... className) throws UnableToRetransformException {
        return this.retransformClassNames((ClassTransformationCallback)null, className);
    }

    @Override
    public boolean retransformClassNames(ClassTransformationCallback callback, String ... className) throws UnableToRetransformException {
        return this.instrumentationHandler.retransformClass(callback, className);
    }

    @Override
    public boolean retransformClassesForRule(Set<AClassTransformationRule> addedRules, Set<AClassTransformationRule> removedRules, boolean reTransformInPremain) throws UnableToRetransformException {
        return this.retransformClassesForRule(null, addedRules, removedRules, reTransformInPremain);
    }

    @Override
    public boolean retransformClassesForRule(ClassTransformationCallback callback, Set<AClassTransformationRule> addedRules, Set<AClassTransformationRule> removedRules, boolean reTransformInPremain) throws UnableToRetransformException {
        return this.instrumentationHandler.retransformClassesForRule(callback, addedRules, removedRules, reTransformInPremain);
    }

    @Override
    public void servicePropertyChanged(String serviceName, String propertyName, String newPropertyValue) {
        logger.info("BCIEngine service property " + propertyName + " changed, new value " + newPropertyValue);
        if (propertyName.equals("unregister-classfile-transformer")) {
            boolean unregister = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)false);
            if (this.instrumentation != null && this.byteCodeTransformer != null) {
                if (unregister) {
                    this.instrumentation.removeTransformer(this.byteCodeTransformer);
                    logger.info("BCIEngine.servicePropertyChanged : removed bytecodeTransformer");
                } else {
                    this.instrumentation.removeTransformer(this.byteCodeTransformer);
                    this.instrumentation.addTransformer(this.byteCodeTransformer);
                    logger.info("BCIEngine.servicePropertyChanged : Added bytecodeTransformer");
                }
            }
        } else if (propertyName.equals("disable-classfile-transformer")) {
            boolean transformerDisabled = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)false);
            this.transformationRuleEngine.setTransformerDisabled(transformerDisabled);
        } else if (propertyName.equals("enable-json-bci-rules")) {
            this.enableJson = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)this.enableJson);
        } else if (propertyName.equals("enable-xml-bci-rules")) {
            this.enableXml = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)this.enableXml);
        } else if (propertyName.equals("enable-batch-retransformation")) {
            this.enableBatchRetransformation = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)true);
        } else if (propertyName.equals("retransformation-batch-size")) {
            this.retransformBatchSize = StringOperations.safeParseInteger((String)newPropertyValue, (int)50);
        } else if (propertyName.equals("exclude-interceptors")) {
            this.transformationRuleEngine.setExcludeInterceptors(StringOperations.parseCommaSeparatedString((String)newPropertyValue));
        } else if (propertyName.equals("print-instructions")) {
            String[] classesToRetransform = this.transformationRuleEngine.printInstructions(StringOperations.parseCommaSeparatedString((String)newPropertyValue));
            if (classesToRetransform != null && classesToRetransform.length > 0) {
                logger.info("Retransforming classes for property :print-instructions[" + StringOperations.convertToDelimiterSeparateString((String[])classesToRetransform, (String)", ") + "]");
                try {
                    this.retransformClassNames(classesToRetransform);
                }
                catch (UnableToRetransformException e) {
                    e.sendError(logger, this.getClass().getSimpleName() + ".servicePropertyChanged()");
                }
            }
        } else if (propertyName.equals("enable-class-memory-check-before-retransform")) {
            this.memoryLimitCheck.setClassMemoryLimitCheckEnabled(StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)true));
        } else if (propertyName.equals("class-memory-available-in-mb-before-retransform")) {
            this.memoryLimitCheck.setMinClassMemoryInMBNeededForRetransform(StringOperations.safeParseInteger((String)newPropertyValue, (int)5));
        } else if (propertyName.equals("enable-interceptors-for-security")) {
            boolean callInPrivilegedAction = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)false);
            BaseMethodInterceptorDelegatorBoot.setUsePrivilegedAction((boolean)callInPrivilegedAction);
        } else if (propertyName.equals("disable-class-verification")) {
            this.disableClassVerification = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)this.disableClassVerification);
        } else if (propertyName.startsWith("exclude.classes.from.class.loader.")) {
            this.defineExcludedClassLoaderClassName(newPropertyValue);
        } else if (propertyName.equals("bciengine-info-provider-detail")) {
            this.infoProviderDetail = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)this.infoProviderDetail);
            if (this.infoProvider != null) {
                this.infoProvider.setDetailCollection(this.infoProviderDetail);
            }
        } else if (propertyName.equals("force.use.get.resource.as.stream.class.loaders")) {
            this.setOfURLClassLoaderClassNamesToUseGetResourceAsStream = this.parseClassLoaderClassNames(newPropertyValue);
        } else if (propertyName.equals("avoid.use.get.resource.as.stream.class.loaders")) {
            this.setOfURLClassLoaderClassNamesToUseAvoidResourceAsStream = this.parseClassLoaderClassNames(newPropertyValue);
        } else if (propertyName.equals("enable-bci-metrics")) {
            this.enableMetrics = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)this.enableMetrics);
            if (this.infoProvider != null) {
                this.infoProvider.enableBCIMetric(this.enableMetrics);
            }
        } else if (propertyName.equals("enable-unreachable-throw-test")) {
            this.enableUnreachableThrowTest = BCIEngineService.parseUnreachableAction(newPropertyValue, this.enableUnreachableThrowTest);
        } else if ("classmethodservice.max.no.of.classes.reported".equals(propertyName)) {
            int defaultValue = 1000;
            int newValue = StringOperations.safeParseInteger((String)newPropertyValue, (int)1000);
            newValue = Math.min(newValue, 1000);
            this.maxLimitOnNoOfClassesReported = newValue = Math.max(newValue, 0);
        } else if ("classmethodservice.max.no.of.methods.reported".equals(propertyName)) {
            int defaultValue = 300;
            int newValue = StringOperations.safeParseInteger((String)newPropertyValue, (int)300);
            newValue = Math.min(newValue, 1000);
            this.maxLimitOnNoOfMethodsReported = newValue = Math.max(newValue, 0);
        } else if ("bciengine-disable-retransformation".equals(propertyName)) {
            boolean disableRetransformation = StringOperations.safeParseBoolean((String)newPropertyValue, (boolean)false);
            this.instrumentationHandler.setRetransformationDisabled(disableRetransformation);
        }
    }

    @Override
    public boolean isJSONRulesDisabled() {
        return !this.enableJson;
    }

    @Override
    public boolean isXMLRulesDisabled() {
        return !this.enableXml;
    }

    @Override
    public boolean isEnableBatchRetransformation() {
        return this.enableBatchRetransformation;
    }

    @Override
    public int getRetransformBatchSize() {
        return this.retransformBatchSize;
    }

    @Override
    public int getMaxLimitOnNoOfClassesReported() {
        return this.maxLimitOnNoOfClassesReported;
    }

    @Override
    public int getMaxLimitOnNoOfMethodsReported() {
        return this.maxLimitOnNoOfMethodsReported;
    }

    @Override
    public void getClassObjects(Map<String, Class> classMap) {
        Class[] allClasses;
        for (Class clazz : allClasses = this.instrumentation.getAllLoadedClasses()) {
            if (!classMap.containsKey(clazz.getName())) continue;
            classMap.put(clazz.getName(), clazz);
        }
    }

    @Override
    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public Set<Class> getClassesByName(String className) {
        Class[] allClasses;
        HashSet<Class> matchedClasses = new HashSet<Class>();
        for (Class clazz : allClasses = this.instrumentation.getAllLoadedClasses()) {
            if (!className.equals(clazz.getName())) continue;
            matchedClasses.add(clazz);
        }
        return matchedClasses;
    }

    @Override
    public void hotDisable() {
        BaseMethodInterceptorDelegatorBoot.disable();
        if (this.infoProvider != null) {
            this.infoProvider.hotDisable();
        }
    }

    @Override
    public void hotEnable() {
        BaseMethodInterceptorDelegatorBoot.enable();
    }

    @Override
    public boolean isRetransformClassesSupported() {
        return this.instrumentationHandler.isRetransformClassesSupported();
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return this.instrumentationHandler.isRedefineClassesSupported();
    }

    public boolean isDisableClassVerification() {
        return this.disableClassVerification;
    }

    @Override
    public IBCIEngineService.UnreachableThrowableTestAction isEnableUnreachableThrowTest() {
        return this.enableUnreachableThrowTest;
    }

    @Override
    public IBCIEngineService.RetransformSupressionStatus shouldSuppressClassRetransform(Class<?> clazz) {
        IBCIEngineService.RetransformSupressionStatus returnValue = IBCIEngineService.RetransformSupressionStatus.DO_NOT_SUPPRESS;
        if (this.disableGlassfishClassloaderSuppression) {
            return returnValue;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        this.getClassMetaDataManager();
        if (classLoader != null && this.classMetaDataManager != null && this.isGlassfish() && ASURLClassLoaders.isASURLClassLoader(classLoader.getClass()) && this.classMetaDataManager.isDoneASURLClassLoader(classLoader)) {
            IBCIEngineService.RetransformSupressionStatus retransformSupressionStatus = returnValue = BCIEngineService.isAppDynamicsClass(clazz) ? IBCIEngineService.RetransformSupressionStatus.SUPPRESS_APPD_CLASS : IBCIEngineService.RetransformSupressionStatus.SUPPRESS_NON_APPD_CLASS;
        }
        if (this.geTransformationRuleEngine().excludeFromRetransformation(clazz)) {
            returnValue = IBCIEngineService.RetransformSupressionStatus.SUPPRESS_NON_APPD_CLASS;
        }
        return returnValue;
    }

    public static boolean isAppDynamicsClass(Class<?> clazz) {
        if (clazz != null) {
            return clazz.getName().startsWith("com.appdynamics") || clazz.getName().startsWith("com.singularity");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClassMetaDataManager getClassMetaDataManager() {
        IClassMetaDataManager classMetaDataManager = this.classMetaDataManager;
        if (classMetaDataManager == null) {
            BCIEngineService bCIEngineService = this;
            synchronized (bCIEngineService) {
                if (this.classMetaDataManager == null) {
                    this.classMetaDataManager = ASMConsumerFactory.getClassMetaDataManagerInstance(this, this.agentScheduler, this.java9Util, this.bootStrapClassLoaderProxy);
                }
                classMetaDataManager = this.classMetaDataManager;
            }
        }
        return classMetaDataManager;
    }

    private void loadEarlyRuleAppliers() {
        try {
            this.earlyRuleApplier.init(this.serviceConfig);
            this.earlyRuleApplier.start(this);
            logger.info("Early Rule Applier " + this.earlyRuleApplier + " has been activated");
        }
        catch (Exception e) {
            logger.error("Unable to initializer Early Rule Applier " + this.earlyRuleApplier, e);
        }
    }

    @Override
    public void replaceTransformationRules(Class<?> clazz, List<AClassTransformationRule[]> listOfRulesToReplace) {
        this.transformationRuleEngine.replaceTransformationRules(clazz, listOfRulesToReplace);
    }

    public boolean shouldDumpCallStackOnLoad(String className) {
        if (this.dumpCallStackOnLoadClassNames == null) {
            HashSet<String> classNameSet = new HashSet<String>();
            Properties copySysProps = new Properties();
            copySysProps.putAll((Map<?, ?>)SystemUtils.getSystemProperties());
            for (Map.Entry<Object, Object> nextProp : copySysProps.entrySet()) {
                String propKey = (String)nextProp.getKey();
                if (!propKey.startsWith("appdynamics.bciengine.dump.call.stack.on.load")) continue;
                classNameSet.add((String)nextProp.getValue());
            }
            this.dumpCallStackOnLoadClassNames = classNameSet;
        }
        if (this.dumpCallStackOnLoadClassNames.size() > 0) {
            return this.dumpCallStackOnLoadClassNames.contains(className.replace('/', '.'));
        }
        return false;
    }

    public byte[] performTransformation(IByteCodeTransformer byteCodeTransformer, ClassLoader loader, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, Object module) {
        this.classLoaderProvider.checkClass(className, loader);
        return this.transformationManager.performTransformation(byteCodeTransformer, loader, className, classBeingRedefined, classfileBuffer, module);
    }

    @Override
    public boolean isSafeToCallHasAnnotation(Class<?> clazz) {
        boolean bReturn = true;
        ClassLoader classLoader = clazz.getClassLoader();
        this.getClassMetaDataManager();
        if (classLoader != null && this.classMetaDataManager != null) {
            bReturn = !this.isGlassfish() || !this.classMetaDataManager.isDoneClassLoaderPresent(classLoader);
        }
        return bReturn;
    }

    @Override
    public boolean isGlassfish() {
        if (!this.wasGlassfishDetermined) {
            boolean bl = this.isGlassfish = System.getProperty(GLASSFISH_GIVEAWAY_PROPERTY) != null;
            if (this.isGlassfish) {
                logger.info("Glassfish environment detected");
            }
            this.wasGlassfishDetermined = true;
        }
        return this.isGlassfish;
    }

    @Override
    public boolean shouldClassesFromClassLoaderBeExcluded(ClassLoader classLoader) {
        boolean bReturn = false;
        if (this.excludedClassLoaderClassNames != null && classLoader != null) {
            bReturn = this.excludedClassLoaderClassNames.contains(classLoader.getClass().getName());
        }
        return bReturn;
    }

    @Override
    public void setTransformationDisabled(boolean transformationsDisabled) {
        this.transformationRuleEngine.setTransformerDisabled(transformationsDisabled);
    }

    @Override
    public IDeferredClassBCIHandler getDeferredClassBCIHandler() {
        if (this.deferredClassBCIHandler == null) {
            this.getDeferredClassBCIHandlerSync();
        }
        return this.deferredClassBCIHandler;
    }

    private synchronized IDeferredClassBCIHandler getDeferredClassBCIHandlerSync() {
        if (this.deferredClassBCIHandler == null) {
            this.deferredClassBCIHandler = ASMConsumerFactory.createNewDeferredClassBCIHandler(this.instrumentation, this, this.memoryLimitCheck, this.agentScheduler);
        }
        return this.deferredClassBCIHandler;
    }

    @Override
    public void timeoutAsyncBCIForClass(String className) {
        this.transformationManager.timeoutAsyncBCIForClass(className);
    }

    @Override
    public IBCIEngineInfoProvider getInfoProvider() {
        return this.infoProvider;
    }

    private void getExcludedClassLoaderClassNames(Map<String, String> mapOfProperties) {
        for (Map.Entry<String, String> nextProp : mapOfProperties.entrySet()) {
            String propName = nextProp.getKey();
            String propValue = nextProp.getValue();
            if (!propName.startsWith("exclude.classes.from.class.loader.")) continue;
            this.defineExcludedClassLoaderClassName(propValue);
        }
    }

    private void defineExcludedClassLoaderClassName(String className) {
        if (this.excludedClassLoaderClassNames == null) {
            this.excludedClassLoaderClassNames = new HashSet<String>();
        }
        this.excludedClassLoaderClassNames.add(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BootstrapClassManager getBootstrapClassManager() {
        BootstrapClassManager bootstrapClassManager = this.bootstrapClassManager;
        if (bootstrapClassManager == null) {
            BCIEngineService bCIEngineService = this;
            synchronized (bCIEngineService) {
                if (this.bootstrapClassManager == null) {
                    this.bootstrapClassManager = new BootstrapClassManager(this.instrumentation, this, this.agentScheduler, this.bootStrapClassLoaderProxy);
                }
                bootstrapClassManager = this.bootstrapClassManager;
            }
        }
        return bootstrapClassManager;
    }

    @Override
    public Set<String> getURLClassLoaderClassNamesToUseGetResourceAsStream() {
        return this.setOfURLClassLoaderClassNamesToUseGetResourceAsStream;
    }

    @Override
    public Set<String> getURLClassLoaderClassNamesToAvoidGetResourceAsStream() {
        return this.setOfURLClassLoaderClassNamesToUseAvoidResourceAsStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbandonedClassBCIManager getAbandonedClassBCIManager() {
        if (this.abandonedClassBCIManager == null) {
            BCIEngineService bCIEngineService = this;
            synchronized (bCIEngineService) {
                if (this.abandonedClassBCIManager == null) {
                    this.abandonedClassBCIManager = new AbandonedClassBCIManager(this, this.agentScheduler, this.agentEventHandler);
                }
            }
        }
        return this.abandonedClassBCIManager;
    }

    @Override
    public boolean isStackFramesIgnoredByJVM(boolean isJava7, RuntimeMXBean runtimeMXBean) {
        if (!isJava7) {
            return false;
        }
        if (this.jvmIgnoresStackFrames == null) {
            this.jvmIgnoresStackFrames = Boolean.FALSE;
            try {
                this.jvmIgnoresStackFrames = BCIEngineService.hasSplitVerifier(runtimeMXBean);
            }
            catch (Throwable t) {
                logger.error(String.format("%s caught trying to obtain Java command line arguments", t));
            }
        }
        return this.jvmIgnoresStackFrames;
    }

    public static boolean hasSplitVerifier(RuntimeMXBean runtimeMXBean) {
        boolean bReturn = false;
        List<String> commandLineArgs = runtimeMXBean.getInputArguments();
        if (commandLineArgs != null) {
            for (String nextArg : commandLineArgs) {
                if (!nextArg.equals("-XX:-UseSplitVerifier")) continue;
                bReturn = true;
                break;
            }
        }
        return bReturn;
    }
}

