/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationManager;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import java.util.concurrent.CountDownLatch;

class BackgroundTransformerTask
implements IAgentRunnable {
    private IADLogger logger;
    private IByteCodeTransformer transformer;
    private ClassLoader loader;
    private String className;
    private Class<?> classBeingRedefined;
    private byte[] classFileBuffer;
    private byte[] transformResult;
    private CountDownLatch countdownLatch;
    private IAgentAtomicInteger numActiveTransformTasks;
    private String thisToString;
    private TransformationManager transformationManager;
    private Object module;

    BackgroundTransformerTask() {
    }

    BackgroundTransformerTask(IByteCodeTransformer transformer, ClassLoader loader, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, CountDownLatch countdownLatch, IADLogger logger, IAgentAtomicInteger numActiveTransformTasks, TransformationManager transformationManager, Object module) {
        this.transformer = transformer;
        this.loader = loader;
        this.className = className;
        this.classBeingRedefined = classBeingRedefined;
        this.classFileBuffer = classfileBuffer;
        this.countdownLatch = countdownLatch;
        this.logger = logger;
        this.numActiveTransformTasks = numActiveTransformTasks;
        this.transformationManager = transformationManager;
        this.module = module;
        this.thisToString = String.format("BackgroundTransformerTask for class %s", className);
    }

    byte[] getTransformResult() {
        return this.transformResult;
    }

    public void run() {
        block8: {
            try {
                if (this.logger != null && this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("%s has started", this));
                }
                if (this.classBeingRedefined == null && this.transformationManager.shouldTimeoutAsyncBCIForClass(this.className)) {
                    long blockTime = this.transformationManager.getMaxTimeToWaitForBackgroundTransform() * 2L;
                    this.logger.info(String.format("Background transformation of class %s will be blocked for %d milli-seconds", this.className, blockTime));
                    Thread.sleep(blockTime);
                } else if (this.transformer != null) {
                    this.transformResult = this.transformer.doTransform(this.loader, this.className, this.classBeingRedefined, this.classFileBuffer, this.module);
                    if (this.logger != null && this.logger.isTraceEnabled()) {
                        this.logger.trace(String.format("%s has completed.  Result is %s", this, this.transformResult == null ? "null" : "non null"));
                    }
                }
            }
            catch (Throwable t) {
                String message = String.format("Throwable %s caught in %s", t, this);
                BCTLoggerUtil.printlnWithPrefix(message, ADLevel.WARN);
                if (this.logger == null) break block8;
                if (t instanceof TimeoutWaitingForLockException) {
                    this.logger.warn(message, t);
                    TimeoutWaitingForLockException timeoutWaitingForLockException = (TimeoutWaitingForLockException)t;
                    timeoutWaitingForLockException.writeToLog(this.logger);
                }
                this.logger.error(message, t);
            }
        }
        this.numActiveTransformTasks.decrementAndGet();
        this.countdownLatch.countDown();
    }

    public String toString() {
        return this.thisToString;
    }
}

