/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.IBootstrapClassManager;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.classloader.BootStrapClassLoaderProxy;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.lang.instrument.Instrumentation;
import java.util.concurrent.ConcurrentHashMap;

public class BootstrapClassManager
implements IBootstrapClassManager {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.BootstrapClassManager");
    private final ConcurrentHashMap<String, Class<?>> mapOfKnownBootstrapClassNames;
    private static final Class<?> THIS_CLASS = BootstrapClassManager.class;
    private final Instrumentation instrumentation;
    private static final long PURGE_MAP_AFTER = 300000L;
    private volatile long timeMapLastReferenced;
    private volatile boolean mapHasBeenPurged;
    private volatile boolean maintenanceTaskScheduled;
    private final MaintenanceTask maintenanceTask;
    private final IAgentScheduledExecutorService scheduler;
    private final IBCIEngineInfoProvider infoProvider;
    private final BootStrapClassLoaderProxy bootStrapClassLoaderProxy;

    BootstrapClassManager(Instrumentation instrumentation, IBCIEngineService bciEngine, IAgentScheduledExecutorService scheduler, BootStrapClassLoaderProxy bootStrapClassLoaderProxy) {
        this.instrumentation = instrumentation;
        this.infoProvider = bciEngine.getInfoProvider();
        this.scheduler = scheduler;
        this.bootStrapClassLoaderProxy = bootStrapClassLoaderProxy;
        this.maintenanceTask = new MaintenanceTask();
        this.mapOfKnownBootstrapClassNames = new ADConcurrentHashMap();
        this.mapHasBeenPurged = true;
        this.refreshSet();
    }

    public void newBootstrapClassLoaded(String className) {
        this.mapOfKnownBootstrapClassNames.put(className, THIS_CLASS);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Class \"%s\" added to known bootstrap classes", className));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSet() {
        if (logger.isTraceEnabled()) {
            logger.trace("refreshSet() is running");
        }
        Class[] allClassArray = this.instrumentation.getAllLoadedClasses();
        BootstrapClassManager bootstrapClassManager = this;
        synchronized (bootstrapClassManager) {
            if (this.mapHasBeenPurged) {
                for (Class nextClass : allClassArray) {
                    if (nextClass == null) {
                        logger.debug("Empty slot in all classes array for JVM");
                        continue;
                    }
                    if (nextClass.getClassLoader() != null) continue;
                    this.mapOfKnownBootstrapClassNames.put(nextClass.getName(), nextClass);
                    this.mapHasBeenPurged = false;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace(String.format("Discovered bootstrap class %s", nextClass.getName()));
                }
                this.timeMapLastReferenced = System.currentTimeMillis();
                this.scheduleMaintenanceTask();
                this.notifyAll();
            }
        }
        if (this.infoProvider != null) {
            this.infoProvider.incrementNumberOfBootstrapRefreshes(1);
        }
    }

    private synchronized void scheduleMaintenanceTask() {
        if (!this.maintenanceTaskScheduled) {
            this.scheduler.schedule(this.maintenanceTask, 300000L, AgentTimeUnit.MILLISECONDS);
            this.maintenanceTaskScheduled = true;
        }
    }

    public Class<?> getClass(String className) {
        Class returnClass;
        boolean traceEnabled = logger.isTraceEnabled();
        if (traceEnabled) {
            logger.trace(String.format("getClass() called for %s", className));
        }
        this.timeMapLastReferenced = System.currentTimeMillis();
        if (this.mapHasBeenPurged) {
            this.refreshSet();
        }
        if ((returnClass = this.mapOfKnownBootstrapClassNames.get(className)) == THIS_CLASS) {
            try {
                returnClass = this.bootStrapClassLoaderProxy.findBootstrapClassWithReflection(className);
                if (returnClass != null) {
                    this.mapOfKnownBootstrapClassNames.put(className, returnClass);
                } else {
                    logger.error("BSCM.getClass() unable to locate class" + className);
                }
            }
            catch (ClassNotFoundException e) {
                logger.error(String.format("%s caught trying to locate class %s", e, className), e);
                returnClass = null;
                this.mapOfKnownBootstrapClassNames.remove(className);
            }
            catch (Exception ex) {
                logger.error("BSCM.getClass() exception on locating class" + className, ex);
            }
        }
        if (this.infoProvider != null) {
            if (returnClass != null) {
                this.infoProvider.incrementNumberOfBootstrapClassLookups(1);
            } else {
                this.infoProvider.incrementNumberOfBootstrapClassLoadMisses(1);
            }
        }
        if (traceEnabled) {
            if (returnClass == null) {
                logger.trace(String.format("Could not find class object for %s", className));
            } else {
                logger.trace(String.format("Found class object for %s", className));
            }
        }
        return returnClass;
    }

    synchronized void maintainMap() {
        if (!this.mapHasBeenPurged && System.currentTimeMillis() - this.timeMapLastReferenced > 300000L) {
            this.mapOfKnownBootstrapClassNames.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("mapOfKnownBootstrapClassNames was cleared");
            }
            this.mapHasBeenPurged = true;
        }
        this.maintenanceTaskScheduled = false;
        if (!this.mapHasBeenPurged) {
            this.scheduleMaintenanceTask();
        }
    }

    @Override
    public Class<?> getBootstrapClassIfLoaded(String className) throws ClassNotFoundException {
        Class<?> returnClass = this.getClass(className = className.replace("/", "."));
        if (returnClass == null) {
            throw new ClassNotFoundException(String.format("Unable to find bootstrap class %s", className));
        }
        return returnClass;
    }

    private class MaintenanceTask
    implements IAgentRunnable {
        MaintenanceTask() {
        }

        public void run() {
            BootstrapClassManager.this.maintainMap();
        }
    }
}

