/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.spi.ClassIdentificationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IClassIdentificationListener;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;

public class ClassIdentificationNotifier {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ClassIdentificationNotifier");
    private final IAgentScheduledExecutorService globalScheduler;

    public ClassIdentificationNotifier(IAgentScheduledExecutorService globalScheduler) {
        this.globalScheduler = globalScheduler;
    }

    public void sendClassIdentification(BasicClassInfo basicInfo, ClassIdentificationRule rule) {
        Notifier1 notifier = new Notifier1(basicInfo, rule);
        this.globalScheduler.schedule(notifier, 0L, AgentTimeUnit.SECONDS);
    }

    public void sendClassIdentification(BasicClassInfo basicInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo, ClassIdentificationRule rule) {
        Notifier2 notifier = new Notifier2(basicInfo, runtimeClassInfo, byteCodeClassInfo, rule);
        this.globalScheduler.schedule(notifier, 0L, AgentTimeUnit.SECONDS);
    }

    private static class Notifier2
    implements IAgentRunnable {
        private final BasicClassInfo basicInfo;
        private final RuntimeClassInfo runtimeClassInfo;
        private final ByteCodeClassInfo byteCodeClassInfo;
        private final ClassIdentificationRule rule;

        private Notifier2(BasicClassInfo basicInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo, ClassIdentificationRule rule) {
            this.basicInfo = basicInfo;
            this.runtimeClassInfo = runtimeClassInfo;
            this.byteCodeClassInfo = byteCodeClassInfo;
            this.rule = rule;
        }

        public void run() {
            for (IClassIdentificationListener listener : this.rule.getClassListeners()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Identified Class [" + this.basicInfo.getClassName() + "]");
                }
                listener.identifiedClass(this.basicInfo, this.runtimeClassInfo, this.byteCodeClassInfo, this.rule);
            }
        }
    }

    private static class Notifier1
    implements IAgentRunnable {
        private final BasicClassInfo basicInfo;
        private final ClassIdentificationRule rule;

        private Notifier1(BasicClassInfo basicInfo, ClassIdentificationRule rule) {
            this.basicInfo = basicInfo;
            this.rule = rule;
        }

        public void run() {
            for (IClassIdentificationListener listener : this.rule.getClassListeners()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Identified Class [" + this.basicInfo.getClassName() + "]");
                }
                listener.identifiedClass(this.basicInfo, this.rule);
            }
        }
    }
}

