/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.object.ObjectComparisonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassLoaderReader {
    private final WeakReference<ClassLoader> refToClassLoader;
    private static final URL[] DUMMY_CLASS_PATH = new URL[0];
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static final String ZIP_FILE_SUFFIX = ".zip";
    private final int hashValue;
    private final IADLogger logger;
    private final IBCIEngineService bciEngine;
    private volatile URL[] baseClassPath;
    private static final Map<String, URL[]> JARS_TO_CLASS_PATH_MAP = new ADConcurrentHashMap();
    private Set<String> setOfURLClassLoaderClassNamesToUseGetResourceAsStream;
    private Set<String> setOfURLClassLoaderClassNamesToAvoidGetResourceAsStream;

    public ClassLoaderReader(IBCIEngineService bciEngine, ClassLoader classLoader, IADLogger logger) {
        this.bciEngine = bciEngine;
        this.refToClassLoader = new WeakReference<ClassLoader>(classLoader);
        this.hashValue = classLoader.hashCode();
        this.logger = logger;
    }

    public InputStream getInputStreamForClass(String className) {
        return this.getInputStreamForClass(className, true);
    }

    public InputStream getInputStreamForClass(String className, boolean useGetResourceAsStreamIfClassPathReadFails) {
        String tempClassName = className;
        if (this.bciEngine != null) {
            this.setOfURLClassLoaderClassNamesToUseGetResourceAsStream = this.bciEngine.getURLClassLoaderClassNamesToUseGetResourceAsStream();
            this.setOfURLClassLoaderClassNamesToAvoidGetResourceAsStream = this.bciEngine.getURLClassLoaderClassNamesToAvoidGetResourceAsStream();
        } else {
            this.setOfURLClassLoaderClassNamesToUseGetResourceAsStream = null;
            this.setOfURLClassLoaderClassNamesToAvoidGetResourceAsStream = null;
        }
        InputStream returnIS = null;
        if (className.endsWith(".class")) {
            tempClassName = className.substring(0, className.length() - 6);
        }
        ClassLoader classLoader = (ClassLoader)this.refToClassLoader.get();
        tempClassName = tempClassName.replace(".", "/");
        tempClassName = tempClassName + ".class";
        if (classLoader != null) {
            String classLoaderClassName = classLoader.getClass().getName();
            if (classLoader instanceof URLClassLoader && (this.setOfURLClassLoaderClassNamesToUseGetResourceAsStream == null || !this.setOfURLClassLoaderClassNamesToUseGetResourceAsStream.contains(classLoaderClassName))) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("Looking for class %s in ClassLoader %s by searching class path", tempClassName, classLoaderClassName));
                }
                if ((returnIS = this.getInputStreamForClassFromURLClassLoader(tempClassName)) == null && useGetResourceAsStreamIfClassPathReadFails && (this.setOfURLClassLoaderClassNamesToAvoidGetResourceAsStream == null || !this.setOfURLClassLoaderClassNamesToAvoidGetResourceAsStream.contains(classLoaderClassName))) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format("Could not locate class %s from ClassLoader %s by searching class path", tempClassName, classLoaderClassName));
                    }
                    if ((returnIS = classLoader.getResourceAsStream(tempClassName)) != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("Got class directly from getResourceAsStream()");
                    }
                }
            } else {
                returnIS = classLoader.getResourceAsStream(tempClassName);
            }
        }
        return returnIS;
    }

    private InputStream getInputStreamForClassFromURLClassLoader(String resourceName) {
        URLClassLoader classLoader = (URLClassLoader)this.refToClassLoader.get();
        InputStream returnIS = null;
        HashSet<String> urlsAlreadySearched = new HashSet<String>();
        if (classLoader != null) {
            if (this.baseClassPath == null) {
                this.baseClassPath = classLoader.getURLs();
                if (this.baseClassPath == null) {
                    this.baseClassPath = DUMMY_CLASS_PATH;
                }
            }
            if (this.baseClassPath != null && this.baseClassPath != DUMMY_CLASS_PATH) {
                returnIS = this.getInputStreamForClassFromClassPath(resourceName, this.baseClassPath, urlsAlreadySearched);
            }
        }
        return returnIS;
    }

    private InputStream getInputStreamForClassFromClassPath(String resourceName, URL[] classPath, Set<String> urlsAlreadySearched) {
        InputStream returnIS = null;
        for (URL nextURL : classPath) {
            URL[] classPathFromJar;
            File jarFile;
            if (!nextURL.getProtocol().equals("file") || urlsAlreadySearched.contains(nextURL.toString())) continue;
            urlsAlreadySearched.add(nextURL.toString());
            String fileName = nextURL.getFile();
            if (fileName != null && (returnIS = this.getInputStreamFromFile(fileName, resourceName)) != null || fileName.endsWith(JAR_FILE_SUFFIX) && (jarFile = new File(fileName)).exists() && !jarFile.isDirectory() && (classPathFromJar = this.getClassPathFromJar(fileName)) != null && classPathFromJar != DUMMY_CLASS_PATH && (returnIS = this.getInputStreamForClassFromClassPath(resourceName, classPathFromJar, urlsAlreadySearched)) != null) break;
        }
        return returnIS;
    }

    private URL[] getClassPathFromJar(String fileName) {
        URL[] returnClassPath = null;
        try {
            returnClassPath = JARS_TO_CLASS_PATH_MAP.get(fileName);
            if (returnClassPath == null) {
                JarFile jarFile = new JarFile(fileName);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    returnClassPath = this.getClassPathFromManifest(jarFile, manifest);
                    if (returnClassPath == null) {
                        returnClassPath = DUMMY_CLASS_PATH;
                    }
                } else {
                    returnClassPath = DUMMY_CLASS_PATH;
                }
                JARS_TO_CLASS_PATH_MAP.put(fileName, returnClassPath);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("%s caught trying to get Jar class path for %s", e, fileName), e);
        }
        return returnClassPath;
    }

    private URL[] getClassPathFromManifest(JarFile jarFile, Manifest manifest) throws MalformedURLException {
        URL[] returnClassPath = null;
        String classPathProperty = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPathProperty != null) {
            File jarFileDirectory = new File(jarFile.getName()).getParentFile();
            try {
                jarFileDirectory = jarFileDirectory.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String[] parsedClassPath = classPathProperty.split(" ");
            ArrayList<File> classPathList = new ArrayList<File>(parsedClassPath.length);
            for (String nextClassPathEntry : parsedClassPath) {
                File nextClassPathFile = new File(nextClassPathEntry);
                if (!nextClassPathFile.isAbsolute()) {
                    nextClassPathFile = new File(jarFileDirectory, nextClassPathEntry);
                }
                if (!nextClassPathFile.exists()) continue;
                classPathList.add(nextClassPathFile);
            }
            returnClassPath = new URL[classPathList.size()];
            int index = 0;
            for (File nextClassPathFile : classPathList) {
                returnClassPath[index++] = nextClassPathFile.toURI().toURL();
            }
        }
        return returnClassPath;
    }

    private InputStream getInputStreamFromFile(String fileName, String resourceName) {
        try {
            if (fileName.endsWith("/")) {
                return this.getInputStreamFromDirectory(fileName, resourceName);
            }
            return this.getInputStreamFromJarFile(fileName, resourceName);
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error(String.format("%s caught trying to return resource %s in file %s", e, resourceName, fileName), e);
            }
            return null;
        }
    }

    private InputStream getInputStreamFromDirectory(String fileName, String resourceName) throws IOException {
        File classFile;
        FileInputStream returnIS = null;
        File directory = new File(fileName);
        if (directory.isDirectory() && (classFile = new File(directory, resourceName)).exists() && !classFile.isDirectory()) {
            returnIS = new FileInputStream(classFile);
        }
        return returnIS;
    }

    private InputStream getInputStreamFromJarFile(String fileName, String resourceName) throws IOException {
        ZipFile zipFile;
        ZipEntry zipEntry;
        File file;
        InputStream returnIS = null;
        if ((fileName.endsWith(JAR_FILE_SUFFIX) || fileName.endsWith(ZIP_FILE_SUFFIX)) && (file = new File(fileName)).exists() && !file.isDirectory() && (zipEntry = (zipFile = new ZipFile(file)).getEntry(resourceName)) != null) {
            returnIS = zipFile.getInputStream(zipEntry);
        }
        return returnIS;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object o) {
        boolean bReturn;
        boolean bl = bReturn = this == o;
        if (!bReturn && o instanceof ClassLoaderReader) {
            ClassLoaderReader other = (ClassLoaderReader)o;
            ClassLoader thisClassLoader = (ClassLoader)this.refToClassLoader.get();
            ClassLoader otherClassLoader = (ClassLoader)other.refToClassLoader.get();
            bReturn = this.hashValue == other.hashValue && ObjectComparisonUtils.compareEquals((Object)thisClassLoader, (Object)otherClassLoader);
        }
        return bReturn;
    }
}

