/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.ClassLoaderNoLongerExistsException;
import com.singularity.ee.util.object.ObjectComparisonUtils;
import java.lang.ref.WeakReference;

public class ClassToRetransform {
    private String className;
    private byte[] classBytes;
    private WeakReference<ClassLoader> refToClassLoader;
    private int numberOfRetransformAttempts;
    private int hashCodeValue;

    public ClassToRetransform() {
    }

    ClassToRetransform(Class<?> clazz) {
        this(clazz.getName(), null, clazz.getClassLoader());
    }

    public ClassToRetransform(String className, byte[] classBytes, ClassLoader classLoader) {
        this.className = className;
        this.classBytes = classBytes;
        this.refToClassLoader = classLoader != null ? new WeakReference<ClassLoader>(classLoader) : null;
        this.hashCodeValue = className.hashCode();
        this.hashCodeValue ^= classLoader != null ? classLoader.hashCode() : 0;
    }

    public byte[] getClassBytes() {
        return this.classBytes;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassLoader getClassLoader() throws ClassLoaderNoLongerExistsException {
        ClassLoader returnClassLoader = null;
        if (this.refToClassLoader != null && (returnClassLoader = (ClassLoader)this.refToClassLoader.get()) == null) {
            throw new ClassLoaderNoLongerExistsException();
        }
        return returnClassLoader;
    }

    public int getNumberOfRetransformAttempts() {
        return this.numberOfRetransformAttempts;
    }

    public int incrementNumberOfRetransformAttempts() {
        return ++this.numberOfRetransformAttempts;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public boolean equals(Object o) {
        boolean bReturn;
        boolean bl = bReturn = this == o;
        if (!bReturn && o instanceof ClassToRetransform) {
            ClassToRetransform other = (ClassToRetransform)o;
            ClassLoader thisClassLoader = this.refToClassLoader != null ? (ClassLoader)this.refToClassLoader.get() : null;
            ClassLoader otherClassLoader = other.refToClassLoader != null ? (ClassLoader)other.refToClassLoader.get() : null;
            bReturn = this.hashCodeValue == other.hashCodeValue && this.className.equals(other.className) && ObjectComparisonUtils.compareEquals((Object)thisClassLoader, (Object)otherClassLoader);
        }
        return bReturn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("  className is ").append(this.className);
        return sb.toString();
    }
}

