/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.AClassTransformation;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassContainer;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassTransformationCallback;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IAgentEventDataHandler;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import dagger.Lazy;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;

public class ClassTransformation
extends AClassTransformation {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ClassTransformation");

    public ClassTransformation(Instrumentation instrumentation, Lazy<IBCIEngineService> bciEngineRef, IAgentEventDataHandler agentEventHandler, IMemoryLimitCheck memoryLimitCheck, IAgentSchedulerManager schedulerManager) {
        super(instrumentation, bciEngineRef, agentEventHandler, memoryLimitCheck, schedulerManager);
    }

    @Override
    protected boolean isModifiableClass(Class<?> theClass) {
        return this.getInstrumentation().isModifiableClass(theClass);
    }

    @Override
    public boolean isRetransformClassesSupported() {
        try {
            return this.getInstrumentation().isRetransformClassesSupported();
        }
        catch (Exception e) {
            String message = "Class retransformation NOT supported, error encountered while checking retransformation capability " + e;
            logger.warn(message);
            return false;
        }
    }

    @Override
    public void registerForRetransform(ClassFileTransformer transformer) {
        String message;
        if (this.isRetransformClassesSupported()) {
            this.getInstrumentation().addTransformer(transformer, true);
            super.setActive(true);
            message = "Class retransformation supported in current JVM version";
        } else {
            this.getInstrumentation().addTransformer(transformer, false);
            message = "Class retransformation NOT supported in current JVM version";
        }
        logger.info(message);
        this.sendAgentEvent("Class Re-Modification", message);
    }

    @Override
    void actualRetransform(ClassContainer[] containers) throws UnableToRetransformException {
        this.testOKToRetransform(containers.length);
        Object[] classes = new Class[containers.length];
        try {
            int i;
            for (i = 0; i < containers.length; ++i) {
                classes[i] = containers[i].getClazz();
            }
            logger.info("Re-transforming batch of " + containers.length + " classes");
            this.getInstrumentation().retransformClasses((Class<?>[])classes);
            i = 0;
            block5: for (int filteredIdx = 0; filteredIdx < classes.length; ++filteredIdx) {
                Object filteredClass = classes[filteredIdx];
                while (i < containers.length) {
                    ClassContainer container = containers[i];
                    if (container.getClazz().equals(filteredClass)) {
                        ClassTransformationCallback callback = container.getCallback();
                        if (callback != null) {
                            try {
                                callback.alertClassTransformationComplete((Class)filteredClass);
                            }
                            catch (Throwable t) {
                                logger.warn("Error occurred while invoking BCI callback", t);
                            }
                        }
                        ++i;
                        continue block5;
                    }
                    ++i;
                }
            }
        }
        catch (UnmodifiableClassException e) {
            logger.warn("Error retransforming class :" + Arrays.toString(classes), e);
        }
    }

    @Override
    protected void actualRetransform(ClassTransformationCallback callback, Class[] classes) {
        try {
            logger.info("Re-transforming " + classes.length + " classes");
            this.getInstrumentation().retransformClasses(classes);
            if (callback != null) {
                callback.alertClassCollectionTransformationComplete(classes);
            }
        }
        catch (UnmodifiableClassException e) {
            logger.warn("Error retransforming class :" + Arrays.toString(classes), e);
        }
    }
}

