/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.TranformationInfoCache;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.util.collections.SlowWriteExpandableArray;
import dagger.CustomImpl;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@CustomImpl
public class DefaultTranformationInfoCache
implements TranformationInfoCache {
    private final AtomicInteger transformationsCounter = new AtomicInteger(0);
    private final SlowWriteExpandableArray<TransformationInfo> transformationList = new SlowWriteExpandableArray();

    @Inject
    public DefaultTranformationInfoCache() {
    }

    @Override
    public TransformationInfo getTransformationInfo(int transformationId) {
        return (TransformationInfo)this.transformationList.get(transformationId);
    }

    @Override
    public int getTransformationId(Class<? extends AMethodInterceptor> interceptor) {
        return this.transformationsCounter.incrementAndGet();
    }

    @Override
    public void putTransformationInfo(int transformationId, TransformationInfo transformationInfo) {
        this.transformationList.put(transformationId, (Object)transformationInfo);
    }

    @Override
    public void replaceTransformationRules(Class<?> clazz, List<? extends AClassTransformationRule[]> listOfRulesToReplace) {
        if (listOfRulesToReplace == null) {
            return;
        }
        int numOfTIs = this.transformationList.size();
        String bciClassName = clazz.getName().replace('.', '/');
        for (int i = 0; i < numOfTIs; ++i) {
            TransformationInfo ti = (TransformationInfo)this.transformationList.get(i);
            if (ti == null || !ti.getClassName().equals(bciClassName)) continue;
            ti.replaceTransformationRules(listOfRulesToReplace);
        }
    }

    public AClassTransformationRule[][] getAllTransformationRulesInOrder() {
        AClassTransformationRule[][] transformationRulesList = new AClassTransformationRule[this.transformationList.size()][];
        for (int id = 1; id < this.transformationList.size(); ++id) {
            TransformationInfo info = (TransformationInfo)this.transformationList.get(id);
            if (info == null) continue;
            AClassTransformationRule[] rules = (AClassTransformationRule[])info.getMatchingTransformationRules().clone();
            transformationRulesList[id] = rules;
        }
        return transformationRulesList;
    }
}

