/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.ADeferredClassRetransformer;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.util.List;

class DeferredClassInstrumenter
extends ADeferredClassRetransformer<ClassDefinition> {
    private final IByteCodeTransformer bcTransformer;

    DeferredClassInstrumenter(Instrumentation instrumentation, IByteCodeTransformer transformer, IMemoryLimitCheck memoryLimitCheck) {
        super(instrumentation, memoryLimitCheck);
        this.bcTransformer = transformer;
    }

    @Override
    protected boolean classInspected(Class clazz, ClassLoader loader, byte[] originalBytes, List<ClassDefinition> classesToRedefine) {
        try {
            byte[] newClassBytes = this.bcTransformer.doTransform(loader, clazz.getName().replace('.', '/'), clazz, originalBytes, null);
            if (newClassBytes != null) {
                classesToRedefine.add(new ClassDefinition(clazz, newClassBytes));
            }
        }
        catch (TimeoutWaitingForLockException e) {
            logger.warn("Timout waiting for lock to instrument " + clazz.getName() + ", might try again later");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processApprovedClasses(List<ClassDefinition> classDefinitions, int numberOfSubmittedClasses) {
        ClassDefinition[] classDefinitionArray = classDefinitions.toArray(new ClassDefinition[classDefinitions.size()]);
        logger.info("Redefining " + classDefinitionArray.length + " classes out of " + numberOfSubmittedClasses + " deferred for BCI inspection");
        this.bcTransformer.setClassRedefinitionOnCurrentThread(true);
        try {
            this.instrumentation.redefineClasses(classDefinitionArray);
        }
        catch (Exception e) {
            logger.error("Error while redefining " + classDefinitionArray.length + " classes", e);
        }
        finally {
            this.bcTransformer.setClassRedefinitionOnCurrentThread(false);
        }
    }

    @Override
    public boolean areClassBytesRequired() {
        return true;
    }
}

