/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.ADeferredClassRetransformer;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;
import java.lang.instrument.Instrumentation;
import java.util.List;

class DeferredClassRetransformer
extends ADeferredClassRetransformer<Class<?>> {
    DeferredClassRetransformer(Instrumentation instrumentation, IMemoryLimitCheck memoryLimitCheck) {
        super(instrumentation, memoryLimitCheck);
    }

    @Override
    protected boolean classInspected(Class clazz, ClassLoader loader, byte[] originalBytes, List<Class<?>> approvedClasses) {
        approvedClasses.add(clazz);
        return true;
    }

    @Override
    protected void processApprovedClasses(List<Class<?>> classesToRetransform, int numberOfSubmittedClasses) {
        Class[] arrayOfClasses = classesToRetransform.toArray(new Class[classesToRetransform.size()]);
        logger.info("Re-transforming " + arrayOfClasses.length + " out of " + numberOfSubmittedClasses + " classes deferred for BCI");
        try {
            this.instrumentation.retransformClasses(arrayOfClasses);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public boolean areClassBytesRequired() {
        return false;
    }
}

