/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.kernel.spi.IClassLoaderProvider;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.lang.ref.WeakReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InstrumentationClassLoaderProvider
implements IClassLoaderProvider {
    static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ClassLoaderProvider");
    private volatile WeakReference<ClassLoader> classLoaderWeakReference;
    private final String targetClassName;

    @Inject
    public InstrumentationClassLoaderProvider(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    @Override
    public WeakReference<ClassLoader> getClassloader(String className) {
        return this.classLoaderWeakReference;
    }

    @Override
    public void checkClass(String className, ClassLoader classLoader) {
        if (this.classLoaderWeakReference == null && this.targetClassName.equals(className)) {
            logger.info("Class loader found for [" + className + "]");
            this.classLoaderWeakReference = new WeakReference<ClassLoader>(classLoader);
        }
    }
}

