/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.kernel.spi.IAgentEnvironment;
import com.singularity.ee.agent.appagent.services.bciengine.JavaAgentManifest;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassTransformationCallback;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IClassTransformation;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.lang.instrument.ClassFileTransformer;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InstrumentationHandler {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.InstrumentationHandler");
    private boolean retransformationDisabled = false;
    private final IClassTransformation classTransformation;

    @Inject
    public InstrumentationHandler(IClassTransformation classTransformation, IAgentEnvironment agentEnvironment) {
        this.classTransformation = classTransformation;
        this.retransformationDisabled = !InstrumentationHandler.isRetransformationSupported(agentEnvironment);
    }

    public boolean isRetransformClassesSupported() {
        if (this.retransformationDisabled) {
            return false;
        }
        return this.classTransformation.isRetransformClassesSupported();
    }

    public boolean isRedefineClassesSupported() {
        return this.classTransformation.isRedefineClassesSupported();
    }

    public void registerTransformer(ClassFileTransformer byteCodeTransformer) {
        logger.info(String.format("Registering class file transformer %s", byteCodeTransformer.getClass().getName()));
        this.classTransformation.registerForRetransform(byteCodeTransformer);
    }

    public boolean retransformClass(ClassTransformationCallback callback, Class<?> ... clazz) throws UnableToRetransformException {
        if (!this.isRetransformClassesSupported()) {
            logger.warn("Retransformation not enabled.");
            return false;
        }
        this.classTransformation.retransformClass(callback, clazz);
        return true;
    }

    public boolean retransformClass(ClassTransformationCallback callback, String ... className) throws UnableToRetransformException {
        if (!this.isRetransformClassesSupported()) {
            logger.warn("Retransformation not enabled.");
            return false;
        }
        this.classTransformation.retransformClass(callback, className);
        return true;
    }

    public boolean retransformClassesForRule(ClassTransformationCallback callback, Set<AClassTransformationRule> addedRules, Set<AClassTransformationRule> removedRules, boolean reTransformInPremain) throws UnableToRetransformException {
        if (!this.isRetransformClassesSupported()) {
            logger.warn("Retransformation not enabled.");
            return false;
        }
        this.classTransformation.retransformClassesForRule(callback, addedRules, removedRules, reTransformInPremain);
        return true;
    }

    private static boolean isRetransformationSupported(IAgentEnvironment agentEnvironment) {
        String installDirectory = agentEnvironment.getAgentInstallDir();
        String entryJar = agentEnvironment.getJavaAgentEntryJarName();
        if (installDirectory != null) {
            return JavaAgentManifest.parseManifest((String)installDirectory, (String)entryJar).isRetransformationSupported();
        }
        return false;
    }

    public void setRetransformationDisabled(boolean retransformationDisabled) {
        logger.info("Retransformation disabled " + retransformationDisabled);
        this.retransformationDisabled = retransformationDisabled;
    }

    public void pingForRetransform() {
        this.classTransformation.pingForRetransform();
    }
}

