/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class InstrumentationTracker {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.InstrumentationTracker");
    private static Map<String, Set<AClassTransformationRule>> instrumentationMap = new ConcurrentHashMap<String, Set<AClassTransformationRule>>();

    public static void trackInstrumentationForClass(String className, AClassTransformationRule rule) {
        if (className == null) {
            logger.warn("Attempting to track instrumentation for null className.");
            return;
        }
        String slashSeparatedClassName = className.replace('.', '/');
        Set<AClassTransformationRule> interceptorList = instrumentationMap.get(slashSeparatedClassName);
        if (interceptorList == null) {
            interceptorList = CollectionHelper.createSynchronizedHashSet(new AClassTransformationRule[0]);
            instrumentationMap.put(slashSeparatedClassName, interceptorList);
        }
        interceptorList.add(rule);
    }

    public static Set<AClassTransformationRule> getAllRulesForClass(String className) {
        if (className == null) {
            logger.warn("Attempting to fetch set of rules for a null className.");
            return Collections.emptySet();
        }
        String slashSeparatedClassName = className.replace('.', '/');
        return instrumentationMap.get(slashSeparatedClassName);
    }

    public static boolean isClassInstrumentedForRule(String className, AClassTransformationRule query) {
        if (className == null) {
            logger.warn("Attempting to check instrumentation for a null className.");
            return false;
        }
        String slashSeparatedClassName = className.replace('.', '/');
        Set<AClassTransformationRule> ruleList = instrumentationMap.get(slashSeparatedClassName);
        if (ruleList != null) {
            for (AClassTransformationRule rule : ruleList) {
                if (!rule.isEquivalentTo(query)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isClassInstrumented(String className) {
        if (className == null) {
            logger.warn("Attempting to check instrumentation status for a null className.");
            return false;
        }
        String slashSeparatedClassName = className.replace('.', '/');
        return instrumentationMap.containsKey(slashSeparatedClassName);
    }

    public static void clearInstrumentationForClass(String className) {
        if (className == null) {
            logger.warn("Attempting to remove instrumentation for a null className.");
            return;
        }
        String slashSeparatedClassName = className.replace('.', '/');
        instrumentationMap.remove(slashSeparatedClassName);
    }
}

